/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DatasetUtils;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.LazyDatasetBase;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.io.ILazyLoader;
import org.eclipse.january.metadata.MetadataFactory;
import org.eclipse.january.metadata.MetadataType;
import org.eclipse.january.metadata.OriginMetadata;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;
import org.eclipse.january.metadata.Transposable;

public class LazyDataset
extends LazyDatasetBase
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2467865859867440242L;
    protected Map<Class<? extends MetadataType>, List<MetadataType>> oMetadata = null;
    protected int[] oShape;
    protected long size;
    protected int dtype;
    protected int isize;
    protected ILazyLoader loader;
    protected int[] begSlice = null;
    protected int[] delSlice = null;
    protected int[] sShape = null;
    protected int[] padding = null;
    protected int[] map;

    public LazyDataset(String name, int dtype, int elements, int[] shape, ILazyLoader loader) {
        this.name = name;
        this.shape = (int[])shape.clone();
        this.oShape = this.shape;
        this.loader = loader;
        this.dtype = dtype;
        this.isize = elements;
        try {
            this.size = ShapeUtils.calcLongSize(shape);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.size = Long.MAX_VALUE;
        }
    }

    public LazyDataset(String name, int dtype, int[] shape, ILazyLoader loader) {
        this(name, dtype, 1, shape, loader);
    }

    LazyDataset(LazyDataset other) {
        this.name = other.name;
        this.shape = (int[])other.shape.clone();
        this.metadata = other.copyMetadata();
        this.oMetadata = other.oMetadata;
        this.oShape = other.oShape;
        this.size = other.size;
        this.dtype = other.dtype;
        this.isize = other.isize;
        this.loader = other.loader;
        this.begSlice = other.begSlice;
        this.delSlice = other.delSlice;
        this.sShape = other.sShape;
        this.padding = other.padding;
        this.map = other.map;
    }

    public static LazyDataset createLazyDataset(Dataset dataset) {
        return new LazyDataset(dataset.getName(), dataset.getDType(), dataset.getElementsPerItem(), dataset.getShape(), new ILazyLoader(dataset){
            private static final long serialVersionUID = -6725268922780517523L;
            final Dataset d;
            {
                this.d = dataset;
            }

            @Override
            public boolean isFileReadable() {
                return true;
            }

            @Override
            public Dataset getDataset(IMonitor mon, SliceND slice) throws IOException {
                return this.d.getSlice(mon, slice);
            }
        });
    }

    @Override
    public int getDType() {
        return this.dtype;
    }

    @Override
    public int getElementsPerItem() {
        return this.isize;
    }

    @Override
    public int getSize() {
        return (int)this.size;
    }

    public String toString() {
        int rank;
        StringBuilder out = new StringBuilder();
        if (this.name != null && this.name.length() > 0) {
            out.append("Lazy dataset '");
            out.append(this.name);
            out.append("' has shape [");
        } else {
            out.append("Lazy dataset shape is [");
        }
        int n = rank = this.shape == null ? 0 : this.shape.length;
        if (rank > 0 && this.shape[0] >= 0) {
            out.append(this.shape[0]);
        }
        int i = 1;
        while (i < rank) {
            out.append(", " + this.shape[i]);
            ++i;
        }
        out.append(']');
        return out.toString();
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.oShape);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + this.dtype;
        result = 31 * result + this.isize;
        result = 31 * result + (this.loader == null ? 0 : this.loader.hashCode());
        result = 31 * result + Arrays.hashCode(this.begSlice);
        result = 31 * result + Arrays.hashCode(this.delSlice);
        result = 31 * result + Arrays.hashCode(this.sShape);
        result = 31 * result + Arrays.hashCode(this.padding);
        result = 31 * result + Arrays.hashCode(this.map);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LazyDataset other = (LazyDataset)obj;
        if (!Arrays.equals(this.oShape, other.oShape)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.dtype != other.dtype) {
            return false;
        }
        if (this.isize != other.isize) {
            return false;
        }
        if (this.loader != other.loader) {
            return false;
        }
        if (!Arrays.equals(this.begSlice, other.begSlice)) {
            return false;
        }
        if (!Arrays.equals(this.delSlice, other.delSlice)) {
            return false;
        }
        if (!Arrays.equals(this.sShape, other.sShape)) {
            return false;
        }
        if (!Arrays.equals(this.padding, other.padding)) {
            return false;
        }
        return Arrays.equals(this.map, other.map);
    }

    @Override
    public LazyDataset clone() {
        return new LazyDataset(this);
    }

    @Override
    public void setShape(int ... shape) {
        this.setShapeInternal(shape);
    }

    @Override
    public LazyDataset squeezeEnds() {
        this.setShapeInternal(ShapeUtils.squeezeShape(this.shape, true));
        return this;
    }

    @Override
    public Dataset getSlice(int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(null, start, stop, step);
    }

    @Override
    public Dataset getSlice(Slice ... slice) throws DatasetException {
        if (slice == null || slice.length == 0) {
            return this.getSlice(null, new SliceND(this.shape));
        }
        return this.getSlice(null, new SliceND(this.shape, slice));
    }

    @Override
    public Dataset getSlice(SliceND slice) throws DatasetException {
        return this.getSlice(null, slice);
    }

    @Override
    public Dataset getSlice(IMonitor monitor, Slice ... slice) throws DatasetException {
        if (slice == null || slice.length == 0) {
            return this.getSlice(monitor, new SliceND(this.shape));
        }
        return this.getSlice(monitor, new SliceND(this.shape, slice));
    }

    @Override
    public LazyDataset getSliceView(Slice ... slice) {
        if (slice == null || slice.length == 0) {
            return this.getSliceView(new SliceND(this.shape));
        }
        return this.getSliceView(new SliceND(this.shape, slice));
    }

    private void setShapeInternal(int ... nShape) {
        if (this.size != 0L) {
            int[] pShape = LazyDataset.calcTransposed(this.map, this.sShape == null ? this.oShape : this.sShape);
            this.padding = ShapeUtils.calcShapePadding(pShape, nShape);
        }
        if (this.metadata != null) {
            this.storeMetadata(this.metadata, Reshapeable.class);
            this.metadata = this.copyMetadata();
            this.reshapeMetadata(this.shape, nShape);
        }
        this.shape = nShape;
    }

    @Override
    public LazyDataset getSliceView(int[] start, int[] stop, int[] step) {
        return this.getSliceView(new SliceND(this.shape, start, stop, step));
    }

    @Override
    public LazyDataset getSliceView(SliceND slice) {
        LazyDataset view = this.clone();
        if (slice.isAll()) {
            return view;
        }
        SliceND nslice = this.calcTrueSlice(slice);
        if (nslice != null) {
            view.begSlice = nslice.getStart();
            view.delSlice = nslice.getStep();
            view.sShape = nslice.getShape();
        }
        view.shape = slice.getShape();
        view.size = ShapeUtils.calcLongSize(view.shape);
        view.storeMetadata(this.metadata, Sliceable.class);
        view.sliceMetadata(true, slice);
        return view;
    }

    @Override
    public Dataset getSlice(IMonitor monitor, int[] start, int[] stop, int[] step) throws DatasetException {
        return this.getSlice(monitor, new SliceND(this.shape, start, stop, step));
    }

    @Override
    public Dataset getSlice(IMonitor monitor, SliceND slice) throws DatasetException {
        Dataset a;
        if (this.loader != null && !this.loader.isFileReadable()) {
            return null;
        }
        SliceND nslice = this.calcTrueSlice(slice);
        if (nslice == null) {
            a = DatasetFactory.zeros(slice.getShape(), this.getDType());
        } else {
            try {
                a = DatasetUtils.convertToDataset(this.loader.getDataset(monitor, nslice));
            }
            catch (IOException e) {
                logger.error("Problem getting {}: {}", (Object)String.format("slice %s %s %s from %s", Arrays.toString(slice.getStart()), Arrays.toString(slice.getStop()), Arrays.toString(slice.getStep()), this.loader), (Object)e);
                throw new DatasetException(e);
            }
        }
        a.setName(String.valueOf(this.name) + '[' + (nslice == null ? slice : nslice) + ']');
        if (this.metadata != null && a instanceof LazyDatasetBase) {
            LazyDatasetBase ba = (LazyDatasetBase)((Object)a);
            ba.metadata = this.copyMetadata();
            if (this.oMetadata != null) {
                ba.restoreMetadata(this.oMetadata);
            }
            if (!(nslice == null || nslice.isAll() && nslice.getMaxShape() == nslice.getShape())) {
                ba.sliceMetadata(true, nslice);
            }
        }
        if (nslice != null) {
            if (this.map != null) {
                a = a.getTransposedView(this.map);
            }
            if (this.padding != null) {
                a.setShape(slice.getShape());
            }
        }
        a.addMetadata(MetadataFactory.createMetadata(OriginMetadata.class, this, nslice == null ? slice.convertToSlice() : nslice.convertToSlice(), this.oShape, null, this.name));
        return a;
    }

    @Override
    public LazyDataset getTransposedView(int ... axes) {
        LazyDataset view = this.clone();
        int[] naxes = LazyDataset.checkPermutatedAxes(this.shape, axes);
        if (naxes == null) {
            return view;
        }
        view.shape = LazyDataset.calcTransposed(naxes, this.shape);
        if (view.size != 0L && this.padding != null) {
            int or = this.oShape.length;
            int nr = this.shape.length;
            int j = 0;
            int[] mShape = LazyDataset.calcTransposed(this.map, this.sShape == null ? this.oShape : this.sShape);
            int m = 0;
            int e = -1;
            LinkedList<Integer> uaxes = new LinkedList<Integer>();
            int[] nArray = naxes;
            int n = naxes.length;
            int n2 = 0;
            while (n2 < n) {
                int a = nArray[n2];
                uaxes.add(a);
                ++n2;
            }
            ArrayList<Integer> oList = new ArrayList<Integer>();
            int np = this.padding.length;
            int i = 0;
            while (i < np) {
                int k;
                int p = this.padding[i];
                if (p > 0) {
                    k = 0;
                    while (k < p) {
                        uaxes.remove((Object)j);
                        ++k;
                        ++j;
                    }
                } else if (p == 0) {
                    if (mShape[m] == 1) {
                        e = m;
                    }
                    ++j;
                    ++m;
                } else {
                    p = -p;
                    k = 0;
                    while (k < p) {
                        e = LazyDataset.find(mShape, 1, e + 1);
                        oList.add(e);
                        ++k;
                    }
                }
                ++i;
            }
            int[] omitted = new int[oList.size()];
            j = 0;
            for (Integer o : oList) {
                omitted[j++] = o;
            }
            int[] used = new int[or - omitted.length];
            j = 0;
            int i2 = 0;
            while (i2 < or) {
                if (Arrays.binarySearch(omitted, i2) < 0) {
                    used[j++] = i2;
                }
                ++i2;
            }
            int[] vaxes = new int[uaxes.size()];
            j = 0;
            int i3 = 0;
            while (i3 < nr) {
                int l = uaxes.indexOf(i3);
                if (l >= 0) {
                    vaxes[l] = used[j++];
                }
                ++i3;
            }
            int[] taxes = new int[or];
            j = 0;
            int i4 = 0;
            while (i4 < or) {
                taxes[i4] = Arrays.binarySearch(omitted, i4) >= 0 ? i4 : vaxes[j++];
                ++i4;
            }
            naxes = taxes;
        }
        int[] nArray = view.map = this.map == null ? naxes : LazyDataset.calcTransposed(naxes, this.map);
        if (view.size != 0L) {
            int[] tShape = LazyDataset.calcTransposed(view.map, this.sShape == null ? this.oShape : this.sShape);
            try {
                view.padding = ShapeUtils.calcShapePadding(tShape, view.shape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(String.valueOf(e.getMessage()) + ": " + Arrays.toString(tShape) + " cf " + Arrays.toString(view.shape));
            }
        }
        view.storeMetadata(this.metadata, Transposable.class);
        view.transposeMetadata(axes);
        return view;
    }

    private static int find(int[] map, int m, int off) {
        int i = off;
        int imax = map.length;
        while (i < imax) {
            if (map[i] == m) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int[] calcTransposed(int[] map, int[] values) {
        if (values == null) {
            return null;
        }
        int r = values.length;
        if (map == null || r < 2) {
            return values;
        }
        int[] ovalues = new int[r];
        int i = 0;
        while (i < r) {
            ovalues[i] = values[map[i]];
            ++i;
        }
        return ovalues;
    }

    protected final SliceND calcTrueSlice(SliceND slice) {
        int i;
        int[] nstep;
        int[] nstart;
        int[] nshape;
        if (slice == null) {
            slice = new SliceND(this.shape);
        }
        if (ShapeUtils.calcLongSize(slice.getShape()) == 0L) {
            return null;
        }
        int r = this.oShape.length;
        if (this.padding == null) {
            nshape = slice.getShape();
            nstart = slice.getStart();
            nstep = slice.getStep();
        } else {
            int[] lshape = slice.getShape();
            int[] lstart = slice.getStart();
            int[] lstep = slice.getStep();
            nstart = new int[r];
            nstep = new int[r];
            nshape = new int[r];
            i = 0;
            int j = 0;
            int[] nArray = this.padding;
            int n = this.padding.length;
            int n2 = 0;
            while (n2 < n) {
                int p = nArray[n2];
                if (p == 0) {
                    nshape[i] = lshape[j];
                    nstart[i] = lstart[j];
                    nstep[i] = lstep[j];
                    ++i;
                    ++j;
                } else if (p < 0) {
                    int imax = i - p;
                    while (i < imax) {
                        nshape[i] = 1;
                        nstep[i] = 1;
                        ++i;
                    }
                } else {
                    j += p;
                }
                ++n2;
            }
        }
        if (this.map != null && r > 1) {
            int[] pshape = new int[r];
            int[] pstart = new int[r];
            int[] pstep = new int[r];
            i = 0;
            while (i < r) {
                int m = this.map[i];
                pshape[m] = nshape[i];
                pstart[m] = nstart[i];
                pstep[m] = nstep[i];
                ++i;
            }
            nshape = pshape;
            nstart = pstart;
            nstep = pstep;
        }
        int[] nstop = new int[r];
        if (this.begSlice != null) {
            int i2 = 0;
            while (i2 < r) {
                int nd;
                int b = this.begSlice[i2];
                int d = this.delSlice[i2];
                nstart[i2] = b + nstart[i2] * d;
                nstep[i2] = nd = nstep[i2] * d;
                nstop[i2] = nstart[i2] + (nshape[i2] - 1) * nd + (nd >= 0 ? 1 : -1);
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < r) {
                int d = nstep[i3];
                nstop[i3] = nstart[i3] + (nshape[i3] - 1) * d + (d >= 0 ? 1 : -1);
                ++i3;
            }
        }
        return this.createSlice(nstart, nstop, nstep);
    }

    protected SliceND createSlice(int[] nstart, int[] nstop, int[] nstep) {
        return SliceND.createSlice(this.oShape, null, nstart, nstop, nstep);
    }

    final IDataset transformInput(IDataset data, SliceND tslice) {
        if (this.padding != null) {
            data = data.getSliceView(new Slice[0]);
            int[] nshape = tslice.getShape();
            data.setShape(nshape);
        }
        return this.map == null ? data : data.getTransposedView(this.map);
    }

    private void storeMetadata(Map<Class<? extends MetadataType>, List<MetadataType>> origMetadata, Class<? extends Annotation> aclazz) {
        List<Class<? extends MetadataType>> mclazzes = this.findAnnotatedMetadata(aclazz);
        if (mclazzes.size() == 0) {
            return;
        }
        if (this.oMetadata == null) {
            this.oMetadata = new HashMap<Class<? extends MetadataType>, List<MetadataType>>();
        }
        for (Class<? extends MetadataType> mc : mclazzes) {
            if (this.oMetadata.containsKey(mc)) continue;
            List<MetadataType> l = origMetadata.get(mc);
            ArrayList<MetadataType> nl = new ArrayList<MetadataType>(l.size());
            for (MetadataType m : l) {
                nl.add(m.clone());
            }
            this.oMetadata.put(mc, nl);
        }
    }

    private List<Class<? extends MetadataType>> findAnnotatedMetadata(Class<? extends Annotation> aclazz) {
        ArrayList<Class<? extends MetadataType>> mclazzes = new ArrayList<Class<? extends MetadataType>>();
        if (this.metadata == null) {
            return mclazzes;
        }
        for (Class c : this.metadata.keySet()) {
            boolean hasAnn = false;
            for (MetadataType m : (List)this.metadata.get(c)) {
                if (m == null) continue;
                Class<?> mc = m.getClass();
                do {
                    Field[] fieldArray = mc.getDeclaredFields();
                    int n = fieldArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field f = fieldArray[n2];
                        if (f.isAnnotationPresent(aclazz)) {
                            hasAnn = true;
                            break;
                        }
                        ++n2;
                    }
                    Class<?> sclazz = mc.getSuperclass();
                    if (!MetadataType.class.isAssignableFrom(sclazz)) break;
                    mc = sclazz;
                } while (!hasAnn);
                if (hasAnn) break;
            }
            if (!hasAnn) continue;
            mclazzes.add(c);
        }
        return mclazzes;
    }

    public static int getMaxSliceLength(ILazyDataset lazySet, int dimension) {
        double size = DTypeUtils.getItemBytes(DTypeUtils.getDTypeFromClass(lazySet.getElementClass()), lazySet.getElementsPerItem());
        double max = Math.max(Runtime.getRuntime().totalMemory(), Runtime.getRuntime().maxMemory());
        double space = max / (double)lazySet.getSize();
        int[] shape = lazySet.getShape();
        if (space >= size) {
            return shape[dimension];
        }
        double sizeOneSlice = size;
        int dim = 0;
        while (dim < shape.length) {
            if (dim != dimension) {
                sizeOneSlice *= (double)shape[dim];
            }
            ++dim;
        }
        double avail = max / sizeOneSlice;
        if (avail < 1.0) {
            return 1;
        }
        return (int)Math.floor(avail / 4.0);
    }
}

