/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.apache.commons.math3.complex.Complex;
import org.eclipse.january.MetadataException;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ComplexDoubleDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.IndexIterator;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.StatisticsMetadata;
import org.junit.Assert;
import org.junit.Test;

public class DoubleDatasetTest {
    @Test
    public void testConstructor() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
        DoubleDataset b = new DoubleDataset(da, new int[]{3, 4});
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i2));
            ++i2;
        }
        DoubleDataset c = new DoubleDataset(a.getSliceView(new int[]{1}, null, new int[]{2}));
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(2 * i3 + 1), (double)c.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i3));
            ++i3;
        }
        a.hashCode();
        b.hashCode();
        c.hashCode();
    }

    @Test
    public void testClone() {
        DoubleDataset z = new DoubleDataset();
        TestUtils.assertDatasetEquals((Dataset)z, (Dataset)z.clone());
        double[] da = null;
        try {
            z = new DoubleDataset(da, new int[0]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        da = new double[]{};
        z = new DoubleDataset(da, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)z, (Dataset)z.clone());
        z = new DoubleDataset(new int[]{0});
        TestUtils.assertDatasetEquals((Dataset)z, (Dataset)z.clone());
        z = new DoubleDataset(new int[]{0, 1});
        TestUtils.assertDatasetEquals((Dataset)z, (Dataset)z.clone());
        da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)a.clone());
    }

    @Test
    public void testGetter() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        int l = da.length;
        int i = 0;
        while (i < l) {
            Assert.assertEquals((double)i, (double)a.getDouble(i), (double)(1.0E-5 * (double)i));
            ++i;
        }
        i = 0;
        while (i < l) {
            int r = l - 1 - i;
            Assert.assertEquals((double)r, (double)a.getDouble(-(i + 1)), (double)(1.0E-5 * (double)r));
            ++i;
        }
        Dataset sv = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        Dataset sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(7))});
        l = sc.getSize();
        int i2 = 0;
        while (i2 < l) {
            double r = sc.getDouble(-(i2 + 1));
            Assert.assertEquals((double)r, (double)sv.getDouble(-(i2 + 1)), (double)(1.0E-5 * r));
            ++i2;
        }
        Assert.assertEquals((double)0.0, (double)a.getDouble(), (double)1.0E-16);
        try {
            a.getDouble(null);
            Assert.fail((String)"Should have thrown an NPE");
        }
        catch (NullPointerException nullPointerException) {}
        try {
            a.getDouble(new int[2]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            a.getDouble(0, 0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        sc = a.getSlice(new Slice[]{new Slice(Integer.valueOf(7), Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0}), (Dataset)sc);
        Dataset b = a.reshape(new int[]{4, 3});
        try {
            b.getDouble(new int[1]);
            Assert.fail((String)"Should have thrown an IAE");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        try {
            b.getDouble(0);
            Assert.fail((String)"Should have thrown a UOE");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        sc = b.getSlice(new Slice[]{new Slice(Integer.valueOf(7), Integer.valueOf(2))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0, 3}), (Dataset)sc);
        sc = b.getSlice(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(5), Integer.valueOf(-1))});
        TestUtils.assertDatasetEquals((Dataset)new DoubleDataset(new int[]{0, 3}), (Dataset)sc);
    }

    @Test
    public void testCreators() {
        double dz = 0.5;
        DoubleDataset z = DoubleDataset.createFromObject((Object)dz);
        Assert.assertEquals((long)0L, (long)z.getRank());
        Assert.assertEquals((long)1L, (long)z.getSize());
        Assert.assertEquals((double)dz, (double)z.getElementDoubleAbs(0), (double)1.0E-14);
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0};
        DoubleDataset a = DoubleDataset.createFromObject((Object)da);
        Assert.assertEquals((long)1L, (long)a.getRank());
        Assert.assertEquals((long)6L, (long)a.getSize());
        Assert.assertEquals((long)6L, (long)a.getShape()[0]);
        IndexIterator it = a.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i, (double)a.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i));
            ++i;
        }
        double[][] db = new double[][]{{0.0, 1.0, 2.0}, {3.0, 4.0, 5.0}};
        DoubleDataset b = DoubleDataset.createFromObject((Object)db);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertEquals((long)6L, (long)b.getSize());
        Assert.assertEquals((long)2L, (long)b.getShape()[0]);
        Assert.assertEquals((long)3L, (long)b.getShape()[1]);
        it = b.getIterator();
        int i2 = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)i2, (double)b.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i2));
            ++i2;
        }
        double[][] dc = new double[][]{{0.0, 1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}};
        DoubleDataset c = DoubleDataset.createFromObject((Object)dc);
        Assert.assertEquals((long)2L, (long)c.getRank());
        Assert.assertEquals((long)8L, (long)c.getSize());
        Assert.assertEquals((long)2L, (long)c.getShape()[0]);
        Assert.assertEquals((long)4L, (long)c.getShape()[1]);
        it = c.getIterator();
        int i3 = 0;
        while (it.hasNext()) {
            if (i3 < 7) {
                Assert.assertEquals((double)i3, (double)c.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i3));
            } else {
                Assert.assertEquals((double)0.0, (double)c.getElementDoubleAbs(it.index), (double)1.0E-15);
            }
            ++i3;
        }
        double[][] dd = new double[][]{{0.0, 1.0, 2.0}, {4.0, 5.0, 6.0, 7.0}};
        DoubleDataset d = DoubleDataset.createFromObject((Object)dd);
        Assert.assertEquals((long)2L, (long)d.getRank());
        Assert.assertEquals((long)8L, (long)d.getSize());
        Assert.assertEquals((long)2L, (long)d.getShape()[0]);
        Assert.assertEquals((long)4L, (long)d.getShape()[1]);
        it = d.getIterator();
        int i4 = 0;
        while (it.hasNext()) {
            if (i4 != 3) {
                Assert.assertEquals((double)i4, (double)d.getElementDoubleAbs(it.index), (double)(1.0E-15 * (double)i4));
            } else {
                Assert.assertEquals((double)0.0, (double)d.getElementDoubleAbs(it.index), (double)1.0E-15);
            }
            ++i4;
        }
    }

    @Test
    public void testRange() {
        DoubleDataset a = DoubleDataset.createRange((double)2.0, (double)12.4, (double)4.3);
        DoubleDataset e = new DoubleDataset(new double[]{2.0, 6.3, 10.6}, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)12.4, (double)2.0, (double)-4.3);
        e = new DoubleDataset(new double[]{12.4, 8.1, 3.8}, new int[0]);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)2.0, (double)12.4, (double)-4.3);
        e = new DoubleDataset(new int[]{0});
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
        a = DoubleDataset.createRange((double)12.4, (double)2.0, (double)4.3);
        TestUtils.assertDatasetEquals((Dataset)e, (Dataset)a);
    }

    @Test
    public void testStats() {
        DoubleDataset a = DatasetFactory.createRange((double)12.0);
        Assert.assertEquals((double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)0.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.5, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.605551275463989, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)13.0, (double)a.variance(), (double)1.0E-6);
        a.setShape(new int[]{3, 1, 4});
        Dataset b = a.sum(0, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{1, 4}, (int[])b.getShapeRef());
        Assert.assertEquals((double)12.0, (double)b.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((double)15.0, (double)b.getDouble(0, 1), (double)1.0E-6);
        Assert.assertEquals((double)18.0, (double)b.getDouble(0, 2), (double)1.0E-6);
        Assert.assertEquals((double)21.0, (double)b.getDouble(0, 3), (double)1.0E-6);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{16.0, 16.0, 16.0, 16.0}, (int[])new int[]{1, 4}), (Dataset)a.variance(0));
        b = a.sum(1, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 4}, (int[])b.getShapeRef());
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((int[])new int[]{3, 4}), (Dataset)a.variance(1));
        Assert.assertEquals((Object)a.getView(true).squeeze(), (Object)b);
        b = a.sum(2, new boolean[0]);
        Assert.assertEquals((long)2L, (long)b.getRank());
        Assert.assertArrayEquals((int[])new int[]{3, 1}, (int[])b.getShapeRef());
        Assert.assertEquals((double)6.0, (double)b.getDouble(0, 0), (double)1.0E-6);
        Assert.assertEquals((double)22.0, (double)b.getDouble(1, 0), (double)1.0E-6);
        Assert.assertEquals((double)38.0, (double)b.getDouble(2, 0), (double)1.0E-6);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.666666666667, 1.666666666667, 1.666666666667}, (int[])new int[]{3, 1}), (Dataset)a.variance(2));
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{1.25, 1.25, 1.25}, (int[])new int[]{3, 1}), (Dataset)a.variance(2, true, new boolean[0]));
        a.setShape(new int[]{12});
        a.set((Object)-1, 0);
        Assert.assertEquals((double)-1.0, (double)a.min(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)11.0, (double)a.max(new boolean[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)5.41666667, (double)((Number)a.mean(new boolean[0])).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)3.75277675, (double)a.stdDeviation(), (double)1.0E-6);
        Assert.assertEquals((double)14.0833333, (double)a.variance(), (double)1.0E-6);
        a = DatasetFactory.createRange((double)60.0).reshape(new int[]{4, 3, 5});
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        Assert.assertEquals((double)a.max(new boolean[0]).doubleValue(), (double)a.max(nArray, new boolean[0]).getDouble(), (double)1.0E-6);
        Dataset c = a.sum(2, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{4, 3}, (int[])c.getShapeRef());
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(new int[]{2}, new boolean[0]));
        c = c.sum(0, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])c.getShapeRef());
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(nArray2, new boolean[0]));
        c = a.sum(0, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{3, 5}, (int[])c.getShapeRef());
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(new int[1], new boolean[0]));
        c = c.sum(1, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{3}, (int[])c.getShapeRef());
        int[] nArray3 = new int[2];
        nArray3[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c, (Dataset)a.sum(nArray3, new boolean[0]));
        c = a.product(2, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{4, 3}, (int[])c.getShapeRef());
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.product(0, new boolean[0]), (Dataset)a.product(nArray4, new boolean[0]));
        c = a.product(0, new boolean[0]);
        Assert.assertArrayEquals((int[])new int[]{3, 5}, (int[])c.getShapeRef());
        int[] nArray5 = new int[2];
        nArray5[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)c.product(1, new boolean[0]), (Dataset)a.product(nArray5, new boolean[0]));
        int[] nArray6 = new int[2];
        nArray6[1] = 2;
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.createFromObject((Object)new double[]{49.0, 49.0, 49.0}), (Dataset)a.peakToPeak(nArray6, new boolean[0]));
    }

    @Test
    public void testShapeChangingStats() throws MetadataException {
        Dataset a = DatasetFactory.createRange((double)12.0).reshape(new int[]{3, 4});
        a.max(new boolean[0]);
        a.setShape(new int[]{3, 1, 4});
        Dataset b = a.getView(true);
        Assert.assertNull((Object)b.getMetadata(StatisticsMetadata.class));
    }

    @Test
    public void testMaths() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Dataset r = Maths.add((Object)a, (Object)a);
        IndexIterator it = r.getIterator();
        int i = 0;
        while (it.hasNext()) {
            Assert.assertEquals((double)(2.0 * (double)i), (double)r.getElementDoubleAbs(it.index), (double)(1.0E-5 * (double)i));
            ++i;
        }
    }

    @Test
    public void testPosition() {
        double[] da = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
        DoubleDataset a = new DoubleDataset(da, new int[0]);
        Assert.assertEquals((long)6L, (long)a.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)a.minPos(new boolean[0])[0]);
        DoubleDataset b = DatasetFactory.zeros((int[])new int[]{100, 200});
        b.set((Object)100.0, 50, 100);
        b.set((Object)-100.0, 51, 101);
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)51L, (long)b.minPos(new boolean[0])[0]);
        Assert.assertEquals((long)101L, (long)b.minPos(new boolean[0])[1]);
        b.set((Object)Double.NaN, 52, 53);
        Assert.assertEquals((long)52L, (long)b.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)53L, (long)b.maxPos(new boolean[0])[1]);
        Assert.assertEquals((long)50L, (long)b.maxPos(new boolean[]{true})[0]);
        Assert.assertEquals((long)100L, (long)b.maxPos(new boolean[]{true})[1]);
        DoubleDataset c = DatasetFactory.zeros((int[])new int[]{100, 200});
        c.set((Object)100.0, 99, 50);
        c.set((Object)99.99, 50, 50);
        Assert.assertEquals((long)99L, (long)c.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)50L, (long)c.maxPos(new boolean[0])[1]);
        c.set((Object)101, 0, 0);
        Assert.assertEquals((long)0L, (long)c.maxPos(new boolean[0])[0]);
        Assert.assertEquals((long)0L, (long)c.maxPos(new boolean[0])[1]);
    }

    @Test
    public void testInplaceMethods() {
        DoubleDataset a = DatasetFactory.createRange((double)6.0);
        DoubleDataset b = DatasetFactory.createRange((double)6.0);
        Dataset bl = DatasetFactory.createRange(LongDataset.class, (double)6.0);
        Dataset c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.iadd((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.iadd((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)3), (Dataset)c.iadd((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)3L), (Dataset)c.iadd((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        c.iadd((Object)b);
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)b), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)2), (Dataset)c);
        c = a.clone();
        c.iadd((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)Maths.add((Object)a, (Object)bl), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)2L), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.isubtract((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.isubtract((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.subtract((Object)a, (Object)3), (Dataset)c.isubtract((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.subtract((Object)a, (Object)3L), (Dataset)c.isubtract((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        c.isubtract((Object)b);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)0), (Dataset)c);
        c = a.clone();
        c.isubtract((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)0), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.imultiply((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.imultiply((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)3), (Dataset)c.imultiply((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)3L), (Dataset)c.imultiply((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)b), (Dataset)c.imultiply((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.multiply((Object)a, (Object)bl), (Dataset)c.imultiply((Object)bl));
        c = a.clone();
        c.imultiply((Object)b);
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)2), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.square((Object)a), (Dataset)c);
        c = a.clone();
        c.imultiply((Object)bl);
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)2L), (Dataset)c);
        TestUtils.assertDatasetEquals((Dataset)Maths.square((Object)a), (Dataset)c);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.idivide((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.idivide((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.divide((Object)a, (Object)3), (Dataset)c.idivide((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.divide((Object)a, (Object)3L), (Dataset)c.idivide((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        Dataset t = DatasetFactory.ones((Dataset)a);
        t.set((Object)Double.NaN, 0);
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.idivide((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.idivide((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)DatasetFactory.zeros((Dataset)a), (Dataset)c.iremainder((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.remainder((Object)a, (Object)3), (Dataset)c.iremainder((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.remainder((Object)a, (Object)3L), (Dataset)c.iremainder((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        t = DatasetFactory.zeros((Dataset)a);
        t.set((Object)Double.NaN, 0);
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.iremainder((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)t, (Dataset)c.iremainder((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)b), (Dataset)c.ipower((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)bl), (Dataset)c.ipower((Object)bl));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)b.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)bl.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)b), (Dataset)c.ipower((Object)b));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)bl), (Dataset)c.ipower((Object)bl));
        ComplexDoubleDataset z = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)a, (Object)DatasetFactory.zeros((Dataset)a));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)a, (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)3), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)z).cast(DoubleDataset.class), (Dataset)c.ipower((Object)z));
        z = (ComplexDoubleDataset)DatasetFactory.createComplexDataset(ComplexDoubleDataset.class, (Object)a, (Object)a);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)new Complex(1.0, 1.0)).cast(DoubleDataset.class), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)new Complex(3.0, 3.0)).cast(DoubleDataset.class), (Dataset)c.ipower((Object)z.getSliceView(new Slice[]{new Slice(Integer.valueOf(3), Integer.valueOf(4))})));
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.power((Object)a, (Object)z).cast(DoubleDataset.class), (Dataset)c.ipower((Object)z));
        a = Maths.multiply((Object)a, (Object)1.5);
        c = a.clone();
        TestUtils.assertDatasetEquals((Dataset)Maths.floor((Object)a), (Dataset)c.ifloor());
    }
}

