/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.io.IOException;
import java.util.Arrays;
import org.eclipse.january.DatasetException;
import org.eclipse.january.IMonitor;
import org.eclipse.january.dataset.DTypeUtils;
import org.eclipse.january.dataset.DataEvent;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.IDataset;
import org.eclipse.january.dataset.ILazyWriteableDataset;
import org.eclipse.january.dataset.LazyDataset;
import org.eclipse.january.dataset.LazyDynamicDataset;
import org.eclipse.january.dataset.ShapeUtils;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.dataset.SliceND;
import org.eclipse.january.io.ILazyAsyncSaver;
import org.eclipse.january.io.ILazySaver;

public class LazyWriteableDataset
extends LazyDynamicDataset
implements ILazyWriteableDataset {
    private static final long serialVersionUID = -679846418938412535L;
    private int[] chunks;
    private ILazySaver saver;
    private Object fillValue;
    private boolean writeAsync;

    public LazyWriteableDataset(String name, int dtype, int elements, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        super(name, dtype, elements, shape, maxShape, saver);
        this.chunks = chunks == null ? null : (int[])chunks.clone();
        this.saver = saver;
        this.size = ShapeUtils.calcLongSize(this.shape);
    }

    public LazyWriteableDataset(String name, int dtype, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(name, dtype, 1, shape, maxShape, chunks, saver);
    }

    public LazyWriteableDataset(String name, Class<?> clazz, int elements, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(name, DTypeUtils.getDTypeFromClass(clazz), elements, shape, maxShape, chunks, saver);
    }

    public LazyWriteableDataset(String name, Class<?> clazz, int[] shape, int[] maxShape, int[] chunks, ILazySaver saver) {
        this(name, DTypeUtils.getDTypeFromClass(clazz), 1, shape, maxShape, chunks, saver);
    }

    public static LazyWriteableDataset createLazyDataset(Dataset dataset) {
        return LazyWriteableDataset.createLazyDataset(dataset, null);
    }

    public static LazyWriteableDataset createLazyDataset(Dataset dataset, int[] maxShape) {
        return new LazyWriteableDataset(dataset.getName(), dataset.getDType(), dataset.getElementsPerItem(), dataset.getShape(), maxShape, null, new ILazySaver(dataset){
            private static final long serialVersionUID = 1366057382940519510L;
            Dataset d;
            {
                this.d = dataset;
            }

            @Override
            public boolean isFileReadable() {
                return true;
            }

            @Override
            public boolean isFileWriteable() {
                return true;
            }

            @Override
            public void initialize() throws IOException {
            }

            @Override
            public Dataset getDataset(IMonitor mon, SliceND slice) throws IOException {
                return this.d.getSlice(mon, slice);
            }

            @Override
            public void setSlice(IMonitor mon, IDataset data, SliceND slice) throws IOException {
                if (slice.isExpanded()) {
                    Dataset od = this.d;
                    this.d = DatasetFactory.zeros(od.getClass(), slice.getSourceShape());
                    this.d.setSlice((Object)od, SliceND.createSlice(od, null, null));
                }
                this.d.setSlice((Object)data, slice);
            }
        });
    }

    @Override
    public int[] getChunking() {
        return this.chunks;
    }

    @Override
    public void setChunking(int ... chunks) {
        this.chunks = chunks == null ? null : (int[])chunks.clone();
    }

    @Override
    public LazyWriteableDataset clone() {
        LazyWriteableDataset ret = new LazyWriteableDataset(new String(this.name), this.getDType(), this.getElementsPerItem(), this.oShape, this.maxShape, this.chunks, this.saver);
        ret.shape = this.shape;
        ret.size = this.size;
        ret.prepShape = this.prepShape;
        ret.postShape = this.postShape;
        ret.begSlice = this.begSlice;
        ret.delSlice = this.delSlice;
        ret.map = this.map;
        ret.base = this.base;
        ret.metadata = this.copyMetadata();
        ret.oMetadata = this.oMetadata;
        ret.eventDelegate = this.eventDelegate;
        return ret;
    }

    @Override
    public LazyWriteableDataset getSliceView(int[] start, int[] stop, int[] step) {
        return (LazyWriteableDataset)super.getSliceView(start, stop, step);
    }

    @Override
    public LazyWriteableDataset getSliceView(Slice ... slice) {
        return (LazyWriteableDataset)super.getSliceView(slice);
    }

    @Override
    public LazyWriteableDataset getSliceView(SliceND slice) {
        return (LazyWriteableDataset)super.getSliceView(slice);
    }

    @Override
    public LazyWriteableDataset getTransposedView(int ... axes) {
        return (LazyWriteableDataset)super.getTransposedView(axes);
    }

    @Override
    public void setWritingAsync(boolean async) {
        this.writeAsync = async;
    }

    public void setSlice(IDataset data, SliceND slice) throws DatasetException {
        this.setSlice(null, data, slice);
    }

    @Override
    public void setSlice(IMonitor monitor, IDataset data, int[] start, int[] stop, int[] step) throws DatasetException {
        this.internalSetSlice(monitor, this.writeAsync, data, new SliceND(this.shape, this.maxShape, start, stop, step));
    }

    @Override
    public void setSlice(IMonitor monitor, IDataset data, SliceND slice) throws DatasetException {
        this.internalSetSlice(monitor, this.writeAsync, data, slice);
    }

    @Override
    public void setSliceSync(IMonitor monitor, IDataset data, SliceND slice) throws DatasetException {
        this.internalSetSlice(monitor, false, data, slice);
    }

    private void internalSetSlice(IMonitor monitor, boolean async, IDataset data, SliceND slice) throws DatasetException {
        int[] dshape;
        int[] nArray = dshape = data instanceof Dataset ? ((Dataset)data).getShapeRef() : data.getShape();
        if (dshape.length == 0) {
            dshape = new int[]{1};
        }
        if (!Arrays.equals(slice.getShape(), dshape)) {
            data = data.getSliceView(new Slice[0]);
            data.setShape(slice.getShape());
        }
        SliceND nslice = this.calcTrueSlice(slice);
        data = this.transformInput(data);
        if (this.base != null) {
            ((ILazyWriteableDataset)((Object)this.base)).setSlice(monitor, data, nslice);
        } else {
            if (this.saver == null) {
                throw new DatasetException("Cannot write to file as saver not defined!");
            }
            try {
                if (async && this.saver instanceof ILazyAsyncSaver) {
                    ((ILazyAsyncSaver)this.saver).setSliceAsync(monitor, data, nslice);
                } else {
                    if (!this.saver.isFileWriteable()) {
                        throw new DatasetException("Cannot write to file as it is not writeable!");
                    }
                    this.saver.setSlice(monitor, data, nslice);
                }
            }
            catch (IOException e) {
                throw new DatasetException("Could not save dataset", e);
            }
            if (!this.refreshShape()) {
                this.eventDelegate.fire(new DataEvent(this.name, this.shape));
            }
        }
    }

    @Override
    public void setSaver(ILazySaver saver) {
        this.saver = saver;
        this.loader = saver;
    }

    @Override
    protected SliceND createSlice(int[] nstart, int[] nstop, int[] nstep) {
        if (this.base == null) {
            return new SliceND(this.oShape, this.maxShape, nstart, nstop, nstep);
        }
        return this.base.createSlice(nstart, nstop, nstep);
    }

    @Override
    public Object getFillValue() {
        return this.fillValue;
    }

    @Override
    public void setFillValue(Object fill) {
        this.fillValue = fill;
    }

    public static /* bridge */ /* synthetic */ LazyDataset createLazyDataset(Dataset dataset) {
        return LazyWriteableDataset.createLazyDataset(dataset);
    }
}

