/*
 * generated by Xtext 2.10.0
 */
package org.eclipse.january.geometry.xtext.serializer;

import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.january.geometry.Face;
import org.eclipse.january.geometry.Geometry;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.Material;
import org.eclipse.january.geometry.PolyShape;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.VertexSource;
import org.eclipse.january.geometry.xtext.services.OBJGrammarAccess;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Parameter;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.serializer.ISerializationContext;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class OBJSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private OBJGrammarAccess grammarAccess;
	
	@Override
	public void sequence(ISerializationContext context, EObject semanticObject) {
		EPackage epackage = semanticObject.eClass().getEPackage();
		ParserRule rule = context.getParserRule();
		Action action = context.getAssignedAction();
		Set<Parameter> parameters = context.getEnabledBooleanParameters();
		if (epackage == GeometryPackage.eINSTANCE)
			switch (semanticObject.eClass().getClassifierID()) {
			case GeometryPackage.FACE:
				sequence_Face(context, (Face) semanticObject); 
				return; 
			case GeometryPackage.GEOMETRY:
				sequence_Geometry(context, (Geometry) semanticObject); 
				return; 
			case GeometryPackage.MATERIAL:
				sequence_Material(context, (Material) semanticObject); 
				return; 
			case GeometryPackage.POLY_SHAPE:
				sequence_PolyShape(context, (PolyShape) semanticObject); 
				return; 
			case GeometryPackage.VERTEX:
				if (rule == grammarAccess.getTextureVertexRule()) {
					sequence_TextureVertex(context, (Vertex) semanticObject); 
					return; 
				}
				else if (rule == grammarAccess.getVertexRule()) {
					sequence_Vertex(context, (Vertex) semanticObject); 
					return; 
				}
				else break;
			case GeometryPackage.VERTEX_SOURCE:
				sequence_VertexSource(context, (VertexSource) semanticObject); 
				return; 
			}
		if (errorAcceptor != null)
			errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Contexts:
	 *     Face returns Face
	 *
	 * Constraint:
	 *     (vertexIndices+=EInt (textureIndices+=EInt | textureIndices+=EInt)?)*
	 */
	protected void sequence_Face(ISerializationContext context, Face semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Geometry returns Geometry
	 *
	 * Constraint:
	 *     (vertexSources+=VertexSource | nodes+=PolyShape)+
	 */
	protected void sequence_Geometry(ISerializationContext context, Geometry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Material returns Material
	 *
	 * Constraint:
	 *     phongMatName=EString
	 */
	protected void sequence_Material(ISerializationContext context, Material semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, GeometryPackage.Literals.MATERIAL__PHONG_MAT_NAME) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeometryPackage.Literals.MATERIAL__PHONG_MAT_NAME));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getMaterialAccess().getPhongMatNameEStringParserRuleCall_1_0(), semanticObject.getPhongMatName());
		feeder.finish();
	}
	
	
	/**
	 * Contexts:
	 *     PolyShape returns PolyShape
	 *
	 * Constraint:
	 *     (materialFiles+=EString* name=EString? material=Material? faces+=Face*)
	 */
	protected void sequence_PolyShape(ISerializationContext context, PolyShape semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     TextureVertex returns Vertex
	 *
	 * Constraint:
	 *     (x=EDouble y=EDouble z=EDouble?)
	 */
	protected void sequence_TextureVertex(ISerializationContext context, Vertex semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     VertexSource returns VertexSource
	 *
	 * Constraint:
	 *     (materialFiles+=EString* (vertices+=Vertex | textureCoordinates+=TextureVertex)*)
	 */
	protected void sequence_VertexSource(ISerializationContext context, VertexSource semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Contexts:
	 *     Vertex returns Vertex
	 *
	 * Constraint:
	 *     (x=EDouble y=EDouble z=EDouble)
	 */
	protected void sequence_Vertex(ISerializationContext context, Vertex semanticObject) {
		if (errorAcceptor != null) {
			if (transientValues.isValueTransient(semanticObject, GeometryPackage.Literals.VERTEX__X) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeometryPackage.Literals.VERTEX__X));
			if (transientValues.isValueTransient(semanticObject, GeometryPackage.Literals.VERTEX__Y) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeometryPackage.Literals.VERTEX__Y));
			if (transientValues.isValueTransient(semanticObject, GeometryPackage.Literals.VERTEX__Z) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, GeometryPackage.Literals.VERTEX__Z));
		}
		SequenceFeeder feeder = createSequencerFeeder(context, semanticObject);
		feeder.accept(grammarAccess.getVertexAccess().getXEDoubleParserRuleCall_1_0(), semanticObject.getX());
		feeder.accept(grammarAccess.getVertexAccess().getYEDoubleParserRuleCall_2_0(), semanticObject.getY());
		feeder.accept(grammarAccess.getVertexAccess().getZEDoubleParserRuleCall_3_0(), semanticObject.getZ());
		feeder.finish();
	}
	
	
}
