/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.geometry.impl;

import java.util.Collection;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.january.geometry.Face;
import org.eclipse.january.geometry.Geometry;
import org.eclipse.january.geometry.GeometryFactory;
import org.eclipse.january.geometry.GeometryPackage;
import org.eclipse.january.geometry.INode;
import org.eclipse.january.geometry.PolyShape;
import org.eclipse.january.geometry.Vertex;
import org.eclipse.january.geometry.VertexSource;
import org.eclipse.january.geometry.impl.ComplexTriangle;
import org.eclipse.january.geometry.impl.ShapeImpl;

public class PolyShapeImpl
extends ShapeImpl
implements PolyShape {
    protected EList<Face> faces;
    protected VertexSource vertexSource;
    protected EList<String> materialFiles;

    protected PolyShapeImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return GeometryPackage.Literals.POLY_SHAPE;
    }

    @Override
    public EList<Face> getFaces() {
        if (this.faces == null) {
            this.faces = new EObjectContainmentEList(Face.class, (InternalEObject)this, 8);
        }
        return this.faces;
    }

    @Override
    public void calculatePolyTriangles() {
        if (this.getMaterial() != null) {
            this.getMaterial().getMaterialFiles().addAll(this.getVertexSource().getMaterialFiles());
        }
        boolean oneIndexing = true;
        for (Face face : this.getFaces()) {
            if (!face.getVertexIndices().contains((Object)0)) continue;
            oneIndexing = false;
            break;
        }
        for (Face face : this.getFaces()) {
            EList<Integer> indices = face.getVertexIndices();
            if (indices.size() <= 2) continue;
            int i = 1;
            while (i < indices.size() - 1) {
                int index1 = (Integer)indices.get(0);
                int index2 = (Integer)indices.get(i);
                int index3 = (Integer)indices.get(i + 1);
                if (oneIndexing) {
                    --index1;
                    --index2;
                    --index3;
                }
                Vertex v1 = (Vertex)this.getVertexSource().getVertices().get(index1);
                Vertex v2 = (Vertex)this.getVertexSource().getVertices().get(index2);
                Vertex v3 = (Vertex)this.getVertexSource().getVertices().get(index3);
                ComplexTriangle tri = new ComplexTriangle(v1, v2, v3);
                tri.eAdapters().add((Object)new AdapterImpl(){

                    public void notifyChanged(Notification notification) {
                        PolyShapeImpl.this.eNotify(notification);
                    }
                });
                this.getTriangles().add((Object)tri);
                ++i;
            }
        }
    }

    @Override
    public VertexSource getVertexSource() {
        if (this.parent != null && this.parent instanceof Geometry) {
            return ((Geometry)this.parent).getVertexSource();
        }
        return this.vertexSource;
    }

    public NotificationChain basicSetVertexSource(VertexSource newVertexSource, NotificationChain msgs) {
        VertexSource oldVertexSource = this.vertexSource;
        this.vertexSource = newVertexSource;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldVertexSource, (Object)newVertexSource);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setVertexSource(VertexSource newVertexSource) {
        if (newVertexSource != this.vertexSource) {
            NotificationChain msgs = null;
            if (this.vertexSource != null) {
                msgs = ((InternalEObject)this.vertexSource).eInverseRemove((InternalEObject)this, -10, null, msgs);
            }
            if (newVertexSource != null) {
                msgs = ((InternalEObject)newVertexSource).eInverseAdd((InternalEObject)this, -10, null, msgs);
            }
            if ((msgs = this.basicSetVertexSource(newVertexSource, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)newVertexSource, (Object)newVertexSource));
        }
    }

    @Override
    public Object clone() {
        PolyShape clone = GeometryFactory.eINSTANCE.createPolyShape();
        clone.copy(this);
        return clone;
    }

    @Override
    public void copy(Object source) {
        if (source instanceof PolyShape) {
            PolyShape castSource = (PolyShape)source;
            this.getCenter().setX(castSource.getCenter().getX());
            this.center.setY(castSource.getCenter().getY());
            this.center.setZ(castSource.getCenter().getZ());
            this.id = castSource.getId();
            this.name = castSource.getName();
            this.type = castSource.getType();
            for (INode node : this.getNodes()) {
                this.removeNode(node);
            }
            for (INode node : castSource.getNodes()) {
                this.addNode((INode)node.clone());
            }
            this.properties.clear();
            for (String property : castSource.getPropertyNames()) {
                this.setProperty(property, castSource.getProperty(property));
            }
            this.triangles = new BasicEList();
            this.faces = new BasicEList();
            for (Face face : castSource.getFaces()) {
                Face newFace = GeometryFactory.eINSTANCE.createFace();
                newFace.getTextureIndices().addAll(face.getTextureIndices());
                newFace.getVertexIndices().addAll(face.getVertexIndices());
                this.faces.add((Object)newFace);
            }
            this.vertexSource = castSource.getVertexSource();
            this.calculatePolyTriangles();
        }
    }

    @Override
    public EList<String> getMaterialFiles() {
        if (this.materialFiles == null) {
            this.materialFiles = new EDataTypeUniqueEList(String.class, (InternalEObject)this, 10);
        }
        return this.materialFiles;
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 8: {
                return ((InternalEList)this.getFaces()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return this.basicSetVertexSource(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return this.getFaces();
            }
            case 9: {
                return this.getVertexSource();
            }
            case 10: {
                return this.getMaterialFiles();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.getFaces().clear();
                this.getFaces().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setVertexSource((VertexSource)newValue);
                return;
            }
            case 10: {
                this.getMaterialFiles().clear();
                this.getMaterialFiles().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.getFaces().clear();
                return;
            }
            case 9: {
                this.setVertexSource(null);
                return;
            }
            case 10: {
                this.getMaterialFiles().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.faces != null && !this.faces.isEmpty();
            }
            case 9: {
                return this.vertexSource != null;
            }
            case 10: {
                return this.materialFiles != null && !this.materialFiles.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (materialFiles: ");
        result.append(this.materialFiles);
        result.append(')');
        return result.toString();
    }
}

