/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.metadata.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.january.dataset.IDynamicDataset;
import org.eclipse.january.dataset.ILazyDataset;
import org.eclipse.january.dataset.Slice;
import org.eclipse.january.metadata.AxesMetadata;
import org.eclipse.january.metadata.Reshapeable;
import org.eclipse.january.metadata.Sliceable;
import org.eclipse.january.metadata.Transposable;

public class AxesMetadataImpl
implements AxesMetadata {
    private static final long serialVersionUID = -3602919073785450882L;
    @Transposable
    @Reshapeable(matchRank=true)
    @Sliceable
    List<ILazyDataset>[] allAxes;
    Map<Integer, int[]> dimensionMap;

    public AxesMetadataImpl() {
    }

    @Override
    public void initialize(int rank) {
        this.allAxes = new List[rank];
        this.dimensionMap = new HashMap<Integer, int[]>();
    }

    private AxesMetadataImpl(AxesMetadataImpl axesMetadataImpl) {
        int r = axesMetadataImpl.allAxes.length;
        this.allAxes = new List[r];
        this.dimensionMap = new HashMap<Integer, int[]>();
        int i = 0;
        while (i < r) {
            List<ILazyDataset> ol = axesMetadataImpl.allAxes[i];
            if (ol != null) {
                ArrayList<ILazyDataset> list = new ArrayList<ILazyDataset>();
                for (ILazyDataset l : ol) {
                    int ihc;
                    ILazyDataset lv = l == null ? null : l.getSliceView(new Slice[0]);
                    list.add(lv);
                    if (lv == null || !axesMetadataImpl.dimensionMap.containsKey(ihc = System.identityHashCode(lv))) continue;
                    this.dimensionMap.put(ihc, (int[])axesMetadataImpl.dimensionMap.get(lv).clone());
                }
                this.allAxes[i] = list;
            }
            ++i;
        }
    }

    @Override
    public void setAxis(int axisDim, ILazyDataset ... axisData) {
        ArrayList<ILazyDataset> axisList = new ArrayList<ILazyDataset>(0);
        int i = 0;
        while (i < axisData.length) {
            axisList.add(this.sanitizeAxisData(axisData[i], axisDim));
            ++i;
        }
        this.allAxes[axisDim] = axisList;
    }

    @Override
    public ILazyDataset[] getAxes() {
        ILazyDataset[] result = new ILazyDataset[this.allAxes.length];
        int i = 0;
        while (i < result.length) {
            ILazyDataset[] ax = this.getAxis(i);
            if (ax != null && ax.length > 0) {
                result[i] = ax[0];
            }
            ++i;
        }
        return result;
    }

    @Override
    public ILazyDataset[] getAxis(int axisDim) {
        if (this.allAxes[axisDim] == null) {
            return null;
        }
        return this.allAxes[axisDim].toArray(new ILazyDataset[0]);
    }

    @Override
    public AxesMetadata clone() {
        return new AxesMetadataImpl(this);
    }

    @Override
    public void addAxis(int axisDim, ILazyDataset axisData) {
        if (this.allAxes[axisDim] == null) {
            this.allAxes[axisDim] = new ArrayList<ILazyDataset>();
        }
        this.allAxes[axisDim].add(this.sanitizeAxisData(axisData, axisDim));
    }

    @Override
    public void addAxis(int primary, ILazyDataset axisData, int ... axisDim) {
        if (this.allAxes[primary] == null) {
            this.allAxes[primary] = new ArrayList<ILazyDataset>();
        }
        ILazyDataset lz = this.sanitizeAxisData(axisData, axisDim);
        this.allAxes[primary].add(lz);
        if (lz != null) {
            this.dimensionMap.put(System.identityHashCode(lz), axisDim);
        }
    }

    private ILazyDataset sanitizeAxisData(ILazyDataset axisData, int ... axisDim) {
        if (axisData == null) {
            return null;
        }
        if (axisDim.length == 1) {
            int ad = axisDim[0];
            ILazyDataset view = axisData.getSliceView(new Slice[0]);
            view.clearMetadata(AxesMetadata.class);
            int r = axisData.getRank();
            if (r != this.allAxes.length) {
                if (r > 1) {
                    throw new IllegalArgumentException("Given axis dataset must be zero or one dimensional, or match rank");
                }
                int[] newShape = new int[this.allAxes.length];
                Arrays.fill(newShape, 1);
                newShape[ad] = axisData.getSize();
                view.setShape(newShape);
            }
            return view;
        }
        if (this.allAxes.length == axisData.getRank()) {
            return axisData;
        }
        ILazyDataset view = axisData.getSliceView(new Slice[0]);
        view.clearMetadata(AxesMetadata.class);
        int[] newShape = new int[this.allAxes.length];
        Arrays.fill(newShape, 1);
        int i = 0;
        while (i < axisDim.length) {
            newShape[axisDim[i]] = axisData.getShape()[i];
            ++i;
        }
        view.setShape(newShape);
        return view;
    }

    @Override
    public int[] refresh(int[] shape) {
        int[] maxShape = (int[])shape.clone();
        int i = 0;
        while (i < this.allAxes.length) {
            List<ILazyDataset> axis = this.allAxes[i];
            if (axis != null) {
                int j = 0;
                while (j < axis.size()) {
                    ILazyDataset l = axis.get(j);
                    if (l != null) {
                        int iHashCode = System.identityHashCode(l);
                        int[] dims = this.dimensionMap.get(iHashCode);
                        if (l instanceof IDynamicDataset) {
                            if (l.getSize() == 1) {
                                l.setShape(1);
                            } else {
                                l = l.squeezeEnds();
                            }
                            ((IDynamicDataset)l).refreshShape();
                        }
                        if (dims == null) {
                            int k = l.getShape()[0];
                            if (k < maxShape[i]) {
                                maxShape[i] = k;
                            }
                            int[] newShape = (int[])shape.clone();
                            Arrays.fill(newShape, 1);
                            newShape[i] = k;
                            l.setShape(newShape);
                            axis.set(j, l);
                        } else {
                            int[] newShape = (int[])shape.clone();
                            Arrays.fill(newShape, 1);
                            int k = 0;
                            while (k < dims.length) {
                                int[] s = l.getShape();
                                if (s[dims[k]] < maxShape[k]) {
                                    maxShape[k] = dims[k];
                                }
                                newShape[k] = s[dims[k]];
                                ++k;
                            }
                            l.setShape(newShape);
                            axis.set(j, l);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return maxShape;
    }
}

