/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests.bind.introspector;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class JAXBIntrospector_CTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        JAXBIntrospector_CTTests test = new JAXBIntrospector_CTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    public Status isElement001( ) {
        JAXBContext context;
        try {
            context = getJAXBContext();
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        if(introspector == null){
            return Status.failed("JAXBContext.createJAXBIntrospector() has returned null");
        }
        JAXBElement jaxbElement = new JAXBElement<String>(new QName("jck-jaxb-test/Introspector","element"),
                String.class,null,"value");
        boolean test = introspector.isElement(jaxbElement);
        if(!test){
            return Status.failed("JAXBIntrospector.isElement() has returned false on passing an instance of JAXBElement as a parameter.");
        }
        return Status.passed("OK");
    }

    public Status isElement002( ) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(Element.class);
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        if(introspector == null){
            return Status.failed("JAXBContext.createJAXBIntrospector() has returned null");
        }
        Element element = new Element();
        boolean test = introspector.isElement(element);
        if(!test){
            return Status.failed("JAXBIntrospector.isElement() has returned false on passing an instance of JAXBElement as a parameter.");
        }
        return Status.passed("OK");
    }

    public Status isElement003( ) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(Element.class);
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        if(introspector == null){
            return Status.failed("JAXBContext.createJAXBIntrospector() has returned null");
        }
        String testString = "object";
        boolean test = introspector.isElement(testString);
        if(test){
            return Status.failed("JAXBIntrospector.isElement() has returned false on passing an java.lang.String as a parameter");
        }
        return Status.passed("OK");
    }

    public Status getElementName001( ) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(Element.class);
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        if(introspector == null){
            return Status.failed("JAXBContext.createJAXBIntrospector() has returned null");
        }
        String testString = "object";
        QName qname = introspector.getElementName(testString);
        if(qname != null){
            return Status.failed("JAXBIntrospector.getElementName() has returned non-null value on passing an java.lang.String as a parameter");
        }
        return Status.passed("OK");
    }

    public Status getElementName002( ) {
        JAXBContext context;
        try {
            context = JAXBContext.newInstance(Element.class);
        } catch (JAXBException e) {
            e.printStackTrace(ref);
            return Status.failed("Cannot create an instance of JAXBContext: "+e);
        }
        JAXBIntrospector introspector = context.createJAXBIntrospector();
        if(introspector == null){
            return Status.failed("JAXBContext.createJAXBIntrospector() has returned null");
        }
        Object o = unmarshal("Introspector.xml");
        QName qname = introspector.getElementName(o);
        if(qname == null){
            return Status.failed("getElementName() returns null");
        }
        if(
                !"jck-jaxb-test/Introspector".equals(qname.getNamespaceURI())||
                !"root".equals(qname.getLocalPart())
        ){
            return Status.failed("JAXBIntrospector.getElementName() has returned invalid element name");
        }
        return Status.passed("OK");
    }

    public Status getValue001( ) {
        String value = "value";
        Object val = JAXBIntrospector.getValue(new JAXBElement<String>(new QName("jck-jaxb-test/Introspector","element"),
                String.class,null,value));
        if(!value.equals(val)){
            return Status.failed("getValue(Object jaxbElement) does not return value of JAXBElement if object is an instance of JAXBElement");
        }
        
        val = JAXBIntrospector.getValue(value);
        if(!value.equals(val)){
            return Status.failed("getValue(Object jaxbElement) does not return an object if object is not instance of JAXBElement");
        }
        return Status.passed("Ok");
    }


}

