/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.services;

import com.sun.javatest.services.Message;
import com.sun.javatest.services.ProcessExecutor;
import com.sun.javatest.services.ProcessParams;
import com.sun.javatest.services.Service;
import com.sun.javatest.services.ServiceExecutor;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;

public class AntService
extends Service {
    public static final String ANT_BIN = "ant.bin";
    public static final String ANT_TARGETS = "ant.targets";
    public static final String ANT_WORKDIR = "ant.workdir";
    public static final String ANT_ENV = "ant.env.";

    @Override
    public ServiceExecutor getDefaultServiceExecutor() {
        return new ProcessExecutor();
    }

    @Override
    public Message prepareMessage(Message.MessageType type) throws Service.MalformedParamsException {
        switch (type) {
            case START: {
                return this.prepareStartMessage();
            }
        }
        return new Message(type, null);
    }

    private Message prepareStartMessage() throws Service.MalformedParamsException {
        ProcessParams params = new ProcessParams();
        Map<String, String> p = this.props.resolveProperties();
        String antBin = p.remove(ANT_BIN);
        if (antBin == null) {
            throw new Service.MalformedParamsException("Path to ANT binary doesn't specified", p);
        }
        LinkedList<String> command = new LinkedList<String>();
        command.add(antBin);
        String workDir = p.remove(ANT_WORKDIR);
        if (workDir != null) {
            params.setWorkDirectory(new File(workDir));
        }
        TreeMap<String, String> env = new TreeMap<String, String>();
        for (String name : p.keySet()) {
            if (name.startsWith(ANT_ENV)) {
                env.put(name.substring(ANT_ENV.length()), p.remove(name));
                continue;
            }
            if (name.equals(ANT_TARGETS)) continue;
            command.add(p.remove(name));
        }
        params.setEnvironment(env);
        if (p.get(ANT_TARGETS) != null) {
            command.add(p.get(ANT_TARGETS));
        }
        params.setCommand(command);
        Message start = new Message(Message.MessageType.START, params);
        return start;
    }
}

