/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.harness;

import com.sun.ts.lib.deliverable.DeliverableFactory;
import com.sun.ts.lib.deliverable.PropertyManagerInterface;
import com.sun.ts.lib.harness.RebuildableVerifier;
import com.sun.ts.lib.util.TestUtil;
import java.io.File;
import java.util.Map;

public class InteropTestManager {
    private static Map htValidRunDirections;
    private String sRelativeTestPath = "";
    private static PropertyManagerInterface jteMgr;

    public static String getInteropDirections(String sPath) {
        String sPathCopy = sPath;
        String sRelativeTestPath = InteropTestManager.convertSlashesToUnderscores(sPath);
        String sVal2 = null;
        String sRelativeTestPathCopy = sRelativeTestPath;
        if (RebuildableVerifier.getInstance(new File(sPath)).isRebuildable()) {
            sVal2 = "both";
        } else {
            do {
                InteropTestManager.getDeliverableTable();
                sVal2 = (String)htValidRunDirections.get(sRelativeTestPathCopy + ".interop");
                if (!TestUtil.harnessDebug) continue;
                TestUtil.logHarnessDebug("getInteropDirections for " + sRelativeTestPathCopy + " :" + sVal2);
            } while ((sRelativeTestPathCopy = InteropTestManager.getNextLevelUp(sRelativeTestPathCopy)) != null && sVal2 == null);
        }
        if (TestUtil.harnessDebug) {
            TestUtil.logHarnessDebug("getInteropDirections - default Interop directions: " + sVal2);
        }
        return sVal2 == null ? "forward" : sVal2;
    }

    public static String getInteropDirectionsFromKeywords(String sPath) {
        String defaultDirections;
        String sDirections = defaultDirections = InteropTestManager.getInteropDirections(sPath);
        if (jteMgr == null) {
            try {
                jteMgr = DeliverableFactory.getDeliverableInstance().getPropertyManager();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (jteMgr != null) {
            String keywords = jteMgr.getProperty("current.keywords", "all");
            if (keywords.contains("forward") && !keywords.contains("reverse") && !keywords.contains("all") && (defaultDirections.equals("forward") || defaultDirections.equals("both"))) {
                sDirections = "forward";
            } else if (keywords.contains("reverse") && !keywords.contains("forward") && !keywords.contains("all") && (defaultDirections.equals("reverse") || defaultDirections.equals("both"))) {
                sDirections = "reverse";
            }
        }
        TestUtil.logHarnessDebug("getInteropDirectionsFromKeywords - directions: " + sDirections);
        return sDirections;
    }

    private static String getNextLevelUp(String sDottedPath) {
        int index = 0;
        String sNewPath = null;
        index = sDottedPath.lastIndexOf("_");
        if (index != -1) {
            sNewPath = sDottedPath.substring(0, index);
        }
        return sNewPath;
    }

    private static String convertSlashesToUnderscores(String sTestDir) {
        String sRelativeTestPath = sTestDir.substring(sTestDir.indexOf(File.separator + "ts" + File.separator + "tests" + File.separator) + 4).replace(File.separatorChar, '_');
        return sRelativeTestPath;
    }

    private static void getDeliverableTable() {
        if (htValidRunDirections == null) {
            try {
                htValidRunDirections = DeliverableFactory.getDeliverableInstance().getInteropDirections();
            }
            catch (Exception e) {
                TestUtil.logHarness("ERROR:  Failed to get interop directions from the Deliverable instance.");
            }
        }
    }
}

