/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.AnnotationItemEx;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class AnnotationParser {
    private static final String CLASS_PREFIX = "java.lang.Class";
    private static I18NResourceBundle i18n;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AnnotationItem parse(String str) {
        return this.parse(new StringBuffer(str));
    }

    private AnnotationItem parse(StringBuffer theRest) {
        if (theRest == null) {
            return null;
        }
        String str = theRest.toString();
        if (!str.startsWith("anno") && !str.startsWith("typeAnno")) {
            throw new IllegalArgumentException(i18n.getString("AnnotationParser.error.bad_annotation_descr") + str);
        }
        AnnotationItem item = str.startsWith("typeAnno") ? new AnnotationItemEx() : new AnnotationItem();
        int pos = str.indexOf(32);
        str = str.substring(pos).trim();
        pos = str.indexOf(32);
        String specificData = str.substring(0, pos);
        if (item instanceof AnnotationItemEx) {
            this.parseAnnExData((AnnotationItemEx)item, specificData);
        } else {
            this.parseAnnData(item, specificData);
        }
        str = str.substring(pos + 1);
        pos = str.indexOf(40);
        item.setName(str.substring(0, pos).trim());
        int endPos = this.findCorresponding(str, '(', ')');
        String rest = str.substring(endPos + 1);
        str = str.substring(pos + 1, endPos);
        if (str.length() != 0) {
            while (str.length() > 0 && str.charAt(0) != ')') {
                pos = this.parseMember(item, str);
                if ((str = str.substring(pos)).length() <= 0 || str.charAt(0) != ',') continue;
                str = str.substring(1).trim();
            }
        }
        if (theRest != null) {
            theRest.delete(0, theRest.length() - 1);
            theRest.append(rest);
        }
        return item;
    }

    public List unpack(String annS) {
        ArrayList<AnnotationItem> res = new ArrayList<AnnotationItem>();
        String str = annS.trim();
        if (str.charAt(0) != '[') {
            return Collections.EMPTY_LIST;
        }
        str = str.substring(1);
        if (str.charAt(str.length() - 1) == ']') {
            str = str.substring(0, str.length() - 1);
        }
        StringBuffer sb = new StringBuffer(str);
        while (sb.length() > 0) {
            AnnotationItem nA = this.parse(sb);
            res.add(nA);
            if (sb.length() > 0 && sb.charAt(0) == ')') {
                sb.deleteCharAt(0);
            }
            if (sb.length() > 0 && sb.charAt(0) == ',') {
                sb.deleteCharAt(0);
            }
            if (sb.length() <= 0 || sb.charAt(0) != ' ') continue;
            sb.deleteCharAt(0);
        }
        return res;
    }

    private int findCorresponding(String str, char open, char close) {
        char[] chars = str.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == open) {
                ++count;
                continue;
            }
            if (chars[i] != close || --count != 0) continue;
            return i;
        }
        return -1;
    }

    private void parseAnnData(AnnotationItem item, String specificData) {
        item.setTarget(Integer.valueOf(specificData));
    }

    private void parseAnnExData(AnnotationItemEx item, String specificData) {
        if (!$assertionsDisabled && !specificData.startsWith("[")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !specificData.endsWith("]")) {
            throw new AssertionError();
        }
        specificData = specificData.substring(1, specificData.length() - 1);
        StringTokenizer st = new StringTokenizer(specificData, ";");
        while (st.hasMoreTokens()) {
            String set = st.nextToken();
            int delPos = set.indexOf("=");
            if (!$assertionsDisabled && delPos <= 0) {
                throw new AssertionError();
            }
            String name = set.substring(0, delPos);
            String val = set.substring(delPos + 1, set.length());
            if ("target".equals(name)) {
                item.setTargetType(Integer.parseInt(val.substring(2), 16));
                continue;
            }
            if ("type".equals(name)) {
                item.setTypeIndex(Integer.parseInt(val));
                continue;
            }
            if ("bound".equals(name)) {
                item.setBoundIndex(Integer.parseInt(val));
                continue;
            }
            if ("param".equals(name)) {
                item.setParameterIndex(Integer.parseInt(val));
                continue;
            }
            if ("path".equals(name)) {
                item.setPath(val);
                continue;
            }
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }
    }

    protected int parseMember(AnnotationItem item, String str) {
        int result = 0;
        AnnotationItem.Member m = new AnnotationItem.Member();
        int pos = str.indexOf(32);
        if (str.startsWith("java.lang.Class<")) {
            char[] strChar = str.toCharArray();
            int level = 0;
            for (int i = CLASS_PREFIX.length(); i < strChar.length; ++i) {
                if (strChar[i] == '<') {
                    ++level;
                } else if (strChar[i] == '>') {
                    --level;
                }
                if (level != 0 || strChar[i + 1] != ' ') continue;
                pos = i + 1;
                break;
            }
        }
        m.type = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        pos = str.indexOf(61);
        m.name = str.substring(0, pos);
        str = str.substring(pos + 1).trim();
        result += pos + 1;
        char ch = str.charAt(0);
        switch (ch) {
            case '[': {
                pos = this.findClosingBracket(str, 1, '[', ']') + 1;
                break;
            }
            case '\"': 
            case '\'': {
                pos = str.indexOf(ch, 1) + 1;
                break;
            }
            case 'a': {
                if (str.startsWith("anno")) {
                    AnnotationItem a = this.parse(str);
                    pos = a.toString().length();
                    break;
                }
            }
            default: {
                pos = str.indexOf(44);
                if (pos == -1) {
                    pos = str.indexOf(41);
                }
                if (pos != -1) break;
                pos = str.length();
            }
        }
        m.value = str.substring(0, pos);
        item.addMember(m);
        return result += pos;
    }

    private int findClosingBracket(String str, int startPos, char openingChar, char closingChar) {
        int level = 0;
        int len = str.length();
        for (int i = startPos; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == openingChar) {
                ++level;
                continue;
            }
            if (ch != closingChar) continue;
            if (level == 0) {
                return i;
            }
            --level;
        }
        return -1;
    }

    static {
        $assertionsDisabled = !AnnotationParser.class.desiredAssertionStatus();
        i18n = I18NResourceBundle.getBundleForClass(AnnotationParser.class);
    }
}

