/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation.filter;

import jakarta.enterprise.context.Conversation;
import jakarta.inject.Inject;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.jboss.cdi.tck.tests.context.conversation.filter.Dummy;
import org.jboss.cdi.tck.tests.context.conversation.filter.State;
import org.jboss.cdi.tck.tests.context.conversation.filter.Tester;
import org.jboss.cdi.tck.util.SimpleLogger;
import org.jboss.cdi.tck.util.Timer;

@WebServlet(value={"/introspect"})
public class IntrospectServlet
extends HttpServlet {
    private static final SimpleLogger logger = new SimpleLogger(IntrospectServlet.class);
    public static final String MODE_INIT = "init";
    public static final String MODE_INSPECT = "inspect";
    public static final String MODE_LONG_TASK = "long_task";
    public static final String MODE_BUSY_REQUEST = "busy_request";
    @Inject
    Dummy dummy;
    @Inject
    Conversation conversation;
    @Inject
    Tester tester;
    @Inject
    State state;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType("text/plain");
        String mode = req.getParameter("mode");
        if (MODE_INIT.equals(mode)) {
            this.conversation.begin();
            this.dummy.ping();
            this.state.reset();
            resp.getWriter().write(this.conversation.getId() + "::" + req.getSession().getId());
        } else if (MODE_INSPECT.equals(mode)) {
            if (this.conversation.isTransient()) {
                resp.sendError(500, "No long running conversation");
            } else {
                resp.getWriter().write("" + this.tester.getResult());
            }
        } else if (MODE_LONG_TASK.equals(mode)) {
            if (this.conversation.isTransient()) {
                resp.sendError(500, "No long running conversation");
            } else {
                long start = System.currentTimeMillis();
                try {
                    new Timer().setSleepInterval(100L).setDelay(10L, TimeUnit.SECONDS).addStopCondition(new Timer.StopCondition(){

                        public boolean isSatisfied() {
                            return IntrospectServlet.this.state.isBusyAttemptMade();
                        }
                    }).start();
                }
                catch (InterruptedException e1) {
                    throw new IllegalStateException();
                }
                logger.log("Long task finished [isBusyAttemptMade: {0}, time: {1} ms]", new Object[]{this.state.isBusyAttemptMade(), System.currentTimeMillis() - start});
                resp.getWriter().write("OK");
            }
        } else if (MODE_BUSY_REQUEST.equals(mode)) {
            resp.sendError(500, "BusyConversationException should be thrown");
        } else {
            throw new ServletException("Unknown test mode");
        }
    }
}

