/*
 * Decompiled with CFR 0.152.
 */
package servlet.tck.api.jakarta_servlet.servletcontext30;

import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionTrackingMode;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Set;
import servlet.tck.common.servlets.GenericTCKServlet;
import servlet.tck.common.util.ServletTestUtil;
import servlet.tck.common.util.StaticLog;

public class TestServlet
extends GenericTCKServlet {
    public void getContextPathTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = false;
        PrintWriter pw = response.getWriter();
        ServletConfig config = this.getServletConfig();
        ServletContext context = config.getServletContext();
        try {
            String tmp = context.getContextPath();
            if (tmp != null) {
                pw.println("ServletContextPath=" + tmp);
                if (tmp.equals("/servlet_js_servletcontext30_web")) {
                    passed = true;
                } else {
                    passed = false;
                    pw.println("Incorrect value returned");
                }
            } else {
                passed = false;
                pw.println("Null value returned for context path");
            }
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception when calling getContextPath()");
        }
        this.sendtoclient(response);
    }

    public void testAddFilterString(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/addServletString";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.forward(request, response);
        }
        catch (Exception ex) {
            response.getWriter().println("Got Exception in testAddFilterString: " + ex.getMessage());
        }
        response.flushBuffer();
        this.getServletContext().removeAttribute("arraylist");
    }

    public void testAddFilterClass(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/SecondaddServletClass";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testAddFilterClass: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void testCreateFilterForward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/SecondCreateServlet";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.forward(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testCreateFilterForward: " + ex.getMessage());
        }
        ServletTestUtil.printResult(pw, passed);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void testCreateFilterInclude(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        boolean passed = true;
        PrintWriter pw = response.getWriter();
        String path = "/ThirdCreateServlet";
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            passed = false;
            pw.println("Got Exception in testCreateFilterInclude: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void testCreateSRAListener(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String path = "/ThirdAddServletClass";
        request.setAttribute("TestCreateSRAListener", (Object)"See_what_happens");
        try {
            RequestDispatcher rd = this.getServletContext().getRequestDispatcher(path);
            rd.include(request, response);
        }
        catch (Exception ex) {
            response.getWriter().println("Got Exception in TestCreateSRAListener: " + ex.getMessage());
        }
        this.sendtoclient(response);
    }

    public void negativeCreateTests(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String[] names;
        PrintWriter pw = response.getWriter();
        for (String name : names = new String[]{"SERVLET_TEST", "FILTER_TEST", "LISTENER_TEST", "SCC_LISTENER_TEST", "SCS_LISTENER_TEST", "CSC_LISTENER_TEST", "DUPLICATEC_SERVLET_TEST", "DUPLICATES_SERVLET_TEST", "DUPLICATEC_FILTER_TEST", "DUPLICATES_FILTER_TEST"}) {
            pw.println(name + "=" + this.getServletContext().getInitParameter(name).toUpperCase());
            this.getServletContext().removeAttribute(name);
        }
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void duplicateServletTest3(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String[] names;
        PrintWriter pw = response.getWriter();
        for (String name : names = new String[]{"DUPLICATEC_SERVLET_TEST", "DUPLICATES_SERVLET_TEST"}) {
            pw.println(name + "=" + this.getServletContext().getInitParameter(name).toUpperCase());
            this.getServletContext().removeAttribute(name);
        }
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void duplicateFilterTest1(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        String[] names;
        PrintWriter pw = response.getWriter();
        for (String name : names = new String[]{"DUPLICATEC_FILTER_TEST", "DUPLICATES_FILTER_TEST"}) {
            pw.println(name + "=" + this.getServletContext().getInitParameter(name).toUpperCase());
            this.getServletContext().removeAttribute(name);
        }
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void getEffectiveMajorVersionTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        ServletContext context = this.getServletContext();
        pw.println("EFFECTIVEMAJORVERSION=" + context.getEffectiveMajorVersion() + ";");
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void getEffectiveMinorVersionTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        ServletContext context = this.getServletContext();
        pw.println("EFFECTIVEMINORVERSION=" + context.getEffectiveMinorVersion() + ";");
        ServletTestUtil.printResult(pw, true);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void getDefaultSessionTrackingModes(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        ServletContext context = this.getServletContext();
        Set results = context.getDefaultSessionTrackingModes();
        for (SessionTrackingMode tmp : results) {
            if (tmp == SessionTrackingMode.COOKIE || tmp == SessionTrackingMode.URL || tmp == SessionTrackingMode.SSL) {
                pw.println("getDefaultSessionTrackingModes=" + tmp + ";");
                continue;
            }
            pass = false;
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void sessionTrackingModesValueOfTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        if (!SessionTrackingMode.valueOf((String)"COOKIE").equals((Object)SessionTrackingMode.COOKIE)) {
            pass = false;
            pw.println("String COOKIE didn't yield coorect SessionTrackingMode.");
        } else if (!SessionTrackingMode.valueOf((String)"URL").equals((Object)SessionTrackingMode.URL)) {
            pass = false;
            pw.println("String URL didn't yield coorect SessionTrackingMode.");
        } else if (!SessionTrackingMode.valueOf((String)"SSL").equals((Object)SessionTrackingMode.SSL)) {
            pass = false;
            pw.println("String SSL didn't yield coorect SessionTrackingMode.");
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
        this.getServletContext().removeAttribute("arraylist");
    }

    public void sessionTrackingModesValuesTest(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        Boolean pass = true;
        PrintWriter pw = response.getWriter();
        SessionTrackingMode[] values_expected = new SessionTrackingMode[]{SessionTrackingMode.COOKIE, SessionTrackingMode.URL, SessionTrackingMode.SSL};
        int i = 0;
        SessionTrackingMode[] values_received = new SessionTrackingMode[3];
        SessionTrackingMode[] sessionTrackingModeArray = SessionTrackingMode.values();
        int n = sessionTrackingModeArray.length;
        for (int j = 0; j < n; ++j) {
            SessionTrackingMode c;
            values_received[i] = c = sessionTrackingModeArray[j];
            ++i;
        }
        for (i = 0; i < 3; ++i) {
            if (values_expected[i].equals((Object)values_received[i])) continue;
            pass = false;
            pw.println("The number " + i + " SessionTrackingMode didn't match.");
            pw.println("Expecting " + values_expected[i] + ".  Got " + values_received[i]);
        }
        ServletTestUtil.printResult(pw, (boolean)pass);
        this.getServletContext().removeAttribute("arraylist");
    }

    private void sendtoclient(ServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        ArrayList result = (ArrayList)this.getServletContext().getAttribute("arraylist");
        if (result != null) {
            for (Object tmp : result) {
                if (tmp == null) continue;
                pw.println(tmp.toString());
            }
        }
        this.getServletContext().removeAttribute("arraylist");
        result = StaticLog.getClear();
        if (result != null) {
            for (Object tmp : result) {
                if (tmp == null) continue;
                pw.println(tmp.toString());
            }
        }
        StaticLog.clear();
        ServletTestUtil.printResult(pw, true);
    }
}

