/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.util;

import com.sun.javatest.util.PropertyUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class PropertyArray {
    private static final String lineSeparator = System.getProperty("line.separator");
    private static char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String[] dataA;
    private boolean locked;

    public PropertyArray() {
        this.locked = false;
    }

    public PropertyArray(int initSize) {
        this.locked = false;
    }

    public PropertyArray(Reader in) throws IOException {
        this.dataA = PropertyArray.load(in);
        this.locked = true;
    }

    public PropertyArray(Map<String, String> props) {
        this.dataA = PropertyArray.getArray(props);
        this.locked = true;
    }

    public PropertyArray(String ... data) {
        this.locked = true;
        this.dataA = new String[data.length];
        for (int i = 0; i < data.length; ++i) {
            this.dataA[i] = data[i];
        }
    }

    public static String[] getArray(Map<String, String> props) {
        Vector<String> data = new Vector<String>(props.size(), 2);
        for (Map.Entry<String, String> entry : props.entrySet()) {
            PropertyArray.insert(data, entry.getKey(), entry.getValue());
        }
        return data.toArray(new String[data.size()]);
    }

    public static String[] put(String[] data, String key, String value) {
        String old = null;
        if (key == null || value == null) {
            throw new PropertyArrayError("A key or value was null.  Null keys and values are illegal");
        }
        if (data == null) {
            data = new String[]{};
        }
        Vector<String> vec = PropertyArray.copyOutOf(data);
        old = PropertyArray.insert(vec, key, value);
        return vec.toArray(new String[vec.size()]);
    }

    public static String get(String[] data, String key) {
        if (data == null || data.length == 0 || key == null) {
            return null;
        }
        int lower = 0;
        int upper = data.length - 2;
        if (upper < 0) {
            return null;
        }
        String last = data[upper];
        int cmp = key.compareTo(last);
        if (cmp > 0) {
            return null;
        }
        while (lower <= upper) {
            int mid = lower + (upper - lower) / 4 * 2;
            String e = data[mid];
            cmp = key.compareTo(e);
            if (cmp < 0) {
                upper = mid - 2;
                continue;
            }
            if (cmp > 0) {
                lower = mid + 2;
                continue;
            }
            return data[mid + 1];
        }
        return null;
    }

    public static String[] remove(String[] data, String key) {
        Vector<String> vec = PropertyArray.copyOutOf(data);
        int lower = 0;
        int upper = vec.size() - 2;
        int mid = 0;
        String old = null;
        if (upper < 0) {
            return data;
        }
        String last = vec.get(upper);
        int cmp = key.compareTo(last);
        if (cmp > 0) {
            return data;
        }
        while (lower <= upper) {
            mid = lower + (upper - lower) / 4 * 2;
            String e = vec.get(mid);
            cmp = key.compareTo(e);
            if (cmp < 0) {
                upper = mid - 2;
                continue;
            }
            if (cmp > 0) {
                lower = mid + 2;
                continue;
            }
            vec.remove(mid);
            old = vec.get(mid);
            vec.remove(mid);
            break;
        }
        return vec.toArray(new String[vec.size()]);
    }

    public static Map<String, String> getProperties(String ... data) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (data != null && data.length > 0) {
            for (int i = 0; i < data.length; i += 2) {
                props.put(data[i], data[i + 1]);
            }
        }
        return props;
    }

    public static void save(String[] data, Writer out) throws IOException {
        if (data == null || data.length == 0) {
            return;
        }
        BufferedWriter bout = out instanceof BufferedWriter ? (BufferedWriter)out : new BufferedWriter(out);
        for (int i = 0; i < data.length; i += 2) {
            String key = data[i];
            String val = data[i + 1];
            key = PropertyUtils.saveConvert(key, true, false);
            val = PropertyUtils.saveConvert(val, false, false);
            bout.write(key + "=" + val);
            bout.newLine();
        }
        bout.flush();
    }

    public static String[] load(Reader in) throws IOException {
        Vector<String> v = PropertyUtils.load0(in, true);
        Vector<String> sorted = new Vector<String>(v.size());
        for (int i = 0; i < v.size(); i += 2) {
            PropertyArray.insert(sorted, v.get(i), v.get(i + 1));
        }
        return sorted.toArray(new String[sorted.size()]);
    }

    public static Enumeration<String> enumerate(final String ... props) {
        return new Enumeration<String>(){
            int pos = 0;

            @Override
            public boolean hasMoreElements() {
                return props != null && this.pos < props.length;
            }

            @Override
            public String nextElement() {
                if (props == null || this.pos >= props.length) {
                    return null;
                }
                String current = props[this.pos];
                this.pos += 2;
                return current;
            }
        };
    }

    private static String insert(Vector<String> vec, String key, String value) {
        int lower = 0;
        int upper = vec.size() - 2;
        int mid = 0;
        String old = null;
        if (upper < 0) {
            vec.add(key);
            vec.add(value);
            return old;
        }
        String last = vec.get(upper);
        int cmp = key.compareTo(last);
        if (cmp > 0) {
            vec.add(key);
            vec.add(value);
            return null;
        }
        while (lower <= upper) {
            mid = lower + (upper - lower) / 4 * 2;
            String e = vec.get(mid);
            cmp = key.compareTo(e);
            if (cmp < 0) {
                upper = mid - 2;
                continue;
            }
            if (cmp > 0) {
                lower = mid + 2;
                continue;
            }
            vec.remove(mid);
            old = vec.get(mid);
            vec.remove(mid);
            break;
        }
        if (cmp > 0) {
            mid += 2;
        }
        vec.add(mid, key);
        vec.add(mid + 1, value);
        return old;
    }

    private static Vector<String> copyOutOf(String ... data) {
        Vector<String> vec = null;
        if (data == null) {
            vec = new Vector<String>(0, 2);
        } else {
            vec = new Vector(data.length, 2);
            for (String aData : data) {
                vec.add(aData);
            }
        }
        return vec;
    }

    private static String[] shallowCopy(String ... arrIn) {
        if (arrIn == null) {
            return null;
        }
        String[] arrOut = new String[arrIn.length];
        for (int i = 0; i < arrIn.length; ++i) {
            arrOut[i] = arrIn[i];
        }
        return arrOut;
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public Map<String, String> getProperties() {
        return PropertyArray.getProperties(this.dataA);
    }

    public boolean isMutable() {
        return !this.locked;
    }

    public int size() {
        if (this.dataA == null) {
            return 0;
        }
        return this.dataA.length / 2;
    }

    public String get(String key) {
        return PropertyArray.get(this.dataA, key);
    }

    public String[] getArray() {
        if (this.dataA == null || this.dataA.length == 0) {
            return null;
        }
        return PropertyArray.shallowCopy(this.dataA);
    }

    public String put(String key, String value) {
        String old = null;
        if (this.locked) {
            throw new IllegalStateException("PropertyArray is immutable.");
        }
        if (key == null || value == null) {
            throw new PropertyArrayError("A key or value was null.  Null keys and values are illegal");
        }
        Vector<String> vec = PropertyArray.copyOutOf(this.dataA);
        old = PropertyArray.insert(vec, key, value);
        this.dataA = vec.toArray(new String[vec.size()]);
        return old;
    }

    public void remove(String key) {
        this.dataA = PropertyArray.remove(this.dataA, key);
    }

    public void save(Writer out) throws IOException {
        PropertyArray.save(this.dataA, out);
    }

    public static class PropertyArrayError
    extends Error {
        public PropertyArrayError() {
        }

        public PropertyArrayError(String msg) {
            super(msg);
        }
    }
}

