/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.jsonfilter;

import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum ExpectedValueType {
    BOOLEAN("boolean"),
    EMPTY_ARRAY("empty-array"),
    NON_EMPTY_ARRAY("non-empty-array"),
    NULL("null"),
    NUMBER("number"),
    OBJECT("object"),
    STRING("string");

    private final String name;

    private ExpectedValueType(String name) {
        this.name = name;
    }

    public static ExpectedValueType forName(String name) {
        String lowerName = StaticUtils.toLowerCase(name);
        for (ExpectedValueType t : ExpectedValueType.values()) {
            if (!t.name.equals(lowerName)) continue;
            return t;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

