/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.errors;

import com.sun.tdk.signaturetest.errors.AnnotationHandler;
import com.sun.tdk.signaturetest.errors.Chain;
import com.sun.tdk.signaturetest.errors.ConstantValueHandler;
import com.sun.tdk.signaturetest.errors.ErrorFormatter;
import com.sun.tdk.signaturetest.errors.Handler;
import com.sun.tdk.signaturetest.errors.MessageType;
import com.sun.tdk.signaturetest.errors.ModifiersHandler;
import com.sun.tdk.signaturetest.errors.ReturnTypeHandler;
import com.sun.tdk.signaturetest.errors.SortedErrorFormatter;
import com.sun.tdk.signaturetest.errors.ThrowsHandler;
import com.sun.tdk.signaturetest.errors.TypeParametersHandler;
import com.sun.tdk.signaturetest.model.ConstructorDescr;
import com.sun.tdk.signaturetest.model.MemberDescription;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.MethodDescr;
import com.sun.tdk.signaturetest.plugin.MessageTransformer;
import com.sun.tdk.signaturetest.plugin.PluginAPI;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;

public class HumanErrorFormatter
extends SortedErrorFormatter {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(SortedErrorFormatter.class);
    private Level level;

    public HumanErrorFormatter(PrintWriter out, boolean isv, Level l) {
        super(out, isv);
        this.level = l;
    }

    public void printErrors() {
        MessageTransformer t = PluginAPI.BEFORE_MESSAGE_SORT.getMessageTransformer();
        if (t != null) {
            this.failedMessages = t.changeMessageList(this.failedMessages);
        }
        this.sortErrors();
        ErrorComparator ec = new ErrorComparator();
        int length = this.failedMessages.size();
        Chain ch = new Chain(this.failedMessages);
        for (int i = 0; i < length; ++i) {
            ErrorFormatter.Message e2;
            ErrorFormatter.Message e1 = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (e1 == null) continue;
            int j = i;
            while (j + 1 < this.failedMessages.size() && ec.compare(e1, e2 = (ErrorFormatter.Message)this.failedMessages.get(j + 1)) == 0) {
                ++j;
            }
            List currentGroup = this.failedMessages.subList(i, j + 1);
            Handler h = this.constructHandlerChain();
            h.process(currentGroup, ch);
            i = j;
        }
        ch.finishProcessing();
        this.supressExtraErrors();
        Iterator it = this.failedMessages.iterator();
        this.numErrors = 0;
        this.numWarnings = 0;
        while (it.hasNext()) {
            ErrorFormatter.Message m = (ErrorFormatter.Message)it.next();
            if (this.level.intValue() <= m.getLevel().intValue()) {
                ++this.numErrors;
                continue;
            }
            ++this.numWarnings;
        }
        this.sortErrorsForOutput();
        this.outProcessedErrors();
    }

    protected void outProcessedErrors() {
        boolean hasHeader = false;
        MessageType lastType = null;
        String cl = "";
        for (int i = 0; i < this.failedMessages.size(); ++i) {
            ErrorFormatter.Message current = (ErrorFormatter.Message)this.failedMessages.get(i);
            if (current == null) continue;
            String ccl = current.className;
            if (current.errorObject != null && current.errorObject.isInner()) {
                ccl = current.errorObject.getQualifiedName();
            }
            if (current.messageType == MessageType.ADD_CLASSES) {
                lastType = current.messageType;
                this.out.println("\n+ Class " + ccl);
                cl = ccl;
                continue;
            }
            if (current.messageType == MessageType.MISS_CLASSES) {
                lastType = current.messageType;
                this.out.println("\n- Class " + ccl);
                cl = ccl;
                continue;
            }
            if (!cl.equals(ccl)) {
                cl = ccl;
                lastType = null;
                this.out.println("\nClass " + cl);
            }
            if (current.messageType != lastType) {
                hasHeader = true;
                this.out.println("  " + current.messageType.getLocMessage());
                lastType = current.messageType;
            }
            if (hasHeader) {
                if (current.definition.equals("")) {
                    this.out.println(current.className);
                    continue;
                }
                StringBuffer name = new StringBuffer();
                if (current.messageType != MessageType.CHNG_CLASSES_MEMBERS) {
                    this.out.println("    " + current.definition);
                    if (!this.isVerbose() || current.tail.length() == 0) continue;
                    this.out.println(i18n.getString("SortedErrorFormatter.error.affected", current.tail));
                    continue;
                }
                if (current.errorObject.getMemberType() != MemberType.CLASS) {
                    name.append("    ");
                    name.append(current.errorObject);
                    this.out.println(name);
                }
                this.out.print(current.definition);
                continue;
            }
            this.out.println(current);
        }
        if (this.failedMessages.size() > 0) {
            this.out.println("");
        }
    }

    protected Handler constructHandlerChain() {
        return new ModifiersHandler().setNext(new ReturnTypeHandler().setNext(new TypeParametersHandler().setNext(new ThrowsHandler().setNext(new ConstantValueHandler().setNext(new AnnotationHandler())))));
    }

    private void sortErrorsForOutput() {
        Collections.sort(this.failedMessages, new Comparator(){

            public int compare(Object o1, Object o2) {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)o1;
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)o2;
                if (m1 == null && m2 == null) {
                    return 0;
                }
                if (m1 == null && m2 != null) {
                    return -1;
                }
                if (m1 != null && m2 == null) {
                    return 1;
                }
                int comp = m1.className.compareTo(m2.className);
                if (comp == 0 && (comp = m1.errorObject.getMemberType().compareTo(m2.errorObject.getMemberType())) == 0) {
                    comp = m1.messageType.compareTo(m2.messageType);
                    if (comp == 0 && (comp = m1.definition.compareTo(m2.definition)) == 0) {
                        comp = m1.tail != null && m2.tail != null ? m1.tail.compareTo(m2.tail) : (m1.tail == null ? -1 : 1);
                    }
                    return comp;
                }
                return comp;
            }
        });
    }

    protected void sortErrors() {
        Collections.sort(this.failedMessages, new ErrorComparator());
    }

    private void supressExtraErrors() {
        Collections.sort(this.failedMessages, new Comparator(){

            public int compare(Object o1, Object o2) {
                ErrorFormatter.Message m1 = (ErrorFormatter.Message)o1;
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)o2;
                if (!HumanErrorFormatter.this.isSameKind(m1, m2)) {
                    return -1;
                }
                return m1.className.compareTo(m2.className);
            }
        });
        ArrayList toRemove = new ArrayList();
        block0: for (int i = 0; i < this.failedMessages.size(); ++i) {
            ErrorFormatter.Message m1 = (ErrorFormatter.Message)this.failedMessages.get(i);
            int last = i;
            int j = i + 1;
            while (j < this.failedMessages.size()) {
                ErrorFormatter.Message m2 = (ErrorFormatter.Message)this.failedMessages.get(j);
                if (!this.isSameKind(m1, m2)) {
                    if (last != i) break;
                    i = j;
                    continue block0;
                }
                last = j++;
            }
            boolean found = false;
            ArrayList<ErrorFormatter.Message> rem = new ArrayList<ErrorFormatter.Message>();
            for (int k = i; k <= last; ++k) {
                ErrorFormatter.Message m = (ErrorFormatter.Message)this.failedMessages.get(k);
                if (m.className.equals(m.errorObject.getDeclaringClassName())) {
                    found = true;
                    continue;
                }
                rem.add(m);
            }
            if (found) {
                toRemove.addAll(rem);
            }
            i = last;
        }
        this.failedMessages.removeAll(toRemove);
    }

    private boolean isSameKind(ErrorFormatter.Message m1, ErrorFormatter.Message m2) {
        if (m1 == null || m2 == null) {
            return false;
        }
        return m1.errorObject.equals(m2.errorObject) && m1.definition.equals(m2.definition) && m1.tail.equals(m2.tail) && m1.messageType.equals(m2.messageType);
    }

    private static class ErrorComparator
    implements Comparator {
        private ErrorComparator() {
        }

        public int compare(Object o1, Object o2) {
            ErrorFormatter.Message msg1 = (ErrorFormatter.Message)o1;
            ErrorFormatter.Message msg2 = (ErrorFormatter.Message)o2;
            MemberDescription md1 = msg1.errorObject;
            MemberDescription md2 = msg2.errorObject;
            int comp = md1.getQualifiedName().compareTo(md2.getQualifiedName());
            if (comp == 0) {
                comp = md1.getMemberType().compareTo(md2.getMemberType());
                if (comp == 0 && (md1.getMemberType() == MemberType.METHOD || md1.getMemberType() == MemberType.CONSTRUCTOR)) {
                    if (md1 instanceof MethodDescr && md2 instanceof MethodDescr) {
                        MethodDescr mth1 = (MethodDescr)md1;
                        MethodDescr mth2 = (MethodDescr)md2;
                        comp = mth1.getSignature().compareTo(mth2.getSignature());
                    } else if (md1 instanceof ConstructorDescr && md2 instanceof ConstructorDescr) {
                        ConstructorDescr co1 = (ConstructorDescr)md1;
                        ConstructorDescr co2 = (ConstructorDescr)md2;
                        comp = co1.getSignature().compareTo(co2.getSignature());
                    }
                }
                if (comp == 0) {
                    comp = msg1.className.compareTo(msg2.className);
                }
            }
            return comp;
        }
    }
}

