/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.delete;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.delete.HttpMethodDeleteTest;
import ee.jakarta.tck.ws.rs.ee.rs.delete.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    private static final long serialVersionUID = 204493956987397506L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_rs_delete_web");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/delete/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_rs_delete_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, HttpMethodDeleteTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void deleteTest1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/plain");
        this.setProperty("REQUEST", "DELETE " + this.getContextRoot() + "/DeleteTest HTTP/1.1");
        this.setProperty("SEARCH_STRING", "CTS-Delete text/plain");
        this.invoke();
    }

    @Test
    public void deleteTest2() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/html");
        this.setProperty("REQUEST", "DELETE " + this.getContextRoot() + "/DeleteTest  HTTP/1.1");
        this.setProperty("SEARCH_STRING", "CTS-Delete text/html");
        this.invoke();
    }

    @Test
    public void deleteSubTest() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/html");
        this.setProperty("REQUEST", "DELETE " + this.getContextRoot() + "/DeleteTest/sub HTTP/1.1");
        this.setProperty("SEARCH_STRING", "CTS-Delete text/html");
        this.invoke();
    }

    @Test
    public void deleteSubTest1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", "Accept:text/plain");
        this.setProperty("REQUEST", "DELETE " + this.getContextRoot() + "/DeleteTest/sub HTTP/1.1");
        this.setProperty("STATUS_CODE", JAXRSClientIT.getStatusCode(Response.Status.NOT_ACCEPTABLE));
        this.invoke();
    }
}

