/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext;

import ee.jakarta.tck.ws.rs.common.provider.StringBean;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanRuntimeDelegate;
import ee.jakarta.tck.ws.rs.common.provider.StringBeanWithAnnotation;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.ContextOperation;
import ee.jakarta.tck.ws.rs.ee.rs.container.responsecontext.ResponseFilter;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.EntityTag;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.NewCookie;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.ByteArrayInputStream;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;

@Path(value="resource")
public class Resource {
    @Context
    UriInfo info;

    @Path(value="getallowedmethods")
    @GET
    public Response getAllowedMethods() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.allow(new String[]{"OPTIONS", "TRACE"}).build();
        return response;
    }

    @Path(value="getcookies")
    @GET
    public Response getCookies() {
        NewCookie cookie = new NewCookie("CookieName", "CookieName");
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.cookie(new NewCookie[]{cookie}).build();
        return response;
    }

    @Path(value="getcookiesisreadonly")
    @GET
    public Response getCookiesIsReadOnly() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getdate")
    public Response getDate(String text) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (text != null && text.length() != 0) {
            long milis = Long.valueOf(text);
            Date date = new Date(milis);
            builder = builder.header("Date", (Object)date);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentity")
    public Response getEntity(String entity) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (entity != null && entity.length() != 0) {
            builder = builder.entity((Object)entity.getBytes());
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentityannotations")
    public Response getEntityAnnotations(String setEntity) {
        Annotation[] annotations = ResponseFilter.class.getAnnotations();
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (Boolean.parseBoolean(setEntity)) {
            builder = builder.entity((Object)"entity", annotations);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentityannotationsonentity")
    public Response getEntityAnnotationsOnEntity(String entity) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        builder = builder.entity((Object)new StringBeanWithAnnotation(entity));
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentityclass")
    public Response getEntityClass(String clazz) {
        String content = "ENTity";
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Object entity = null;
        if ("string".equals(clazz)) {
            entity = content;
        } else if ("bytearray".equals(clazz)) {
            entity = content.getBytes();
        } else if ("inputstream".equals(clazz)) {
            entity = new ByteArrayInputStream(content.getBytes());
        }
        builder = builder.entity(entity);
        Response response = builder.build();
        return response;
    }

    @GET
    @Path(value="getentitystream")
    public Response getEntityStream() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentitytag")
    public Response getEntityTag(String tagName) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (tagName != null && tagName.length() != 0) {
            EntityTag tag = new EntityTag(tagName);
            builder = builder.tag(tag);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getentitytype")
    public Response getEntityType(String type) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Object entity = null;
        String content = "ENTity";
        if ("string".equals(type)) {
            entity = content;
        } else if ("bytearray".equals(type)) {
            entity = content.getBytes();
        } else if ("inputstream".equals(type)) {
            entity = new ByteArrayInputStream(content.getBytes());
        }
        builder = builder.entity(entity);
        Response response = builder.build();
        return response;
    }

    @GET
    @Path(value="setentitystream")
    public Response setEntityStream() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getheaders")
    public Response getHeaders(String header) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        for (int i = 0; i != 5; ++i) {
            builder = builder.header(header + i, (Object)header);
        }
        Response response = builder.build();
        return response;
    }

    @GET
    @Path(value="getheadersismutable")
    public Response getHeadersIsMutable() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @GET
    @Path(value="getheaderstringoperation")
    public Response getHeaderStringByOperation() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getheaderstringheader")
    public Response getHeaderStringByHeader(String content) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (content.equals("toString")) {
            builder = builder.header("HEADER", (Object)new StringBuilder().append("ResponseFilterEntity"));
        }
        if (content.equals("commaSeparated")) {
            builder = builder.header("HEADER", (Object)new StringBuilder().append("ResponseFilterEntity"));
            builder = builder.header("HEADER", (Object)"ResponseFilterEntity");
        }
        if (content.equals("headerDelegate")) {
            StringBean bean = new StringBean("ResponseFilterEntity");
            builder = builder.header("HEADER", (Object)bean);
        }
        if (content.equalsIgnoreCase("entity")) {
            builder = builder.header("HEADER", (Object)content);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlanguage")
    public Response getLanguage(String language) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (language != null && language.length() != 0) {
            builder = builder.language(language);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlastmodified")
    public Response getLastModified(String last) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (last != null && last.length() != 0) {
            long lastMilist = Long.parseLong(last);
            Date date = new Date(lastMilist);
            builder = builder.lastModified(date);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlength")
    public Response getLength(String entity) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (entity != null && entity.length() != 0) {
            builder = builder.entity((Object)entity).header("Content-Length", (Object)entity.length());
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlink")
    public Response getLink(String uri) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (uri != null && uri.length() != 0) {
            Link link = Link.fromUri((String)uri).rel("relation").build(new Object[0]);
            builder = builder.links(new Link[]{link});
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlinkbuilder")
    public Response getLinkBuilder(String uri) {
        return this.getLink(uri);
    }

    @POST
    @Path(value="getlinks")
    public Response getLinks(String uris) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (uris != null && uris.length() != 0) {
            String[] tokens = uris.split(";");
            Link[] links = new Link[tokens.length];
            for (int i = 0; i != tokens.length; ++i) {
                links[i] = Link.fromUri((String)tokens[i]).build(new Object[0]);
            }
            builder = builder.links(links);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getlocation")
    public Response getLocation(String uri) throws URISyntaxException {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (uri != null && uri.length() != 0) {
            builder = builder.location(new URI(uri));
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getmediatype")
    public Response getMediaType(String media) throws URISyntaxException {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (media != null && media.length() != 0) {
            builder = builder.type(media);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="getstatus")
    public Response getStatus(String entity) {
        int status = Integer.parseInt(entity);
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.status(status).build();
        return response;
    }

    @POST
    @Path(value="getstatusinfo")
    public Response getStatusinfo(String entity) {
        return this.getStatus(entity);
    }

    @POST
    @Path(value="getstringheaders")
    public Response getStringHeaders(String content) {
        return this.getHeaderStringByHeader(content);
    }

    @POST
    @Path(value="hasentity")
    public Response hasEntity(String entity) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        if (entity != null && entity.length() != 0) {
            builder = builder.entity((Object)entity);
        }
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="haslink")
    public Response hasLink(String uri) {
        return this.getLink(uri);
    }

    @GET
    @Path(value="setentity")
    public Response setEntity() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.build();
        return response;
    }

    @POST
    @Path(value="setstatus")
    public Response setStatus(String status) {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        Response response = builder.entity((Object)status).build();
        return response;
    }

    @POST
    @Path(value="setstatusinfo")
    public Response setStatusInfo(String status) {
        return this.setStatus(status);
    }

    @Path(value="setstringbeanruntime")
    @GET
    public Response setStringBeanRuntime() {
        RuntimeDelegate original = RuntimeDelegate.getInstance();
        if (!(original instanceof StringBeanRuntimeDelegate)) {
            StringBeanRuntimeDelegate sbrd = new StringBeanRuntimeDelegate(original);
            RuntimeDelegate.setInstance((RuntimeDelegate)sbrd);
        }
        return this.createResponseWithHeader().build();
    }

    @Path(value="setoriginalruntime")
    @GET
    public Response setOriginalRuntime() {
        Response.ResponseBuilder builder = this.createResponseWithHeader();
        RuntimeDelegate stringBeanDelegate = RuntimeDelegate.getInstance();
        if (stringBeanDelegate instanceof StringBeanRuntimeDelegate) {
            RuntimeDelegate original = ((StringBeanRuntimeDelegate)stringBeanDelegate).getOriginal();
            RuntimeDelegate.setInstance((RuntimeDelegate)original);
        } else {
            builder = builder.status(Response.Status.NO_CONTENT);
        }
        return builder.build();
    }

    private Response.ResponseBuilder createResponseWithHeader() {
        List segments = this.info.getPathSegments();
        PathSegment last = (PathSegment)segments.get(segments.size() - 1);
        ContextOperation op = ContextOperation.valueOf(last.getPath().toUpperCase());
        Response.ResponseBuilder builder = Response.ok();
        builder = builder.header("OPERATION", (Object)op.name());
        return builder;
    }
}

