/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.signaturetest;

import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.signaturetest.PackageList;
import ee.jakarta.tck.ws.rs.signaturetest.SignatureTestDriver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;

public class SigTestDriver
extends SignatureTestDriver {
    private static final String CLASSPATH_FLAG = "-Classpath";
    private static final String FILENAME_FLAG = "-FileName";
    private static final String PACKAGE_FLAG = "-Package";
    private static final String PACKAGE_NO_SUBS_FLAG = "-PackageWithoutSubpackages";
    private static final String API_VERSION_FLAG = "-ApiVersion";
    private static final String EXCLUDE_FLAG = "-Exclude";
    private static final String STATIC_FLAG = "-Static";
    private static final String CHECKVALUE_FLAG = "-CheckValue";
    private static final String NO_CHECKVALUE_FLAG = "-NoCheckValue";
    private static final String SMODE_FLAG = "-mode";
    private static final String DEBUG_FLAG = "-Debug";
    private static final String FORMATPLAIN_FLAG = "-FormatPlain";
    private static final String EXCLUDE_JDK_CLASS_FLAG = "-IgnoreJDKClass";
    private static String[] excludeJdkClasses = new String[]{"java.util.Map", "java.lang.Object", "java.io.ByteArrayInputStream", "java.io.InputStream", "java.lang.Deprecated", "java.io.Writer", "java.io.OutputStream", "java.util.List", "java.util.Collection", "java.lang.instrument.IllegalClassFormatException", "javax.transaction.xa.XAException", "java.lang.annotation.Repeatable", "java.lang.InterruptedException", "java.lang.CloneNotSupportedException", "java.lang.Throwable", "java.lang.Thread", "java.lang.Enum"};

    @Override
    protected String normalizeFileName(File f) {
        String sURL = null;
        try {
            sURL = f.toURI().toURL().toExternalForm();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return sURL;
    }

    @Override
    protected String[] createTestArguments(String packageListFile, String mapFile, String signatureRepositoryDir, String packageOrClassUnderTest, String classpath, boolean bStaticMode) throws Exception {
        SignatureTestDriver.SignatureFileInfo info = this.getSigFileInfo(packageOrClassUnderTest, mapFile, signatureRepositoryDir);
        PackageList packageList = new PackageList(packageListFile);
        String[] subPackages = packageList.getSubPackages(packageOrClassUnderTest);
        ArrayList<String> command = new ArrayList<String>();
        if (bStaticMode) {
            TestUtil.logTrace("Setting static mode flag to allow constant checking.");
            command.add(STATIC_FLAG);
            command.add(CHECKVALUE_FLAG);
            command.add(SMODE_FLAG);
            command.add("src");
        } else {
            TestUtil.logTrace("Not Setting static mode flag to allow constant checking.");
        }
        if (TestUtil.harnessDebug) {
            command.add(DEBUG_FLAG);
        }
        command.add("-Verbose");
        command.add(FILENAME_FLAG);
        command.add(info.getFile());
        command.add(CLASSPATH_FLAG);
        command.add(classpath);
        command.add(PACKAGE_FLAG);
        command.add(packageOrClassUnderTest);
        for (int i = 0; i < subPackages.length; ++i) {
            command.add(EXCLUDE_FLAG);
            command.add(subPackages[i]);
        }
        for (String jdkClassName : excludeJdkClasses) {
            command.add(EXCLUDE_JDK_CLASS_FLAG);
            command.add(jdkClassName);
        }
        command.add(API_VERSION_FLAG);
        command.add(info.getVersion());
        return command.toArray(new String[command.size()]);
    }

    @Override
    protected boolean runSignatureTest(String packageOrClassName, String[] testArguments) throws Exception {
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.newInstance();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        TestUtil.logTrace("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (int ii = 0; ii < testArguments.length; ++ii) {
            TestUtil.logTrace("   testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        TestUtil.logMsg("********** Status Report '" + packageOrClassName + "' **********\n");
        TestUtil.logMsg(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }

    @Override
    protected boolean runPackageSearch(String packageOrClassName, String[] testArguments) throws Exception {
        int ii;
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.newInstance();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        for (ii = 0; ii < testArguments.length; ++ii) {
            if (!testArguments[ii].equals(PACKAGE_FLAG)) continue;
            testArguments[ii] = PACKAGE_NO_SUBS_FLAG;
        }
        TestUtil.logTrace("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (ii = 0; ii < testArguments.length; ++ii) {
            TestUtil.logTrace("\t  testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        TestUtil.logMsg("********** Status Report '" + packageOrClassName + "' **********\n");
        TestUtil.logMsg(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }

    @Override
    protected boolean verifyJTAJarForNoXA(String classpath, String repositoryDir) throws Exception {
        TestUtil.logMsg("SigTestDriver#verifyJTAJarForNoXA - Starting:");
        boolean result = false;
        ArrayList<Object> command = new ArrayList<Object>();
        command.add(STATIC_FLAG);
        command.add(FILENAME_FLAG);
        command.add(repositoryDir + "empty.sig");
        command.add(PACKAGE_FLAG);
        command.add("javax.transaction.xa");
        command.add(CLASSPATH_FLAG);
        command.add(classpath);
        String[] testArguments = command.toArray(new String[command.size()]);
        TestUtil.logTrace("\nCalling:  com.sun.tdk.signaturetest.SignatureTest() with following args:");
        for (int ii = 0; ii < testArguments.length; ++ii) {
            TestUtil.logTrace("   testArguments[" + ii + "] = " + testArguments[ii]);
        }
        Class<?> sigTestClass = Class.forName("com.sun.tdk.signaturetest.SignatureTest");
        Object sigTestInstance = sigTestClass.newInstance();
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Method runMethod = sigTestClass.getDeclaredMethod("run", String[].class, PrintWriter.class, PrintWriter.class);
        runMethod.invoke(sigTestInstance, testArguments, new PrintWriter(output, true), null);
        String rawMessages = output.toString();
        TestUtil.logMsg("********** Status Report JTA JAR validation **********\n");
        TestUtil.logMsg(rawMessages);
        return sigTestInstance.toString().substring(7).startsWith("Passed.");
    }
}

