/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.ee.rs.formparam;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.ee.rs.JaxrsParamClient;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityPrototype;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingExceptionGivenByName;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityThrowingWebApplicationException;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithConstructor;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithFromString;
import ee.jakarta.tck.ws.rs.ee.rs.ParamEntityWithValueOf;
import ee.jakarta.tck.ws.rs.ee.rs.RuntimeExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.WebApplicationExceptionMapper;
import ee.jakarta.tck.ws.rs.ee.rs.formparam.FormParamTest;
import ee.jakarta.tck.ws.rs.ee.rs.formparam.TSAppConfig;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JaxrsParamClient {
    private static final String ENCODED = "_%60%27%24X+Y%40%22a+a%22";
    private static final String DECODED = "_`'$X Y@\"a a\"";
    private static final long serialVersionUID = 1L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_ee_formparam_web/FormParamTest");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/ee/rs/formparam/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_ee_formparam_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, FormParamTest.class, ParamEntityPrototype.class, ParamEntityWithConstructor.class, ParamEntityWithValueOf.class, ParamEntityWithFromString.class, ParamEntityThrowingWebApplicationException.class, ParamEntityThrowingExceptionGivenByName.class, RuntimeExceptionMapper.class, WebApplicationExceptionMapper.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void nonDefaultFormParamNothingSentTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "PostNonDefParam", null);
    }

    @Test
    public void defaultFormParamSentTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "PostDefParam", ENCODED);
    }

    @Test
    public void defaultFormParamNoArgSentTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "PostDefParam", "default");
    }

    @Test
    public void defaultFormParamPutNoArgSentTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.PUT, "DefParam", "DefParam");
    }

    @Test
    public void defaultFormParamPutArgSentTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.PUT, "DefParam", DECODED);
    }

    @Test
    public void defaultFormParamValueOfTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ParamEntityWithValueOf", "ValueOf");
    }

    @Test
    public void nonDefaultFormParamValueOfTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ParamEntityWithValueOf", DECODED);
    }

    @Test
    public void defaultFormParamFromStringTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ParamEntityWithFromString", "FromString");
    }

    @Test
    public void nonDefaultFormParamFromStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ParamEntityWithFromString", ENCODED);
    }

    @Test
    public void defaultFormParamFromConstructorTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "Constructor", "Constructor");
    }

    @Test
    public void nonDefaultFormParamFromConstructorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "Constructor", DECODED);
    }

    @Test
    public void defaultFormParamFromListConstructorTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ListConstructor", "ListConstructor");
    }

    @Test
    public void nonDefaultFormParamFromListConstructorTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ListConstructor", DECODED);
    }

    @Test
    public void defaultFormParamFromSetFromStringTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "SetFromString", "SetFromString");
    }

    @Test
    public void nonDefaultFormParamFromSetFromStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "SetFromString", ENCODED);
    }

    @Test
    public void defaultFormParamFromSortedSetFromStringTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "SortedSetFromString", "SortedSetFromString");
    }

    @Test
    public void nonDefaultFormParamFromSortedSetFromStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "SortedSetFromString", ENCODED);
    }

    @Test
    public void defaultFormParamFromListFromStringTest() throws JAXRSCommonClient.Fault {
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ListFromString", "ListFromString");
    }

    @Test
    public void nonDefaultFormParamFromListFromStringTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=_%60%27%24X+Y%40%22a+a%22");
        this.defaultFormParamAndInvoke(JAXRSCommonClient.Request.POST, "ListFromString", ENCODED);
    }

    @Test
    public void formParamEntityWithEncodedTest() throws JAXRSCommonClient.Fault {
        this.searchEqualsEncoded = true;
        super.paramEntityWithEncodedTest();
    }

    @Test
    public void formParamThrowingWebApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        super.paramThrowingWebApplicationExceptionTest();
    }

    @Test
    public void formParamThrowingIllegalArgumentExceptionTest() throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, Response.Status.BAD_REQUEST.name());
        super.paramThrowingIllegalArgumentExceptionTest();
    }

    private void defaultFormParamAndInvoke(JAXRSCommonClient.Request request, String method, String arg) throws JAXRSCommonClient.Fault {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(request, method));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, FormParamTest.response(arg));
        this.invoke();
    }

    @Override
    protected String buildRequest(String param) {
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildContentType(MediaType.APPLICATION_FORM_URLENCODED_TYPE));
        this.setProperty(JAXRSCommonClient.Property.CONTENT, "default_argument=" + param.replace("=", "%3d"));
        return this.buildRequest(JAXRSCommonClient.Request.POST, JAXRSClientIT.segmentFromParam(param));
    }

    @Override
    protected String getDefaultValueOfParam(String param) {
        return null;
    }
}

