/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.common;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import jdk.incubator.http.internal.common.ByteBufferReference;

public class AsyncWriteQueue
implements Closeable {
    private static final int IDLE = 0;
    private static final int FLUSHING = 1;
    private static final int REFLUSHING = 2;
    private static final int DELAYED = 3;
    private static final int CLOSED = 4;
    private final AtomicInteger state = new AtomicInteger(0);
    private final Deque<ByteBufferReference[]> queue = new ConcurrentLinkedDeque<ByteBufferReference[]>();
    private final BiConsumer<ByteBufferReference[], AsyncWriteQueue> consumeAction;
    private final boolean doFullDrain;
    private ByteBufferReference[] delayedElement = null;

    public AsyncWriteQueue(BiConsumer<ByteBufferReference[], AsyncWriteQueue> biConsumer) {
        this(biConsumer, true);
    }

    public AsyncWriteQueue(BiConsumer<ByteBufferReference[], AsyncWriteQueue> biConsumer, boolean bl) {
        this.consumeAction = biConsumer;
        this.doFullDrain = bl;
    }

    public void put(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.ensureOpen();
        this.queue.addLast(byteBufferReferenceArray);
    }

    public void putFirst(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.ensureOpen();
        this.queue.addFirst(byteBufferReferenceArray);
    }

    public boolean flush() throws IOException {
        while (true) {
            switch (this.state.get()) {
                case 0: {
                    if (!this.state.compareAndSet(0, 1)) break;
                    this.flushLoop();
                    return true;
                }
                case 1: {
                    if (!this.state.compareAndSet(1, 2)) break;
                    return false;
                }
                case 2: 
                case 3: {
                    return false;
                }
                case 4: {
                    throw new IOException("Queue closed");
                }
            }
        }
    }

    public void flushDelayed() throws IOException {
        this.ensureOpen();
        if (!this.state.compareAndSet(3, 1)) {
            this.ensureOpen();
            throw new RuntimeException("Shouldn't happen");
        }
        this.flushLoop();
    }

    private ByteBufferReference[] drain(ByteBufferReference[] byteBufferReferenceArray) {
        assert (byteBufferReferenceArray != null);
        if (this.doFullDrain) {
            ByteBufferReference[] byteBufferReferenceArray2 = this.queue.poll();
            if (byteBufferReferenceArray2 == null) {
                return byteBufferReferenceArray;
            }
            ArrayList<ByteBufferReference> arrayList = new ArrayList<ByteBufferReference>();
            arrayList.addAll(Arrays.asList(byteBufferReferenceArray));
            arrayList.addAll(Arrays.asList(byteBufferReferenceArray2));
            while ((byteBufferReferenceArray2 = this.queue.poll()) != null) {
                arrayList.addAll(Arrays.asList(byteBufferReferenceArray2));
            }
            return arrayList.toArray(new ByteBufferReference[0]);
        }
        return byteBufferReferenceArray;
    }

    private ByteBufferReference[] drain() {
        ByteBufferReference[] byteBufferReferenceArray = this.queue.poll();
        return byteBufferReferenceArray == null ? null : this.drain(byteBufferReferenceArray);
    }

    private void flushLoop() throws IOException {
        ByteBufferReference[] byteBufferReferenceArray;
        if (this.delayedElement != null) {
            byteBufferReferenceArray = this.drain(this.delayedElement);
            this.delayedElement = null;
        } else {
            byteBufferReferenceArray = this.drain();
        }
        while (true) {
            if (byteBufferReferenceArray != null) {
                this.consumeAction.accept(byteBufferReferenceArray, this);
                if (this.state.get() == 3) {
                    return;
                }
                byteBufferReferenceArray = this.drain();
                continue;
            }
            switch (this.state.get()) {
                case 0: 
                case 3: {
                    throw new RuntimeException("Shouldn't happen");
                }
                case 1: {
                    if (!this.state.compareAndSet(1, 0)) break;
                    return;
                }
                case 2: {
                    this.state.compareAndSet(2, 1);
                    break;
                }
                case 4: {
                    throw new IOException("Queue closed");
                }
            }
            byteBufferReferenceArray = this.drain();
        }
    }

    public void setDelayed(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        while (true) {
            int n = this.state.get();
            switch (n) {
                case 0: 
                case 3: {
                    throw new RuntimeException("Shouldn't happen");
                }
                case 1: 
                case 2: {
                    if (!this.state.compareAndSet(n, 3)) break;
                    this.delayedElement = byteBufferReferenceArray;
                    return;
                }
                case 4: {
                    throw new IOException("Queue closed");
                }
            }
        }
    }

    private void ensureOpen() throws IOException {
        if (this.state.get() == 4) {
            throw new IOException("Queue closed");
        }
    }

    @Override
    public void close() throws IOException {
        this.state.getAndSet(4);
    }
}

