/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequestBuilderImpl;
import jdk.incubator.http.RequestProcessors;

public abstract class HttpRequest {
    protected HttpRequest() {
    }

    public static Builder newBuilder(URI uRI) {
        return new HttpRequestBuilderImpl(uRI);
    }

    public static Builder newBuilder() {
        return new HttpRequestBuilderImpl();
    }

    public abstract Optional<BodyProcessor> bodyProcessor();

    public abstract String method();

    public abstract Duration duration();

    public abstract boolean expectContinue();

    public abstract URI uri();

    public abstract Optional<HttpClient.Version> version();

    public abstract HttpHeaders headers();

    public static BodyProcessor noBody() {
        return new RequestProcessors.EmptyProcessor();
    }

    public static interface BodyProcessor
    extends Flow.Publisher<ByteBuffer> {
        public static BodyProcessor fromString(String string) {
            return BodyProcessor.fromString(string, StandardCharsets.UTF_8);
        }

        public static BodyProcessor fromString(String string, Charset charset) {
            return new RequestProcessors.StringProcessor(string, charset);
        }

        public static BodyProcessor fromInputStream(Supplier<? extends InputStream> supplier) {
            return new RequestProcessors.InputStreamProcessor(supplier);
        }

        public static BodyProcessor fromByteArray(byte[] byArray) {
            return new RequestProcessors.ByteArrayProcessor(byArray);
        }

        public static BodyProcessor fromByteArray(byte[] byArray, int n, int n2) {
            return new RequestProcessors.ByteArrayProcessor(byArray, n, n2);
        }

        public static BodyProcessor fromFile(Path path) throws FileNotFoundException {
            return new RequestProcessors.FileProcessor(path);
        }

        public static BodyProcessor fromByteArrays(Iterable<byte[]> iterable) {
            return new RequestProcessors.IterableProcessor(iterable);
        }

        public long contentLength();
    }

    public static abstract class Builder {
        protected Builder() {
        }

        public abstract Builder uri(URI var1);

        public abstract Builder expectContinue(boolean var1);

        public abstract Builder version(HttpClient.Version var1);

        public abstract Builder header(String var1, String var2);

        public abstract Builder headers(String ... var1);

        public abstract Builder timeout(Duration var1);

        public abstract Builder setHeader(String var1, String var2);

        public abstract Builder GET();

        public abstract Builder POST(BodyProcessor var1);

        public abstract Builder PUT(BodyProcessor var1);

        public abstract Builder DELETE(BodyProcessor var1);

        public abstract Builder method(String var1, BodyProcessor var2);

        public abstract HttpRequest build();

        public abstract Builder copy();
    }
}

