/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Flow;
import java.util.function.Consumer;
import java.util.function.Function;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.MultiMapResult;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.common.MinimalFuture;
import jdk.incubator.http.internal.common.Utils;

class ResponseProcessors {
    ResponseProcessors() {
    }

    static class NullProcessor<T>
    implements HttpResponse.BodyProcessor<T> {
        Flow.Subscription subscription;
        final CompletableFuture<T> cf = new MinimalFuture();
        final Optional<T> result;

        NullProcessor(Optional<T> optional) {
            this.result = optional;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            byteBuffer.position(byteBuffer.limit());
        }

        @Override
        public void onError(Throwable throwable) {
            this.cf.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            if (this.result.isPresent()) {
                this.cf.complete(this.result.get());
            } else {
                this.cf.complete(null);
            }
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.cf;
        }
    }

    static class MultiFile {
        final Path pathRoot;

        MultiFile(Path path) {
            if (!path.toFile().isDirectory()) {
                throw new UncheckedIOException(new IOException("destination is not a directory"));
            }
            this.pathRoot = path;
        }

        Optional<HttpResponse.BodyHandler<Path>> handlePush(HttpRequest httpRequest) {
            URI uRI = httpRequest.uri();
            String string = uRI.getPath();
            while (string.startsWith("/")) {
                string = string.substring(1);
            }
            Path path = this.pathRoot.resolve(string);
            if (Log.trace()) {
                Log.logTrace("Creating file body processor for URI={0}, path={1}", uRI, path);
            }
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException iOException) {
                throw new UncheckedIOException(iOException);
            }
            HttpResponse.BodyHandler<Path> bodyHandler = HttpResponse.BodyHandler.asFile(path);
            return Optional.of(bodyHandler);
        }
    }

    static class MultiProcessorImpl<V>
    implements HttpResponse.MultiProcessor<MultiMapResult<V>, V> {
        private final MultiMapResult<V> results = new MultiMapResult(new ConcurrentHashMap());
        private final Function<HttpRequest, Optional<HttpResponse.BodyHandler<V>>> pushHandler;
        private final boolean completion;

        MultiProcessorImpl(Function<HttpRequest, Optional<HttpResponse.BodyHandler<V>>> function, boolean bl) {
            this.pushHandler = function;
            this.completion = bl;
        }

        @Override
        public Optional<HttpResponse.BodyHandler<V>> onRequest(HttpRequest httpRequest) {
            return this.pushHandler.apply(httpRequest);
        }

        @Override
        public void onResponse(HttpResponse<V> httpResponse) {
            this.results.put(httpResponse.request(), CompletableFuture.completedFuture(httpResponse));
        }

        @Override
        public void onError(HttpRequest httpRequest, Throwable throwable) {
            this.results.put(httpRequest, MinimalFuture.failedFuture(throwable));
        }

        @Override
        public CompletableFuture<MultiMapResult<V>> completion(CompletableFuture<Void> completableFuture, CompletableFuture<Void> completableFuture2) {
            if (this.completion) {
                return completableFuture.thenApply(void_ -> this.results);
            }
            return completableFuture2.thenApply(void_ -> this.results);
        }
    }

    static class ByteArrayProcessor<T>
    implements HttpResponse.BodyProcessor<T> {
        private final Function<byte[], T> finisher;
        private final CompletableFuture<T> result = new MinimalFuture();
        private final List<ByteBuffer> received = new ArrayList<ByteBuffer>();
        private Flow.Subscription subscription;

        ByteArrayProcessor(Function<byte[], T> function) {
            this.finisher = function;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (this.subscription != null) {
                subscription.cancel();
                return;
            }
            this.subscription = subscription;
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            if (byteBuffer.hasRemaining()) {
                this.received.add(byteBuffer);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.received.clear();
            this.result.completeExceptionally(throwable);
        }

        private static byte[] join(List<ByteBuffer> list) {
            int n = Utils.remaining(list);
            byte[] byArray = new byte[n];
            int n2 = 0;
            for (ByteBuffer byteBuffer : list) {
                int n3 = byteBuffer.remaining();
                byteBuffer.get(byArray, n2, n3);
                n2 += n3;
            }
            return byArray;
        }

        @Override
        public void onComplete() {
            try {
                this.result.complete(this.finisher.apply(ByteArrayProcessor.join(this.received)));
                this.received.clear();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.result.completeExceptionally(illegalArgumentException);
            }
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.result;
        }
    }

    static class PathProcessor
    implements HttpResponse.BodyProcessor<Path> {
        private final Path file;
        private final CompletableFuture<Path> result = new MinimalFuture<Path>();
        private Flow.Subscription subscription;
        private FileChannel out;
        private final OpenOption[] options;

        PathProcessor(Path path, OpenOption ... openOptionArray) {
            this.file = path;
            this.options = openOptionArray;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            try {
                this.out = FileChannel.open(this.file, this.options);
            }
            catch (IOException iOException) {
                this.result.completeExceptionally(iOException);
                subscription.cancel();
                return;
            }
            subscription.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            try {
                this.out.write(byteBuffer);
            }
            catch (IOException iOException) {
                Utils.close(this.out);
                this.subscription.cancel();
                this.result.completeExceptionally(iOException);
            }
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            this.result.completeExceptionally(throwable);
            Utils.close(this.out);
        }

        @Override
        public void onComplete() {
            Utils.close(this.out);
            this.result.complete(this.file);
        }

        @Override
        public CompletionStage<Path> getBody() {
            return this.result;
        }
    }

    static class ConsumerProcessor
    implements HttpResponse.BodyProcessor<Void> {
        private final Consumer<Optional<byte[]>> consumer;
        private Flow.Subscription subscription;
        private final CompletableFuture<Void> result = new MinimalFuture<Void>();

        ConsumerProcessor(Consumer<Optional<byte[]>> consumer) {
            this.consumer = consumer;
        }

        @Override
        public CompletionStage<Void> getBody() {
            return this.result;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            subscription.request(1L);
        }

        @Override
        public void onNext(ByteBuffer byteBuffer) {
            byte[] byArray = new byte[byteBuffer.remaining()];
            byteBuffer.get(byArray);
            this.consumer.accept(Optional.of(byArray));
            this.subscription.request(1L);
        }

        @Override
        public void onError(Throwable throwable) {
            this.result.completeExceptionally(throwable);
        }

        @Override
        public void onComplete() {
            this.consumer.accept(Optional.empty());
            this.result.complete(null);
        }
    }
}

