/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonstreamingtests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void streamingTest1() throws EETest.Fault {
        boolean pass = true;
        try (Object reader = null;){
            String expJsonText = "[1,2,3,4,5,6,7,8,9,10]";
            this.logMsg("expJsonText=" + expJsonText);
            this.logMsg("Generate stream of Json Text containing a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(1).write(2).write(3).write(4).write(5).write(6).write(7).write(8).write(9).write(10).writeEnd();
            generator.close();
            String actJsonText = JSONP_Util.removeWhitespace(sWriter.toString());
            this.logMsg("actJsonText=" + actJsonText);
            this.logMsg("Compare expJsonText and actJsonText for equality");
            pass = JSONP_Util.assertEqualsJsonText(expJsonText, actJsonText);
        }
        if (!pass) {
            throw new EETest.Fault("streamingTest1 Failed");
        }
    }

    public void streamingTest2() throws EETest.Fault {
        boolean pass = true;
        try (JsonReader reader = null;){
            this.logMsg("Generate data containing a JsonArray");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartArray().write(2).write(4).write(6).write(8).write(10).writeEnd();
            generator.close();
            this.logMsg("Read data from Writer stream containing a JsonArray");
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonArray expJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of expJsonArray");
            JSONP_Util.dumpJsonArray(expJsonArray);
            this.logMsg("Write JsonArray out to a Writer stream");
            sWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)sWriter);
            writer.writeArray(expJsonArray);
            this.logMsg("Close JsonWriter");
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("writerContents=" + writerContents);
            this.logMsg("Re-read data from Writer stream containing a JsonArray");
            reader = Json.createReader((Reader)new StringReader(writerContents));
            JsonArray actJsonArray = reader.readArray();
            TestUtil.logMsg((String)"Dump of actJsonArray");
            JSONP_Util.dumpJsonArray(actJsonArray);
            this.logMsg("Compare expJsonArray and actJsonArray for equality");
            pass = JSONP_Util.assertEqualsJsonArrays(expJsonArray, actJsonArray);
        }
        if (!pass) {
            throw new EETest.Fault("streamingTest2 Failed");
        }
    }

    public void streamingTest3() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser = null;
        try (JsonReader reader = null;){
            this.logMsg("Generate data containing a JsonObject");
            StringWriter sWriter = new StringWriter();
            JsonGenerator generator = Json.createGenerator((Writer)sWriter);
            generator.writeStartObject().write("two", 2).write("false", false).writeEnd();
            generator.close();
            this.logMsg("Read data from Writer stream containing a JsonObject");
            reader = Json.createReader((Reader)new StringReader(sWriter.toString()));
            JsonObject expJsonObject = reader.readObject();
            TestUtil.logMsg((String)"Dump of expJsonObject");
            JSONP_Util.dumpJsonObject(expJsonObject);
            this.logMsg("Write JsonObject out to a Writer stream");
            sWriter = new StringWriter();
            JsonWriter writer = Json.createWriter((Writer)sWriter);
            writer.writeObject(expJsonObject);
            this.logMsg("Close JsonWriter");
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = sWriter.toString();
            this.logMsg("writerContents=" + writerContents);
            this.logMsg("Parse data from Writer stream containing a JsonObject");
            parser = Json.createParser((InputStream)JSONP_Util.getInputStreamFromString(writerContents));
            JSONP_Util.resetParseErrs();
            JSONP_Util.testEventType(parser, JsonParser.Event.START_OBJECT);
            JSONP_Util.testKeyIntegerValue(parser, "two", 2);
            JSONP_Util.testKeyFalseValue(parser, "false");
            JSONP_Util.testEventType(parser, JsonParser.Event.END_OBJECT);
            int parseErrs = JSONP_Util.getParseErrs();
            if (parseErrs != 0) {
                this.logErr("There were " + parseErrs + " parser errors that occurred.");
                pass = false;
            }
        }
        if (!pass) {
            throw new EETest.Fault("streamingTest3 Failed");
        }
    }

    public void streamingTest4() throws EETest.Fault {
        boolean pass = true;
        JsonReader reader = null;
        Object parser = null;
        String expJsonText = "{\"two\":2,\"false\":false}";
        try {
            this.logMsg("Generate data containing a JsonObject to an OutputStream");
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            JsonGenerator generator = Json.createGenerator((OutputStream)baos);
            generator.writeStartObject().write("two", 2).write("false", false).writeEnd();
            baos.close();
            generator.close();
            this.logMsg("Compare JSON text generated to what is expected.");
            if (!JSONP_Util.assertEqualsJsonText(expJsonText, JSONP_Util.removeWhitespace(baos.toString("UTF-8")))) {
                pass = false;
            }
            this.logMsg("Read data from InputStream containing a JsonObject");
            reader = Json.createReader((InputStream)JSONP_Util.getInputStreamFromString(baos.toString("UTF-8")));
            JsonObject expJsonObject = reader.readObject();
            this.logMsg("Close JsonReader");
            reader.close();
            TestUtil.logMsg((String)"Dump of expJsonObject");
            JSONP_Util.dumpJsonObject(expJsonObject);
            this.logMsg("Write JsonObject back out to an OutputStream");
            baos = new ByteArrayOutputStream();
            JsonWriter writer = Json.createWriter((OutputStream)baos);
            writer.writeObject(expJsonObject);
            this.logMsg("Close JsonWriter");
            baos.close();
            writer.close();
            this.logMsg("Save contents of the JsonWriter as a String");
            String writerContents = baos.toString("UTF-8");
            this.logMsg("writerContents=" + writerContents);
            this.logMsg("Compare again JSON text generated to what is expected.");
            if (!JSONP_Util.assertEqualsJsonText(expJsonText, JSONP_Util.removeWhitespace(writerContents))) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("streamingTest4 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("streamingTest4 Failed");
        }
    }
}

