/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp.DataStoreRemote;
import com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp.HelloService;
import com.sun.ts.tests.appclient.deploy.metadatacomplete.testapp.TestBean;
import jakarta.annotation.Resource;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.ejb.EJB;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.JMSConnectionFactoryDefinition;
import jakarta.jms.JMSDestinationDefinition;
import jakarta.jms.Queue;
import jakarta.mail.MailSessionDefinition;
import jakarta.mail.Session;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnit;
import jakarta.xml.ws.WebServiceRef;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@MailSessionDefinition(name="java:comp/myMailSession", host="smtp.gmail.com", transportProtocol="smtps", properties={"mail.debug=true"})
@DataSourceDefinition(name="java:global/MyApp/MyDataSource", className="org.apache.derby.jdbc.ClientDataSource", url="jdbc:derby://localhost:1527/derbyDB;create=true", user="cts1", password="cts1")
@JMSConnectionFactoryDefinition(description="Define ConnectionFactory JSPMyTestConnectionFactory", interfaceName="jakarta.jms.ConnectionFactory", name="java:global/JSPMyTestConnectionFactory", user="j2ee", password="j2ee")
@JMSDestinationDefinition(name="java:app/jms/myappTopic", interfaceName="jakarta.jms.Topic", destinationName="MyPhysicalAppTopic")
public class TestAppClient
extends EETest {
    private InitialContext initialContext;
    private TSNamingContext nctx = null;
    private Properties props = null;
    @Resource(lookup="java:module/mybean")
    private static TestBean bean;
    @Resource(lookup="java:comp/myMailSession")
    private static Session session;
    @EJB
    static DataStoreRemote dataStore;
    @WebServiceRef(name="service/HelloService")
    static HelloService service;
    @Resource(lookup="java:app/jms/TestConnectionFactory")
    private static ConnectionFactory testFac;
    @Resource(lookup="java:app/jms/TestQ")
    private static Queue testQueue;
    @PersistenceUnit(unitName="TEST-EM-APPCLIENT")
    static EntityManagerFactory emf;
    @Resource(lookup="java:global/MyApp/MyDataSource")
    private static Object dataSource;
    @Resource(lookup="java:global/JSPMyTestConnectionFactory")
    private static Object connFactory;
    @Resource(lookup="java:app/jms/myappTopic")
    private static Object destination;

    private Object lookup(String jndiName) throws NamingException {
        return this.initialContext.lookup(jndiName);
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        this.props = props;
        try {
            this.nctx = new TSNamingContext();
            this.logMsg("[Client] Setup succeed (got naming context).");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public static void main(String[] args) {
        TestAppClient theTests = new TestAppClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void testResourceLookup() throws EETest.Fault {
        try {
            Object mybean = this.nctx.lookup("java:module/mybean");
            this.logMsg("mybean" + mybean);
            if (null == mybean) {
                throw new EETest.Fault("lookup failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("lookup failed: " + e, e);
        }
    }

    public void testResourceAnnotation() throws EETest.Fault {
        try {
            this.logMsg("bean" + bean);
            if (null != bean) {
                throw new EETest.Fault("ResourceAnnotation test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ResourceAnnotation test failed: " + e, e);
        }
    }

    public void testMailSession() throws EETest.Fault {
        try {
            Object sess = this.nctx.lookup("mail/Session");
            this.logMsg("sess" + sess);
            if (null == sess) {
                throw new EETest.Fault("lookup failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("MailSession test failed: " + e, e);
        }
    }

    public void testMailSessionDefinition() throws EETest.Fault {
        try {
            this.logMsg("session" + session);
            if (null != session) {
                throw new EETest.Fault("MailSessionDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("MailSessionDefinition test failed: " + e, e);
        }
    }

    public void testEJBAnnotation() throws EETest.Fault {
        try {
            this.logMsg("datastore" + dataStore);
            if (null != dataStore) {
                throw new EETest.Fault("EJBAnnotation test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("EJBAnnotation test failed: " + e, e);
        }
    }

    public void testWebServiceRefAnnotation() throws EETest.Fault {
        try {
            this.logMsg("service" + (Object)((Object)service));
            if (null != service) {
                throw new EETest.Fault("WebServiceRefAnnotation test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("WebServiceRefAnnotation test failed: " + e, e);
        }
    }

    public void testDataSourceDefinitionAnnotation() throws EETest.Fault {
        try {
            if (dataSource != null) {
                throw new EETest.Fault("DataSourceDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("DataSourceDefinition test failed: " + e, e);
        }
    }

    public void testJMSConnectionFactoryDefinitionAnnotation() throws EETest.Fault {
        try {
            this.logMsg("connFactory" + connFactory);
            if (connFactory != null) {
                throw new EETest.Fault("JMSConnectionFactoryDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("JMSConnectionFactoryDefinition test failed: " + e, e);
        }
    }

    public void testJMSDestinationDefinitionAnnotation() throws EETest.Fault {
        try {
            this.logMsg("destination" + destination);
            if (destination != null) {
                throw new EETest.Fault("JMSDestinationDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("JMSDestinationDefinition test failed: " + e, e);
        }
    }

    public void testConnectionFactoryDefinitionAnnotation() throws EETest.Fault {
        try {
            this.logMsg("testFac" + testFac);
            if (testFac != null) {
                throw new EETest.Fault("ConnectionFactoryDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ConnectionFactoryDefinition test failed: " + e, e);
        }
    }

    public void testAdministeredObjectDefinitionAnnotation() throws EETest.Fault {
        try {
            this.logMsg("testQueue" + testQueue);
            if (testFac != null) {
                throw new EETest.Fault("AdministeredObjectDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("AdministeredObjectDefinition test failed: " + e, e);
        }
    }

    public void testPersistenceUnitDefinitionAnnotation() throws EETest.Fault {
        try {
            this.logMsg("emf" + emf);
            if (emf != null) {
                throw new EETest.Fault("PersistenceUnitDefinition test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("PersistenceUnitDefinition test failed: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

