/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.ejbql.equality;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.AliasHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Customer;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.CustomerHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.OrderHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.ProductHome;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Schema;
import com.sun.ts.tests.ejb.ee.pm.ejbql.schema.Util;
import java.util.Collection;
import java.util.Properties;

public class Client
extends EETest {
    private CustomerHome customerHome = null;
    private OrderHome orderHome = null;
    private AliasHome aliasHome = null;
    private ProductHome productHome = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.props = p;
            Schema.setup(p);
            this.customerHome = Schema.customerHome;
            this.orderHome = Schema.orderHome;
            this.aliasHome = Schema.aliasHome;
            this.productHome = Schema.productHome;
        }
        catch (Exception e) {
            TestUtil.logMsg((String)("Exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void equalityTest1() throws EETest.Fault {
        boolean pass = true;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Determine the equality of two strings");
            c = this.customerHome.findCustomerByQuery16();
            if (!Util.checkEJB(c, "3")) {
                TestUtil.logErr((String)"UnSuccessfully found customer Shelly D. Mcgowan");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found customer Shelly D. Mcgowan");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest1 failed");
        }
    }

    public void equalityTest2() throws EETest.Fault {
        boolean pass = true;
        Object expectedPKs = null;
        Customer c = null;
        try {
            TestUtil.logMsg((String)"Determine the equality of two entity objects");
            c = this.customerHome.findCustomerByQuery17("Shelly D. Mcgowan");
            if (!Util.checkEJB(c, "3")) {
                TestUtil.logErr((String)"UnSuccessfully compared the equality of two entity objects");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully compared the equality of two entity objects");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest2 failed");
        }
    }

    public void equalityTest3() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection c = null;
        try {
            TestUtil.logMsg((String)"Compare the equality of strings");
            c = this.customerHome.findCustomersByQuery27();
            expectedPKs = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "13", "14"};
            if (!Util.checkEJBs(c, 1, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully compared the equality of strings");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully compared the equality of strings.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest3 failed");
        }
    }

    public void equalityTest4() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Compare Boolean fields");
            o = this.orderHome.findApprovedCreditCards();
            expectedPKs = new String[]{"1", "7", "11", "13"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully compared Boolean fields");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully compared Boolean fields.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest4 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest4 failed");
        }
    }

    public void equalityTest5() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection o = null;
        try {
            TestUtil.logMsg((String)"Find credit cards that expired on 03/05.");
            o = this.orderHome.selectAllExpiredCreditCards();
            expectedPKs = new String[]{"8"};
            if (!Util.checkEJBs(o, 2, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully found expired credit cards.");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully found expired credit cards.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest5 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest5 failed");
        }
    }

    public void equalityTest6() throws EETest.Fault {
        boolean pass = true;
        String[] expectedPKs = null;
        Collection p = null;
        try {
            TestUtil.logMsg((String)"Compare exact numeric values and approximate numeric values");
            p = this.productHome.findProductsByQuery1();
            expectedPKs = new String[]{"1", "2"};
            if (!Util.checkEJBs(p, 4, expectedPKs)) {
                TestUtil.logErr((String)"UnSuccessfully compared exact and approximate numeric values");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully compared exact and approximate numeric values.");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception equalityTest6: " + e));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("equalityTest6 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("equalityTest6 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup ok");
    }
}

