/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.basictype;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.basictype.Order;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getJavaType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                Attribute attrib = mTypeOrder.getDeclaredAttribute("id");
                if (attrib != null) {
                    String type = attrib.getJavaType().getName();
                    if (type.equals("int")) {
                        TestUtil.logTrace((String)"Received expected type: int");
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: int, actual:" + type));
                    }
                } else {
                    TestUtil.logErr((String)"getDeclaredAttribute(...) returned null");
                }
            } else {
                TestUtil.logErr((String)"managedType(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getJavaType Test failed");
        }
    }

    public void getPersistenceType() throws EETest.Fault {
        boolean pass = false;
        String expected = Type.PersistenceType.ENTITY.name();
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EntityType eType = metaModel.entity(Order.class);
            if (eType != null) {
                Type.PersistenceType type = eType.getPersistenceType();
                if (type != null) {
                    String sType = type.name();
                    if (sType.equals(expected)) {
                        TestUtil.logTrace((String)("Received:" + sType));
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Expected: " + expected + ", actual:" + sType));
                    }
                } else {
                    TestUtil.logErr((String)"getPersistenceType() returned null");
                }
            } else {
                TestUtil.logErr((String)"entity(...) returned null");
            }
        } else {
            TestUtil.logErr((String)"getMetamodel() returned null");
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getPersistenceType failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

