/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.metamodelapi.type;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.metamodelapi.type.Address;
import com.sun.ts.tests.jpa.core.metamodelapi.type.Order;
import jakarta.persistence.metamodel.EmbeddableType;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.persistence.metamodel.Type;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getPersistenceType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Type.PersistenceType type = mTypeOrder.getPersistenceType();
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                if (type.equals((Object)Type.PersistenceType.ENTITY)) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Persistence type = " + type.name()));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getPersistenceType Test  failed");
        }
    }

    public void getEmbeddablePersistenceType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            EmbeddableType eTypeAddress = metaModel.embeddable(Address.class);
            if (eTypeAddress != null) {
                Type.PersistenceType type = eTypeAddress.getPersistenceType();
                TestUtil.logTrace((String)"Obtained Non-null Embeddable Type");
                if (type.equals((Object)Type.PersistenceType.EMBEDDABLE)) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("Persistence type = " + type));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getEmbeddablePersistenceType Test  failed");
        }
    }

    public void getJavaType() throws EETest.Fault {
        boolean pass = false;
        this.getEntityTransaction().begin();
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        if (metaModel != null) {
            TestUtil.logTrace((String)"Obtained Non-null Metamodel from EntityManager");
            ManagedType mTypeOrder = metaModel.managedType(Order.class);
            if (mTypeOrder != null) {
                Class javaType = mTypeOrder.getJavaType();
                TestUtil.logTrace((String)"Obtained Non-null ManagedType");
                if (javaType.getName().equals("com.sun.ts.tests.jpa.core.metamodelapi.type.Order")) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("javaType name = " + javaType.getName()));
                }
            }
        }
        this.getEntityTransaction().commit();
        if (!pass) {
            throw new EETest.Fault("getJavaType Test  failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"Cleanup data");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
    }
}

