/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.dates;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.MappingTester;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.CalendarContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.DateContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.DurationContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.GregorianCalendarContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.InstantContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.LocalDateContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.LocalDateTimeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.LocalTimeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.OffsetDateTimeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.OffsetTimeContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.PeriodContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.SimpleTimeZoneContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.TimeZoneContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.ZoneIdContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.ZoneOffsetContainer;
import com.sun.ts.tests.jsonb.defaultmapping.dates.model.ZonedDateTimeContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.function.BiPredicate;

public class DatesMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private static final String OFFSET_HOURS = DatesMappingTest.getHoursFromUTCRegExp(new GregorianCalendar(1970, 0, 1));

    private <T extends TimeZone> BiPredicate<T, T> timezoneTest(boolean canBeSaving) {
        return (a, b) -> {
            long diff = Math.abs(a.getRawOffset() - b.getRawOffset());
            return a.useDaylightTime() && canBeSaving ? diff == 0L || diff == (long)a.getDSTSavings() : diff == 0L;
        };
    }

    public static void main(String[] args) {
        DatesMappingTest t = new DatesMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void testDate() throws EETest.Fault {
        Date date = new Date(70, 0, 1);
        Jsonb jsonb = JsonbBuilder.create();
        Date mixin = (Date)jsonb.fromJson(jsonb.toJson(jsonb.fromJson(jsonb.toJson((Object)date), Date.class)), Date.class);
        if (date.getTime() != mixin.getTime()) {
            throw new EETest.Fault("Serializing and deserializing Date results in different value");
        }
    }

    public Status testDateNoTimeMapping() throws EETest.Fault {
        Date date = new Date(70, 0, 1);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String toMatch = dtf.format(calendar.toZonedDateTime()).replace("]", "\\]").replace("[", "\\[").replace("+", "\\+");
        return new MappingTester(DateContainer.class).setMarshallExpectedRegExp("\"" + toMatch + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.equals(orig.getTime());
        }).test(date, "\"1970-01-01T00:00:00\"");
    }

    public Status testCalendarNoTimeMapping() throws EETest.Fault {
        Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.clear();
        return new MappingTester(CalendarContainer.class).setMarshallExpectedRegExp("\"1970-01-01" + OFFSET_HOURS + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.getTime().equals(orig.getTime()) && DatesMappingTest.getHoursFromUTC(orig).equals(DatesMappingTest.getHoursFromUTC(b));
        }).test(calendarProperty, "\"1970-01-01\"");
    }

    public Status testGregorianCalendarNoTimeMapping() throws EETest.Fault {
        GregorianCalendar calendar = new GregorianCalendar(1970, 0, 1);
        for (int i = 6; i != 15; ++i) {
            calendar.clear(i);
        }
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE;
        String toMatch = "\"" + dtf.format(calendar.toZonedDateTime()).replace("+", "\\+") + "\"";
        return new MappingTester(GregorianCalendarContainer.class).setMarshallExpectedRegExp(toMatch).setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.getTime().equals(orig.getTime()) && DatesMappingTest.getHoursFromUTC(orig).equals(DatesMappingTest.getHoursFromUTC(b));
        }).test(calendar, "\"1970-01-01\"");
    }

    public Status testDateWithTimeMapping() throws EETest.Fault {
        Date date = new Date(70, 0, 1, 0, 0, 0);
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        DateTimeFormatter dtf = DateTimeFormatter.ISO_DATE_TIME;
        String toMatch = dtf.format(calendar.toZonedDateTime()).replace("]", "\\]").replace("[", "\\[");
        return new MappingTester(DateContainer.class).setMarshallExpectedRegExp("\"" + toMatch + "\"").setUnmarshallTestPredicate((a, b) -> {
            GregorianCalendar orig = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            orig.clear();
            orig.set(1970, 0, 1);
            return b.equals(orig.getTime());
        }).test(date, "\"1970-01-01T00:00:00\"");
    }

    public Status testCalendarWithTimeMapping() throws EETest.Fault {
        Calendar calendarProperty = Calendar.getInstance();
        calendarProperty.set(1970, 0, 1, 1, 0, 0);
        calendarProperty.set(14, 0);
        calendarProperty.setTimeZone(TimeZone.getTimeZone("Europe/Paris"));
        return new MappingTester(CalendarContainer.class).setMarshallExpectedRegExp("\"1970-01-01T01:00:00(\\.\\d{1,3})?\\+01:00\\[Europe/Paris\\]\"").setUnmarshallTestPredicate((a, b) -> a.getTime().equals(b.getTime()) && DatesMappingTest.getHoursFromUTC(calendarProperty).equals(DatesMappingTest.getHoursFromUTC(b))).test(calendarProperty, "\"1970-01-01T01:00:00.00+01:00[Europe/Paris]\"");
    }

    public Status testGregorianCalendarWithTimeMapping() throws EETest.Fault {
        GregorianCalendar calendar = GregorianCalendar.from(ZonedDateTime.of(LocalDateTime.of(1970, 1, 1, 1, 0, 0), ZoneId.of("GMT")));
        return new MappingTester<GregorianCalendar>(GregorianCalendarContainer.class).test(calendar, "\"1970-01-01T01:00:00Z[GMT]\"");
    }

    public Status testShortTimeZoneMapping() throws EETest.Fault {
        return new MappingTester(TimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(false)).test(TimeZone.getTimeZone("GMT+10"), "\"GMT+10:00\"");
    }

    public Status testLongTimeZoneMapping() throws EETest.Fault {
        return new MappingTester(TimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(true)).test(TimeZone.getTimeZone("America/Los_Angeles"), "\"America/Los_Angeles\"");
    }

    public Status testSimpleTimeZoneMapping() throws EETest.Fault {
        return new MappingTester(SimpleTimeZoneContainer.class).setUnmarshallTestPredicate(this.timezoneTest(false)).test(new SimpleTimeZone(4500000, "GMT+01:15"), "\"GMT+01:15\"");
    }

    public Status testInstantMapping() throws EETest.Fault {
        return new MappingTester<Instant>(InstantContainer.class).test(Instant.ofEpochMilli(0L), "\"1970-01-01T00:00:00Z\"");
    }

    public Status testDurationMapping() throws EETest.Fault {
        return new MappingTester<Duration>(DurationContainer.class).test(Duration.ofHours(1L), "\"PT1H\"");
    }

    public Status testDurationWithSecondsMapping() throws EETest.Fault {
        return new MappingTester<Duration>(DurationContainer.class).test(Duration.ofHours(1L).plus(Duration.ofSeconds(1L)), "\"PT1H1S\"");
    }

    public Status testPeriodMapping() throws EETest.Fault {
        return new MappingTester<Period>(PeriodContainer.class).test(Period.of(1, 1, 1), "\"P1Y1M1D\"");
    }

    public Status testZeroDaysPeriodMapping() throws EETest.Fault {
        return new MappingTester<Period>(PeriodContainer.class).test(Period.of(0, 0, 0), "\"P0D\"");
    }

    public Status testLocalDateMapping() throws EETest.Fault {
        return new MappingTester<LocalDate>(LocalDateContainer.class).test(LocalDate.of(2000, 1, 1), "\"2000-01-01\"");
    }

    public Status testLocalTimeMapping() throws EETest.Fault {
        return new MappingTester<LocalTime>(LocalTimeContainer.class).test(LocalTime.of(1, 1, 1), "\"01:01:01\"");
    }

    public Status testLocalDateTimeMapping() throws EETest.Fault {
        return new MappingTester<LocalDateTime>(LocalDateTimeContainer.class).test(LocalDateTime.of(2000, 1, 1, 1, 1, 1), "\"2000-01-01T01:01:01\"");
    }

    public Status testZonedDateTimeMapping() throws EETest.Fault {
        return new MappingTester<ZonedDateTime>(ZonedDateTimeContainer.class).test(ZonedDateTime.of(2000, 1, 1, 1, 1, 1, 0, ZoneId.of("Europe/Paris")), "\"2000-01-01T01:01:01+01:00[Europe/Paris]\"");
    }

    public Status testZoneIdMapping() throws EETest.Fault {
        return new MappingTester<ZoneId>(ZoneIdContainer.class).test(ZoneId.of("UTC"), "\"UTC\"");
    }

    public Status testZoneOffsetMapping() throws EETest.Fault {
        return new MappingTester<ZoneOffset>(ZoneOffsetContainer.class).test(ZoneOffset.of("+01:00"), "\"+01:00\"");
    }

    public Status testOffsetDateTimeMapping() throws EETest.Fault {
        return new MappingTester<OffsetDateTime>(OffsetDateTimeContainer.class).test(OffsetDateTime.of(LocalDateTime.of(2000, 1, 1, 1, 1, 1), ZoneOffset.of("+01:00")), "\"2000-01-01T01:01:01+01:00\"");
    }

    public Status testOffsetTimeMapping() throws EETest.Fault {
        return new MappingTester<OffsetTime>(OffsetTimeContainer.class).test(OffsetTime.of(LocalTime.of(1, 1, 1), ZoneOffset.of("+01:00")), "\"01:01:01+01:00\"");
    }

    public Status testUnmarshallingUnknownFormat() throws EETest.Fault {
        try {
            JsonbBuilder.create().fromJson("{ \"instance\" : \"01/01/1970 00:00:00\" }", DateContainer.class);
            throw new EETest.Fault("An exception is expected if the date/time string does not correspond to the expected datetime format.");
        }
        catch (JsonbException x) {
            return Status.passed((String)"OK");
        }
    }

    public void testUnmarshallingDeprecatedTimezoneIds() throws EETest.Fault {
        try {
            JsonbBuilder.create().fromJson("{ \"instance\" : \"CST\" }", TimeZoneContainer.class);
            throw new EETest.Fault("An exception is expected for deprecated three-letter time zone IDs.");
        }
        catch (JsonbException jsonbException) {
            try {
                JsonbBuilder.create().fromJson("{ \"instance\" : \"CST\" }", SimpleTimeZoneContainer.class);
                throw new EETest.Fault("An exception is expected for deprecated three-letter time zone IDs.");
            }
            catch (JsonbException jsonbException2) {
                return;
            }
        }
    }

    private static String getHoursFromUTCRegExp(Calendar calendar) {
        String hours = DatesMappingTest.getHoursFromUTC(calendar);
        if ("+00:00".equals(hours)) {
            return "(Z|\\+00:00)";
        }
        return "\\" + hours;
    }

    private static String getHoursFromUTC(Calendar calendar) {
        int offsetInTenMins = DatesMappingTest.getMinutesFromUTC(calendar);
        String offset = String.format("%s%02d:%02d", offsetInTenMins >= 0 ? "+" : "-", Math.abs(offsetInTenMins / 60), Math.abs(offsetInTenMins % 60));
        return offset;
    }

    private static int getMinutesFromUTC(Calendar calendar) {
        TimeZone tz = TimeZone.getDefault();
        Calendar def = (Calendar)calendar.clone();
        def.get(10);
        return tz.getOffset(def.getTimeInMillis()) / 60000;
    }
}

