/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.platform.container.asyncresponse;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JdkLoggingFilter;
import com.sun.ts.tests.jaxrs.common.provider.PrintingErrorHandler;
import com.sun.ts.tests.jaxrs.common.util.JaxrsUtil;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.AsyncResponseBlockingQueue;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.Resource;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.ServiceUnavailableExceptionMapper;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.TSAppConfig;
import com.sun.ts.tests.jaxrs.platform.container.asyncresponse.TckTimeoutHandler;
import jakarta.ws.rs.client.AsyncInvoker;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 8496602126019947248L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_platform_container_asyncresponse_web/resource");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("com/sun/ts/tests/jaxrs/platform/container/asyncresponse/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_platform_container_asyncresponse_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, Resource.class, AsyncResponseBlockingQueue.class, ServiceUnavailableExceptionMapper.class, TckTimeoutHandler.class, PrintingErrorHandler.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @Test
    public void cancelVoidTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> cancel = this.invokeRequest("cancelvoid?stage=0");
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.SERVICE_UNAVAILABLE);
        JAXRSClientIT.assertString(cancel, "A method return true");
    }

    @Test
    public void cancelVoidOnResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> cancel = this.invokeRequest("cancelvoid?stage=1");
        JAXRSClientIT.assertString(cancel, "A method returned false");
    }

    @Test
    public void cancelVoidOnCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> cancel = this.invokeRequest("cancelvoid?stage=1");
        JAXRSClientIT.assertString(cancel, "A method return true");
    }

    @Test
    public void resumeCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> resumeCanceled = this.invokeRequest("resume?stage=1", "");
        JAXRSClientIT.assertString(resumeCanceled, "A method returned false");
    }

    @Test
    public void cancelIntTest() throws Exception {
        String seconds = "20";
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> cancel = this.invokeRequest("cancelretry?stage=0", seconds);
        Response response = JAXRSClientIT.getResponse(suspend);
        JAXRSClientIT.assertStatus(response, Response.Status.SERVICE_UNAVAILABLE);
        JAXRSClientIT.assertString(cancel, "A method return true");
        String retry = response.getHeaderString("Retry-After");
        JAXRSClientIT.assertEquals(seconds, retry, "Unexpected", "Retry-After", "header value received", retry, "expected", seconds);
        JAXRSClientIT.logMsg("Found expected", "Retry-After", "=", retry);
    }

    @Test
    public void cancelIntOnResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> cancel = this.invokeRequest("cancelretry?stage=1", "20");
        JAXRSClientIT.assertString(cancel, "A method returned false");
    }

    @Test
    public void cancelIntOnCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> cancel = this.invokeRequest("cancelretry?stage=1", "20");
        JAXRSClientIT.assertString(cancel, "A method return true");
    }

    @Test
    public void resumeCanceledIntTest() throws Exception {
        this.cancelIntTest();
        Future<Response> resume = this.invokeRequest("resume?stage=1", "");
        JAXRSClientIT.assertString(resume, "A method returned false");
    }

    @Test
    public void cancelDateTest() throws Exception {
        long milis = System.currentTimeMillis() / 1000L * 1000L + 20000L;
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> cancel = this.invokeRequest("canceldate?stage=0", milis);
        Response response = JAXRSClientIT.getResponse(suspend);
        JAXRSClientIT.assertStatus(response, Response.Status.SERVICE_UNAVAILABLE);
        JAXRSClientIT.assertString(cancel, "A method return true");
        String header = response.getHeaderString("Retry-After");
        TimeZone timezone = JaxrsUtil.findTimeZoneInDate(header);
        Date retry = null;
        try {
            retry = JaxrsUtil.createDateFormat(timezone).parse(header);
        }
        catch (ParseException e) {
            throw new Exception(e);
        }
        JAXRSClientIT.assertEquals(new Date(milis), retry, "Unexpected", "Retry-After", "header value received", retry.getTime(), "expected", milis);
        JAXRSClientIT.logMsg("Found expected", "Retry-After", "=", header);
    }

    @Test
    public void cancelDateOnResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> cancel = this.invokeRequest("canceldate?stage=1", System.currentTimeMillis());
        JAXRSClientIT.assertString(cancel, "A method returned false");
    }

    @Test
    public void cancelDateOnCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> cancel = this.invokeRequest("canceldate?stage=1", System.currentTimeMillis());
        JAXRSClientIT.assertString(cancel, "A method return true");
    }

    @Test
    public void resumeCanceledDateTest() throws Exception {
        this.cancelDateTest();
        Future<Response> resumeResumed = this.invokeRequest("resume?stage=1", "");
        JAXRSClientIT.assertString(resumeResumed, "A method returned false");
    }

    @Test
    public void isCanceledWhenCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> is = this.invokeRequest("iscanceled?stage=1");
        JAXRSClientIT.assertString(is, "A method return true");
    }

    @Test
    public void isCanceledWhenSuspendedTest() throws Exception {
        this.invokeClear();
        this.invokeRequest("suspend");
        Future<Response> is = this.invokeRequest("iscanceled?stage=0");
        JAXRSClientIT.assertString(is, "A method returned false");
    }

    @Test
    public void isCanceledWhenResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> is = this.invokeRequest("iscanceled?stage=1");
        JAXRSClientIT.assertString(is, "A method returned false");
    }

    @Test
    public void isDoneWhenResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> is = this.invokeRequest("isdone?stage=1");
        JAXRSClientIT.assertString(is, "A method return true");
    }

    @Test
    public void isDoneWhenSuspendedTest() throws Exception {
        this.invokeClear();
        this.invokeRequest("suspend");
        Future<Response> is = this.invokeRequest("isdone?stage=0");
        JAXRSClientIT.assertString(is, "A method returned false");
    }

    @Test
    public void isDoneWhenCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> is = this.invokeRequest("isdone?stage=1");
        JAXRSClientIT.assertString(is, "A method return true");
    }

    @Test
    public void isDoneWhenTimedOutTest() throws Exception {
        this.setTimeoutTest();
        Future<Response> is = this.invokeRequest("isdone?stage=1");
        JAXRSClientIT.assertString(is, "A method return true");
    }

    @Test
    public void isSuspendedWhenSuspendedTest() throws Exception {
        this.invokeClear();
        this.invokeRequest("suspend");
        Future<Response> is = this.invokeRequest("issuspended?stage=0");
        JAXRSClientIT.assertString(is, "A method return true");
    }

    @Test
    public void isSuspendedWhenCanceledTest() throws Exception {
        this.cancelVoidTest();
        Future<Response> is = this.invokeRequest("issuspended?stage=1");
        JAXRSClientIT.assertString(is, "A method returned false");
    }

    @Test
    public void isSuspendedWhenResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> is = this.invokeRequest("issuspended?stage=1");
        JAXRSClientIT.assertString(is, "A method returned false");
    }

    @Test
    public void suspendResumeTest() throws Exception {
        this.invokeClear();
        String expectedResponse = "Expected response";
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> resume = this.invokeRequest("resume?stage=0", expectedResponse);
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertString(suspend, expectedResponse);
    }

    @Test
    public void resumeAnyJavaObjectInputStreamTest() throws Exception {
        this.invokeClear();
        String expectedResponse = "Expected response";
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> resume = this.invokeRequest("resume?stage=0", new ByteArrayInputStream(expectedResponse.getBytes()));
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertString(suspend, expectedResponse);
    }

    @Test
    public void resumeResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> resumeResumed = this.invokeRequest("resume?stage=1", "");
        JAXRSClientIT.assertString(resumeResumed, "A method returned false");
    }

    @Test
    public void resumeWithCheckedExceptionTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> resume = this.invokeRequest("resumechecked?stage=0");
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertException(suspend, IOException.class);
    }

    @Test
    public void resumeWithRuntimeExceptionTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> resume = this.invokeRequest("resumeruntime?stage=0");
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertException(suspend, RuntimeException.class);
    }

    @Test
    public void resumeWithExceptionReturnsFalseWhenResumedTest() throws Exception {
        this.suspendResumeTest();
        Future<Response> resume = this.invokeRequest("resumechecked?stage=1");
        JAXRSClientIT.assertString(resume, "A method returned false");
    }

    @Test
    public void setTimeoutTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> setTimeout = this.invokeRequest("settimeout?stage=0", 200);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        Response fromMapper = JAXRSClientIT.getResponse(suspend);
        JAXRSClientIT.assertStatus(fromMapper, Response.Status.REQUEST_TIMEOUT);
        String entity = (String)fromMapper.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, 503, new Object[0]);
        JAXRSClientIT.logMsg("Found expected status 503");
    }

    @Test
    public void updateTimeoutTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> setTimeout = this.invokeRequest("settimeout?stage=0", 600000);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        Assertions.assertFalse((boolean)suspend.isDone(), (String)"Suspended AsyncResponse already received");
        setTimeout = this.invokeRequest("settimeout?stage=1", 200);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        Response fromMapper = JAXRSClientIT.getResponse(suspend);
        JAXRSClientIT.assertStatus(fromMapper, Response.Status.REQUEST_TIMEOUT);
        String entity = (String)fromMapper.readEntity(String.class);
        JAXRSClientIT.assertContains(entity, 503, new Object[0]);
        JAXRSClientIT.logMsg("Found expected status 503");
    }

    @Test
    public void handleTimeOutWaitsForeverTest() throws Exception {
        String responseMsg = "handleTimeOutWaitsForeverTest";
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> setTimeout = this.invokeRequest("timeouthandler?stage=0", 1);
        Future<Response> resume = this.invokeRequest("resume?stage=1", responseMsg);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        JAXRSClientIT.assertString(resume, "A method return true");
        JAXRSClientIT.assertString(suspend, responseMsg);
    }

    @Test
    public void handleTimeoutCancelsTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> setTimeout = this.invokeRequest("timeouthandler?stage=0", 2);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(suspend), Response.Status.SERVICE_UNAVAILABLE);
        Future<Response> resume = this.invokeRequest("issuspended?stage=1");
        JAXRSClientIT.assertString(resume, "A method returned false");
    }

    @Test
    public void handleTimeoutResumesTest() throws Exception {
        this.invokeClear();
        Future<Response> suspend = this.invokeRequest("suspend");
        Future<Response> setTimeout = this.invokeRequest("timeouthandler?stage=0", 3);
        JAXRSClientIT.assertStatus(JAXRSClientIT.getResponse(setTimeout), Response.Status.NO_CONTENT);
        JAXRSClientIT.assertString(suspend, "Response resumed");
        Future<Response> resume = this.invokeRequest("issuspended?stage=1");
        JAXRSClientIT.assertString(resume, "A method returned false");
    }

    private void invokeClear() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "clear"));
        this.setProperty(JAXRSCommonClient.Property.STATUS_CODE, JAXRSClientIT.getStatusCode(Response.Status.NO_CONTENT));
        this.invoke();
    }

    private Future<Response> invokeRequest(String resource) {
        AsyncInvoker async = this.createAsyncInvoker(resource);
        Future future = async.get();
        return future;
    }

    private <T> Future<Response> invokeRequest(String resource, T entity) {
        AsyncInvoker async = this.createAsyncInvoker(resource);
        Future future = async.post(Entity.entity(entity, (MediaType)MediaType.TEXT_PLAIN_TYPE));
        return future;
    }

    private WebTarget createWebTarget(String resource) {
        Client client = ClientBuilder.newClient();
        client.register((Object)new JdkLoggingFilter(true));
        WebTarget target = client.target(this.getAbsoluteUrl() + "/" + resource);
        return target;
    }

    private AsyncInvoker createAsyncInvoker(String resource) {
        WebTarget target = this.createWebTarget(resource);
        AsyncInvoker async = target.request().async();
        return async;
    }

    private static Response getResponse(Future<Response> future) throws Exception {
        Response response = null;
        try {
            response = future.get();
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        return response;
    }

    private static void assertStatus(Response response, Response.Status status) throws Exception {
        JAXRSClientIT.assertEqualsInt(response.getStatus(), status.getStatusCode(), "Unexpected status code received", response.getStatus(), "expected was", status);
        JAXRSClientIT.logMsg("Found expected status", status);
    }

    private static void assertString(Future<Response> future, String check) throws Exception {
        Response response = JAXRSClientIT.getResponse(future);
        JAXRSClientIT.assertStatus(response, Response.Status.OK);
        String content = (String)response.readEntity(String.class);
        JAXRSClientIT.assertEquals(check, content, "Unexpected response content", content);
        JAXRSClientIT.logMsg("Found expected string", check);
    }

    private static void assertException(Future<Response> future, Class<? extends Throwable> e) throws Exception {
        String clazz = e.getName();
        Response response = JAXRSClientIT.getResponse(future);
        JAXRSClientIT.assertStatus(response, Response.Status.NOT_ACCEPTABLE);
        JAXRSClientIT.assertContains((String)response.readEntity(String.class), clazz, new Object[]{clazz, "not thrown"});
        JAXRSClientIT.logMsg(clazz, "has been thrown as expected");
    }
}

