/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.query.parameter;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.query.parameter.Employee;
import jakarta.persistence.Query;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client2
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client2.class.getName());
    protected final Employee[] empRef = new Employee[5];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client2.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Employee"};
        return this.createDeploymentJar("jpa_core_relationship_annotations2.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupEmployee() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupEmployee");
        try {
            super.setup();
            this.createDeployment();
            this.createEmployeeData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void parameterPositionalTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > ?2 GROUP BY e.id HAVING e.id <=?1").setParameter(2, (Object)2).setParameter(1, (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Expected 1 result, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("parameterPositionalTest failed");
        }
    }

    @Test
    public void parameterUpdateTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("UPDATE Employee e SET e.firstName=?1, e.lastName=?1 WHERE e.id=1").setParameter(1, (Object)"foo");
            int result_size = q.executeUpdate();
            if (result_size == 1) {
                logger.log(System.Logger.Level.TRACE, "Updated 1 rows");
            }
            this.doFlush();
            this.clearCache();
            Employee emp = (Employee)this.getEntityManager().find(Employee.class, (Object)1);
            if (emp.getFirstName().equals("foo") && emp.getLastName().equals("foo")) {
                logger.log(System.Logger.Level.TRACE, "Received expected result:" + emp.toString());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected: firstName=foo, lastName=foo, actual: firstName=" + emp.getFirstName() + ", lastName=" + emp.getLastName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("parameterUpdateTest failed");
        }
    }

    @Test
    public void parameterCaseTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            List result = this.getEntityManager().createQuery("SELECT e.id FROM Employee e WHERE e.id > :Id GROUP BY e.id HAVING e.id <=:iD").setParameter("Id", (Object)2).setParameter("iD", (Object)4).getResultList();
            String[] expectedPKs = new String[]{"3", "4"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Expected 1 result, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("parameterCaseTest failed");
        }
    }

    @Test
    public void parameterNamedParameterTwiceTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Query q = this.getEntityManager().createQuery("SELECT e FROM Employee e WHERE e.id >=:ID AND e.id <=:ID");
            List result = q.setParameter("ID", (Object)2).getResultList();
            String[] expectedPKs = new String[]{"2"};
            if (!this.checkEntityPK(result, expectedPKs)) {
                logger.log(System.Logger.Level.ERROR, "Expected 1 result, got: " + result.size());
            } else {
                logger.log(System.Logger.Level.TRACE, "Expected results received");
                pass = true;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception:", (Throwable)e);
        }
        if (!pass) {
            throw new Exception("parameterNamedParameterTwiceTest failed");
        }
    }

    public void createEmployeeData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "createDepartmentEmployeeData");
        this.getEntityTransaction().begin();
        try {
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            logger.log(System.Logger.Level.TRACE, "Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                logger.log(System.Logger.Level.TRACE, "persisted employee " + emp.getId());
            }
            this.doFlush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("createDepartmentEmployeeData failed:", e);
        }
    }

    @AfterEach
    public void cleanupEmployee() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

