/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.entityManagerFactory;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member;
import ee.jakarta.tck.persistence.core.entityManagerFactory.Member_;
import jakarta.persistence.LockModeType;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client3
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client3.class.getName());
    Properties props = null;

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client3.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Member_", pkgName + "Member", pkgName + "Order_", pkgName + "Order"};
        return this.createDeploymentJar("jpa_core_entityManagerFactory3.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupMember() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createMemberTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupNoData() throws Exception {
        try {
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void addNamedQueryLockModeTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        boolean pass5 = false;
        try {
            TypedQuery namedTypeQuery;
            Object result;
            LockModeType lmt;
            boolean ok1;
            Query namedQuery;
            CriteriaBuilder cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            logger.log(System.Logger.Level.TRACE, "Defining queries");
            Query query = this.getEntityManager().createQuery("select m from Member m where m.memberId=1");
            query.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("query", query);
            CriteriaQuery cquery = cbuilder.createQuery(Member.class);
            Root member = cquery.from(Member.class);
            cquery.select((Selection)member);
            cquery.where((Expression)cbuilder.equal((Expression)member.get(Member_.memberId), (Object)1));
            TypedQuery typedQuery = this.getEntityManager().createQuery(cquery);
            typedQuery.setLockMode(LockModeType.NONE);
            this.getEntityManagerFactory().addNamedQuery("typed_query", (Query)typedQuery);
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing query with different lock mode than the original");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected lock mode before change:" + lmt.name());
                        ok1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getLockModeType returned null");
                }
                namedQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt = namedQuery.getLockMode();
                boolean ok2 = false;
                if (lmt.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    logger.log(System.Logger.Level.TRACE, "Received LockModeType:" + lmt.name());
                    ok2 = true;
                } else if (lmt.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    logger.log(System.Logger.Level.TRACE, "Received LockModeType:" + lmt + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                    ok2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt.name());
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok1 && ok2) {
                    pass1 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing query verify original lock mode is active");
                namedQuery = this.getEntityManager().createNamedQuery("query");
                ok1 = false;
                lmt = namedQuery.getLockMode();
                if (lmt != null) {
                    if (lmt.equals((Object)LockModeType.NONE)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected lock mode before change:" + lmt.name());
                        ok1 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getLockModeType returned null");
                }
                List lResult = namedQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result2 = (Member)lResult.get(0);
                    if (result2.getMemberId() == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + result2.getMemberId());
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result2.getMemberId());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok1) {
                    pass2 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing query definition can be replaced ");
                Query query2 = this.getEntityManager().createQuery("select m from Member m where m.memberId=2").setLockMode(LockModeType.PESSIMISTIC_READ);
                this.getEntityManagerFactory().addNamedQuery("query", query2);
                Query namedQuery2 = this.getEntityManager().createNamedQuery("query");
                boolean ok12 = false;
                LockModeType lmt2 = namedQuery2.getLockMode();
                if (lmt2 != null) {
                    if (lmt2.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                        logger.log(System.Logger.Level.TRACE, "Received LockModeType:" + lmt2.name());
                        ok12 = true;
                    } else if (lmt2.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                        logger.log(System.Logger.Level.TRACE, "Received LockModeType:" + lmt2 + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                        ok12 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt2.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getLockModeType returned null");
                }
                List lResult = namedQuery2.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 2) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:2, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:2, actual:" + lResult.size());
                    for (Member m : lResult) {
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok12) {
                    pass3 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing TypedQuery with lock mode different than the original");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok13 = false;
                LockModeType lmt3 = namedTypeQuery.getLockMode();
                if (lmt3 != null) {
                    if (lmt3.equals((Object)LockModeType.NONE)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected lock mode before change:" + lmt3.name());
                        ok13 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt3.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getLockModeType returned null");
                }
                namedTypeQuery.setLockMode(LockModeType.PESSIMISTIC_READ);
                lmt3 = namedTypeQuery.getLockMode();
                boolean ok2 = false;
                if (lmt3.equals((Object)LockModeType.PESSIMISTIC_READ)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected lock mode after change:" + lmt3.name());
                    ok2 = true;
                } else if (lmt3.equals((Object)LockModeType.PESSIMISTIC_WRITE)) {
                    logger.log(System.Logger.Level.TRACE, "Received LockModeType:" + lmt3 + " inplace of " + LockModeType.PESSIMISTIC_READ.name());
                    ok2 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected lock mode after change:" + LockModeType.PESSIMISTIC_READ.name() + ", actual:" + lmt3.name());
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    result = (Member)lResult.get(0);
                    if (((Member)result).getMemberId() == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + ((Member)result).getMemberId());
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + ((Member)result).getMemberId());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok13 && ok2) {
                    pass4 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            try {
                this.getEntityTransaction().begin();
                logger.log(System.Logger.Level.INFO, "*********************************");
                logger.log(System.Logger.Level.INFO, "Testing TypedQuery verify original lock mode is active");
                namedTypeQuery = this.getEntityManager().createNamedQuery("typed_query", Member.class);
                boolean ok14 = false;
                LockModeType lmt4 = namedTypeQuery.getLockMode();
                if (lmt4 != null) {
                    if (lmt4.equals((Object)LockModeType.NONE)) {
                        logger.log(System.Logger.Level.TRACE, "Received expected lock mode before change:" + lmt4.name());
                        ok14 = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected lock mode before change:" + LockModeType.NONE.name() + ", actual:" + lmt4.name());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "getLockModeType returned null");
                }
                List lResult = namedTypeQuery.getResultList();
                boolean foundOne = false;
                if (lResult.size() == 1) {
                    Member result3 = (Member)lResult.get(0);
                    if (result3.getMemberId() == 1) {
                        logger.log(System.Logger.Level.TRACE, "Received expected id:" + result3.getMemberId());
                        foundOne = true;
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Expected id:1, actual:" + result3.getMemberId());
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Did not get correct number of results, expected:1, actual:" + lResult.size());
                    for (Member m : lResult) {
                        logger.log(System.Logger.Level.ERROR, "Ids received:" + m.getMemberId());
                    }
                }
                if (foundOne && ok14) {
                    pass5 = true;
                }
                this.getEntityTransaction().commit();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            }
            finally {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5)) {
            throw new Exception("addNamedQueryLockModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMemberTestData() {
        try {
            this.getEntityTransaction().begin();
            Member[] members = new Member[]{new Member(1, "1"), new Member(2, "2"), new Member(3, "3"), new Member(4, "4"), new Member(5, "5")};
            for (Member m : members) {
                logger.log(System.Logger.Level.TRACE, "Persisting member:" + m.toString());
                this.getEntityManager().persist((Object)m);
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            this.getEntityManager().createNativeQuery("DELETE FROM PURCHASE_ORDER").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM MEMBER").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

