/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.derivedid.ex1b;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.derivedid.ex1b.DID1bDependent;
import ee.jakarta.tck.persistence.core.derivedid.ex1b.DID1bDependentId;
import ee.jakarta.tck.persistence.core.derivedid.ex1b.DID1bEmployee;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "DID1bDependent", pkgName + "DID1bDependentId", pkgName + "DID1bEmployee"};
        return this.createDeploymentJar("jpa_core_derivedid_ex1b.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setup() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setup");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @Test
    public void DIDTest() throws Exception {
        boolean pass = false;
        this.getEntityTransaction().begin();
        try {
            DID1bEmployee employee1 = new DID1bEmployee(1L, "Duke");
            DID1bEmployee employee2 = new DID1bEmployee(2L, "foo");
            DID1bDependentId depId1 = new DID1bDependentId("Obama", 1L);
            DID1bDependentId depId2 = new DID1bDependentId("Michelle", 1L);
            DID1bDependentId depId3 = new DID1bDependentId("John", 2L);
            DID1bDependent dep1 = new DID1bDependent(depId1, employee1);
            DID1bDependent dep2 = new DID1bDependent(depId2, employee1);
            DID1bDependent dep3 = new DID1bDependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            logger.log(System.Logger.Level.TRACE, "persisted Employees and Dependents");
            this.getEntityManager().flush();
            DID1bDependent newDependent = (DID1bDependent)this.getEntityManager().find(DID1bDependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID1bDependent d where d.id.name='Obama' and d.emp.name='Duke'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID1bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass = true;
                    logger.log(System.Logger.Level.TRACE, "Received Expected Dependent");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Searched Dependent not found");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (!pass) {
            throw new Exception("DIDTest failed");
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "cleanup");
            this.removeTestData();
            logger.log(System.Logger.Level.TRACE, "cleanup complete, calling super.cleanup");
            super.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID1BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

