/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Util;
import ee.jakarta.tck.persistence.core.criteriaapi.CriteriaQuery.A;
import jakarta.persistence.Parameter;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client5
extends Util {
    private static final System.Logger logger = System.getLogger(Client5.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client5.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "A"};
        classes = Client5.concat((String[])this.getSchema30classes(), (String[])classes);
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaQuery5.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupAData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupData");
        try {
            super.setup();
            this.createDeployment();
            this.removeATestData();
            this.createATestData();
        }
        catch (Exception e) {
            throw new Exception("Setup failed:", e);
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void DoubleOperandResultTypeTests() throws Exception {
        Object p;
        double whereValue;
        ParameterExpression param;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1234.5;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1.0));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.gt((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1234.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.lt((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1235.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / Double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Number)1));
            param = cbuilder.parameter(Double.class);
            cquery.where((Expression)cbuilder.notEqual((Expression)a.get(A_.getSingularAttribute("basicBigDouble", Double.class)), (Expression)param));
            whereValue = 1235.0;
            p = this.getEntityManager().createQuery(cquery).setParameter((Parameter)param, (Object)whereValue).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected Double type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1.0));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass7 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / double operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicDouble", Double.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Double) {
                logger.log(System.Logger.Level.TRACE, "Received expected double type");
                pass8 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type double:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("DoubleOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void FloatOperandResultTypeTests() throws Exception {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass8 = false;
        boolean pass7 = false;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)Float.valueOf(1.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / Float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)Float.valueOf(1.0f)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected float type");
                pass7 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / float operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicFloat", Float.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Float) {
                logger.log(System.Logger.Level.TRACE, "Received expected Float type");
                pass8 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Float:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6 && pass7 && pass8)) {
            throw new Exception("FloatOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void BigDecimalOperandResultTypeTests() throws Exception {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)new BigDecimal(1)));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing / BigDecimal operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.quot((Expression)a.get(A_.getSingularAttribute("basicBigDecimal", BigDecimal.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigDecimal) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigDecimal type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigDecimal:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("BigDecimalOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void BigIntegerOperandResultTypeTests() throws Exception {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)new BigInteger("1")));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * BigInteger operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigInteger", BigInteger.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof BigInteger) {
                logger.log(System.Logger.Level.TRACE, "Received expected BigInteger type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type BigInteger:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3)) {
            throw new Exception("BigIntegerOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void LongOperandResultTypeTests() throws Exception {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1L));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected Long type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1L));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * long operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicLong", Long.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Long) {
                logger.log(System.Logger.Level.TRACE, "Received expected long type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type long:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new Exception("LongOperandResultTypeTests failed");
        }
    }

    @SetupMethod(name="setupAData")
    @Test
    public void ShortOperandResultTypeTests() throws Exception {
        Object p;
        EntityType A_;
        Root a;
        CriteriaQuery cquery;
        CriteriaBuilder cbuilder;
        boolean pass6 = false;
        boolean pass5 = false;
        boolean pass4 = false;
        boolean pass3 = false;
        boolean pass2 = false;
        boolean pass1 = false;
        try {
            logger.log(System.Logger.Level.INFO, "Testing + Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass1 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * Short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicBigShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass3 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing + short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.sum((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass4 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing - short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.diff((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass5 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        try {
            logger.log(System.Logger.Level.INFO, "Testing * short operand:");
            this.getEntityTransaction().begin();
            cbuilder = this.getEntityManagerFactory().getCriteriaBuilder();
            cquery = cbuilder.createQuery();
            a = cquery.from(A.class);
            A_ = a.getModel();
            cquery.select((Selection)cbuilder.prod((Expression)a.get(A_.getSingularAttribute("basicShort", Short.class)), (Number)1));
            cquery.where((Expression)cbuilder.equal((Expression)a.get(A_.getSingularAttribute("id", String.class)), (Object)"9"));
            p = this.getEntityManager().createQuery(cquery).getSingleResult();
            if (p instanceof Integer) {
                logger.log(System.Logger.Level.TRACE, "Received expected Integer type");
                pass6 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Result was not of type Integer:" + p.getClass().getName());
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: ", (Throwable)e);
        }
        if (!(pass1 && pass2 && pass3 && pass4 && pass5 && pass6)) {
            throw new Exception("ShortOperandResultTypeTests failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createATestData() {
        try {
            this.getEntityTransaction().begin();
            Integer integer = 1234;
            int basicShort = 12;
            Short basicBigShort = 12;
            float basicFloat = 12.3f;
            Float basicBigFloat = Float.valueOf(12.3f);
            long basicLong = 1234L;
            Long basicBigLong = 1234L;
            double basicDouble = 1234.5;
            Double basicBigDouble = 1234.5;
            char[] charArray = new char[]{'a', 'b', 'c'};
            Character[] bigCharacterArray = new Character[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')};
            byte[] byteArray = "abc".getBytes();
            Byte[] bigByteArray = new Byte[]{(byte)111, (byte)101, (byte)100};
            BigInteger bigInteger = new BigInteger("12345");
            BigDecimal bigDecimal = new BigDecimal(bigInteger);
            Date date = new Date();
            long timeInSeconds = date.getTime();
            Time time = new Time(timeInSeconds);
            Timestamp timeStamp = new Timestamp(timeInSeconds);
            Calendar calendar = Calendar.getInstance();
            A aRef = new A("9", null, 9, integer, 12, basicBigShort, 12.3f, basicBigFloat, 1234L, basicBigLong, 1234.5, basicBigDouble, 'a', charArray, bigCharacterArray, byteArray, bigByteArray, bigInteger, bigDecimal, date, time, timeStamp, calendar);
            this.getEntityManager().persist((Object)aRef);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception in createTestData:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception during Rollback:", (Throwable)re);
            }
        }
    }

    private void removeATestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM A_BASIC").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

