/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.criteriaapi.CriteriaBuilder;

import com.sun.ts.lib.harness.SetupMethod;
import ee.jakarta.tck.persistence.common.schema30.Customer;
import ee.jakarta.tck.persistence.common.schema30.Product;
import ee.jakarta.tck.persistence.common.schema30.UtilCustAliasProductData;
import jakarta.persistence.Tuple;
import jakarta.persistence.TupleElement;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.List;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.Test;

public class Client7
extends UtilCustAliasProductData {
    private static final System.Logger logger = System.getLogger(Client7.class.getName());

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client7.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = this.getSchema30classes();
        return this.createDeploymentJar("jpa_core_criteriaapi_CriteriaBuilder7.jar", pkgNameWithoutSuffix, classes);
    }

    @SetupMethod(name="setupCustAliasProductData")
    @Test
    public void tupleGetTupleElementIllegalArgumentExceptionTest() throws Exception {
        boolean pass2;
        boolean pass1;
        block11: {
            pass1 = false;
            pass2 = false;
            CriteriaBuilder cbuilder = this.getEntityManager().getCriteriaBuilder();
            this.getEntityTransaction().begin();
            CriteriaQuery cquery = cbuilder.createTupleQuery();
            if (cquery != null) {
                logger.log(System.Logger.Level.TRACE, "Obtained Non-null Criteria Query");
                Root customer = cquery.from(Customer.class);
                logger.log(System.Logger.Level.TRACE, "Execute first Tuple Query");
                cquery.multiselect(new Selection[]{customer.get("id").alias("ID"), customer.get("name").alias("NAME")});
                cquery.where((Expression)cbuilder.equal((Expression)customer.get("id"), (Object)"3"));
                TypedQuery tq = this.getEntityManager().createQuery(cquery);
                List result = tq.getResultList();
                logger.log(System.Logger.Level.TRACE, "Number of Tuples from first query:" + result.size());
                Tuple t1 = (Tuple)result.get(0);
                logger.log(System.Logger.Level.TRACE, "Tuples Received:" + t1.get(0) + ", " + t1.get(1));
                CriteriaQuery cquery1 = cbuilder.createTupleQuery();
                Root product = cquery1.from(Product.class);
                logger.log(System.Logger.Level.TRACE, "Execute second Tuple Query");
                cquery1.multiselect(new Selection[]{product.get("id").alias("ID"), product.get("quantity").alias("QUANTITY")});
                cquery1.where((Expression)cbuilder.equal((Expression)product.get("id"), (Object)"1"));
                TypedQuery tq2 = this.getEntityManager().createQuery(cquery1);
                List result2 = tq2.getResultList();
                Tuple t2 = null;
                logger.log(System.Logger.Level.TRACE, "Number of Tuples received from second query:" + result2.size());
                try {
                    t2 = (Tuple)result2.get(0);
                    pass1 = true;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                }
                if (t2 != null) {
                    logger.log(System.Logger.Level.TRACE, "Tuple Received:" + t2.get(0) + ", " + t2.get(1));
                    List lte2 = t2.getElements();
                    TupleElement te2 = (TupleElement)lte2.get(1);
                    logger.log(System.Logger.Level.TRACE, "TupleElement from second query that will be looked up in the Tuple result returned from first query:" + te2.getAlias());
                    try {
                        t1.get(te2);
                        logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException when calling Tuple.get with a TupleElement that doesn't exist");
                    }
                    catch (IllegalArgumentException iae) {
                        logger.log(System.Logger.Level.TRACE, "Got expected IllegalArgumentException");
                        if (!this.getEntityTransaction().getRollbackOnly()) {
                            pass2 = true;
                            break block11;
                        }
                        logger.log(System.Logger.Level.ERROR, "Transaction was marked for rollback and should not have been");
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)e);
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "result2.get(0) returned null");
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "Failed to get Non-null Criteria Query");
            }
        }
        this.getEntityTransaction().commit();
        if (!pass1 || !pass2) {
            throw new Exception("tupleGetTupleElementIllegalArgumentExceptionTest failed");
        }
    }
}

