/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.common;

import ee.jakarta.tck.persistence.common.PMClientBase;
import java.sql.SQLException;

public abstract class EntityCallbackClientBase
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(EntityCallbackClientBase.class.getName());

    protected EntityCallbackClientBase() {
    }

    protected Object txShouldRollback(Object b, String testName) throws Exception {
        Object p2;
        Object reason;
        block8: {
            reason = "";
            try {
                logger.log(System.Logger.Level.TRACE, "Persisting: " + b.getClass().getName());
                this.getEntityManager().persist(b);
                logger.log(System.Logger.Level.TRACE, "Committing: " + b.getClass().getName() + " changes");
                this.getEntityTransaction().commit();
                reason = "Expecting ArithmeticException from callback method, but got none.";
                throw new Exception((String)reason);
            }
            catch (ArithmeticException e) {
                reason = "EntityCallbackClientBase: Got expected exception: " + e.toString();
                logger.log(System.Logger.Level.TRACE, (String)reason);
                if (!this.getEntityTransaction().isActive()) {
                    reason = "No Transaction was active, even though one was previously started";
                    throw new Exception((String)reason, e);
                }
            }
            catch (Exception e) {
                reason = "EntityCallbackClientBase: Expecting ArithmeticException, but got unexpected exception: [" + e.toString() + "]";
                throw new Exception((String)reason, e);
            }
            logger.log(System.Logger.Level.TRACE, "Clearing cache");
            this.clearCache();
            logger.log(System.Logger.Level.TRACE, "Executing find");
            p2 = null;
            try {
                p2 = this.getEntityManager().find(b.getClass(), (Object)testName);
            }
            catch (RuntimeException e) {
                Throwable cause;
                for (cause = e; cause != null && !SQLException.class.isInstance(cause); cause = cause.getCause()) {
                }
                if (cause != null) break block8;
                throw new Exception(e);
            }
        }
        if (p2 != null) {
            reason = "EntityCallbackClientBase: Unexpected result: found entity with id " + testName;
            throw new Exception((String)reason);
        }
        reason = "EntityCallbackClientBase: Got expected result: entity with id " + testName + " was not found.";
        logger.log(System.Logger.Level.TRACE, (String)reason);
        return b;
    }
}

