/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.EntityGraph;

import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.EntityGraph.Department;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee2;
import ee.jakarta.tck.persistence.core.EntityGraph.Employee3;
import jakarta.persistence.AttributeNode;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.ManagedType;
import jakarta.persistence.metamodel.Metamodel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class Client
extends PMClientBase {
    private static final System.Logger logger = System.getLogger(Client.class.getName());
    Employee3[] empRef = new Employee3[5];
    Department[] deptRef = new Department[2];

    public JavaArchive createDeployment() throws Exception {
        String pkgNameWithoutSuffix = Client.class.getPackageName();
        String pkgName = pkgNameWithoutSuffix + ".";
        String[] classes = new String[]{pkgName + "Department", pkgName + "Employee", pkgName + "Employee2", pkgName + "Employee3"};
        return this.createDeploymentJar("jpa_core_EntityGraph.jar", pkgNameWithoutSuffix, classes);
    }

    @BeforeEach
    public void setupEmployeeData() throws Exception {
        logger.log(System.Logger.Level.TRACE, "setupOrderData");
        try {
            super.setup();
            this.createDeployment();
            this.removeTestData();
            this.createEmployeeData();
            this.displayMap(new Properties());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception: ", (Throwable)e);
            throw new Exception("Setup failed:", e);
        }
    }

    @AfterEach
    public void cleanupEmployeeData() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "Cleanup data");
            this.removeTestData();
            this.cleanup();
        }
        finally {
            this.removeTestJarFromCP();
        }
    }

    @Test
    public void addAttributeNodesStringArrayTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("firstName");
        expected.add("lastName");
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new String[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            logger.log(System.Logger.Level.TRACE, "Received expected results");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected results");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, "expected:" + s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual results");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, "actual:" + s);
            }
        }
        if (!pass) {
            throw new Exception("addAttributeNodesStringArrayTest failed");
        }
    }

    @Test
    public void addAttributeNodesStringArrayIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee2.class);
        try {
            empEG.addAttributeNodes(new String[]{"doesnotexist"});
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Exception("addAttributeNodesStringArrayIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void addAttributeNodesAttributeArrayTest() throws Exception {
        boolean pass = false;
        Metamodel mm = this.getEntityManager().getMetamodel();
        ManagedType mTypeOrder = mm.managedType(Employee.class);
        ArrayList<String> sExpected = new ArrayList<String>();
        sExpected.add("firstName");
        sExpected.add("lastName");
        ArrayList<Attribute> expected = new ArrayList<Attribute>();
        for (String s : sExpected) {
            expected.add(mTypeOrder.getDeclaredAttribute(s));
        }
        EntityGraph empEG = this.getEntityManager().createEntityGraph(Employee.class);
        empEG.addAttributeNodes(expected.toArray(new Attribute[0]));
        List result = empEG.getAttributeNodes();
        ArrayList<String> actual = new ArrayList<String>();
        for (AttributeNode an : result) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(sExpected) && sExpected.containsAll(actual) && actual.size() == sExpected.size()) {
            logger.log(System.Logger.Level.TRACE, "Received expected results");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected results");
            for (String s : sExpected) {
                logger.log(System.Logger.Level.ERROR, "expected:" + s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual results");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, "actual:" + s);
            }
        }
        if (!pass) {
            throw new Exception("addAttributeNodesAttributeArrayTest failed");
        }
    }

    @Test
    public void createEntityGraphStringTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        logger.log(System.Logger.Level.INFO, "Test that the named entity graph is returned");
        EntityGraph eg = this.getEntityManager().createEntityGraph("first_last_graph");
        if (eg != null) {
            logger.log(System.Logger.Level.TRACE, "Received non-null EntityGraph:" + eg.getName());
            pass1 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Null was returned for EntityGraph that does exist");
        }
        logger.log(System.Logger.Level.INFO, "Test that null is returned");
        try {
            eg = this.getEntityManager().createEntityGraph("doesnotexist");
            if (eg == null) {
                logger.log(System.Logger.Level.TRACE, "Received expected null EntityGraph");
                pass2 = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Non-null EntityGraph was returned instead of a null:" + eg.getName());
            }
        }
        catch (Exception ex) {
            logger.log(System.Logger.Level.ERROR, "Received unexpected exception", (Throwable)ex);
        }
        if (!pass1 || !pass2) {
            throw new Exception("createEntityGraphStringTest failed");
        }
    }

    @Test
    public void getEntityGraphStringTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().getEntityGraph("first_last_graph");
        if (eg != null) {
            logger.log(System.Logger.Level.TRACE, "Received non-null EntityGraph:" + eg.getName());
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new Exception("getEntityGraphStringTest failed");
        }
    }

    @Test
    public void entityGraphGetNameTest() throws Exception {
        boolean pass = false;
        String expected = "first_last_graph";
        EntityGraph eg = this.getEntityManager().getEntityGraph(expected);
        if (eg != null) {
            if (eg.getName().equals(expected)) {
                logger.log(System.Logger.Level.TRACE, "Received expected EntityGraph name:" + eg.getName());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected name: " + expected + ", actual:" + eg.getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Null was returned for EntityGraph that does exist");
        }
        if (!pass) {
            throw new Exception("entityGraphGetNameTest failed");
        }
    }

    @Test
    public void entityGraphGetNameNoNameExistsTest() throws Exception {
        boolean pass = false;
        List egs = this.getEntityManager().getEntityGraphs(Employee2.class);
        if (egs.size() == 1) {
            EntityGraph e = (EntityGraph)egs.get(0);
            if (e.getName().equals("Employee2")) {
                logger.log(System.Logger.Level.TRACE, "Received expected name:" + e.getName());
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected name: Employee2, actual:" + e.getName());
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected 1 graph to be returned, instead got:" + egs.size());
        }
        if (!pass) {
            throw new Exception("entityGraphGetNameNoNameExistsTest failed");
        }
    }

    @Test
    public void getNameTest() throws Exception {
        boolean pass = false;
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee2.class);
        if (eg.getName() == null) {
            logger.log(System.Logger.Level.TRACE, "Received expected null");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected name: null, actual:" + eg.getName());
        }
        if (!pass) {
            throw new Exception("getNameTest failed");
        }
    }

    @Test
    public void getEntityGraphStringIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraph("doesnotexist");
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Exception("getEntityGraphStringIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void getEntityGraphsClassTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("first_last_graph");
        expected.add("last_salary_graph");
        expected.add("lastname_department_subgraphs");
        ArrayList<String> actual = new ArrayList<String>();
        List eg = this.getEntityManager().getEntityGraphs(Employee3.class);
        if (eg.size() > 0) {
            for (EntityGraph e : eg) {
                actual.add(e.getName());
            }
            if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
                logger.log(System.Logger.Level.TRACE, "Received expected results");
                pass = true;
            } else {
                logger.log(System.Logger.Level.ERROR, "Expected results");
                for (String s : expected) {
                    logger.log(System.Logger.Level.ERROR, "expected:" + s);
                }
                logger.log(System.Logger.Level.ERROR, "Actual results");
                for (String s : actual) {
                    logger.log(System.Logger.Level.ERROR, "actual:" + s);
                }
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "No named entity graphs were returned eventhough they exist in entity");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassTest failed");
        }
    }

    @Test
    public void addNamedEntityGraphStringEntityGraphTest() throws Exception {
        boolean pass1 = false;
        boolean pass2 = false;
        boolean pass3 = false;
        boolean pass4 = false;
        String sExpected = "new_named_entity_graph";
        logger.log(System.Logger.Level.INFO, "add entity graph to EMF");
        EntityGraph eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"id"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        EntityGraph eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected entity graph:" + eg2.getName());
                    pass1 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: named_entity_graph, actual:" + eg2.getName());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getEntityGraph() returned null");
        }
        logger.log(System.Logger.Level.INFO, "verify nodes");
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("id");
        ArrayList<String> actual = new ArrayList<String>();
        List listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            logger.log(System.Logger.Level.TRACE, "Received expected AttributeNode");
            pass2 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not received expected AttributeNodes");
            logger.log(System.Logger.Level.ERROR, "Expected results");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, "expected:" + s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual results");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, "actual:" + s);
            }
        }
        logger.log(System.Logger.Level.INFO, "override previous entity graph");
        eg = this.getEntityManager().createEntityGraph(Employee.class);
        eg.addAttributeNodes(new String[]{"lastName"});
        this.getEntityManager().getEntityManagerFactory().addNamedEntityGraph(sExpected, eg);
        eg2 = this.getEntityManager().getEntityGraph(sExpected);
        if (eg2 != null) {
            if (eg2.getName() != null) {
                if (eg2.getName().equals(sExpected)) {
                    logger.log(System.Logger.Level.TRACE, "Received expected entity graph:" + eg2.getName());
                    pass3 = true;
                } else {
                    logger.log(System.Logger.Level.ERROR, "Expected: named_entity_graph, actual:" + eg2.getName());
                }
            } else {
                logger.log(System.Logger.Level.ERROR, "getName() returned null for a named entity graph added via addNamedEntityGraph");
            }
        } else {
            logger.log(System.Logger.Level.ERROR, "getEntityGraph() returned null");
        }
        logger.log(System.Logger.Level.INFO, "verify nodes of overriden named entity graph");
        expected = new ArrayList();
        expected.add("lastName");
        actual = new ArrayList();
        listNodes = eg2.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (expected.containsAll(actual) && actual.containsAll(expected) && expected.size() == actual.size()) {
            logger.log(System.Logger.Level.TRACE, "Received expected AttributeNode");
            pass4 = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Did not received expected AttributeNodes");
            logger.log(System.Logger.Level.ERROR, "Expected results");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, "expected:" + s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual results");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, "actual:" + s);
            }
        }
        if (!(pass1 && pass2 && pass3 && pass4)) {
            throw new Exception("addNamedEntityGraphStringEntityGraphTest failed");
        }
    }

    @Test
    public void getEntityGraphsClassIllegalArgumentExceptionTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityManager().getEntityGraphs(Client.class);
            logger.log(System.Logger.Level.ERROR, "Did not throw IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            logger.log(System.Logger.Level.TRACE, "Received expected IllegalArgumentException");
        }
        if (!pass) {
            throw new Exception("getEntityGraphsClassIllegalArgumentExceptionTest failed");
        }
    }

    @Test
    public void annotationsTest() throws Exception {
        boolean pass = false;
        ArrayList<String> expected = new ArrayList<String>();
        expected.add("lastName");
        expected.add("salary");
        ArrayList<String> actual = new ArrayList<String>();
        EntityGraph eg = this.getEntityManager().getEntityGraph("last_salary_graph");
        List listNodes = eg.getAttributeNodes();
        for (AttributeNode an : listNodes) {
            actual.add(an.getAttributeName());
        }
        if (actual.containsAll(expected) && expected.containsAll(actual) && actual.size() == expected.size()) {
            logger.log(System.Logger.Level.TRACE, "Received expected results");
            pass = true;
        } else {
            logger.log(System.Logger.Level.ERROR, "Expected results");
            for (String s : expected) {
                logger.log(System.Logger.Level.ERROR, "expected:" + s);
            }
            logger.log(System.Logger.Level.ERROR, "Actual results");
            for (String s : actual) {
                logger.log(System.Logger.Level.ERROR, "actual:" + s);
            }
        }
        if (!pass) {
            throw new Exception("annotationsTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeData() {
        try {
            this.getEntityTransaction().begin();
            logger.log(System.Logger.Level.INFO, "Creating Employees");
            Date d1 = this.getUtilDate("2000-02-14");
            Date d2 = this.getUtilDate("2001-06-27");
            Date d3 = this.getUtilDate("2002-07-07");
            Date d4 = this.getUtilDate("2003-03-03");
            Date d5 = this.getUtilDate();
            this.deptRef[0] = new Department(1, "Marketing");
            this.deptRef[1] = new Department(2, "Administration");
            for (Department department : this.deptRef) {
                this.getEntityManager().persist((Object)department);
                logger.log(System.Logger.Level.TRACE, "persisted department:" + department);
            }
            this.empRef[0] = new Employee3(1, "Alan", "Frechette", d1, 35000.0f);
            this.empRef[0].setDepartment(this.deptRef[0]);
            this.empRef[1] = new Employee3(2, "Arthur", "Frechette", d2, 35000.0f);
            this.empRef[1].setDepartment(this.deptRef[0]);
            this.empRef[2] = new Employee3(3, "Shelly", "McGowan", d3, 50000.0f);
            this.empRef[2].setDepartment(this.deptRef[1]);
            this.empRef[3] = new Employee3(4, "Robert", "Bissett", d4, 55000.0f);
            this.empRef[3].setDepartment(this.deptRef[1]);
            this.empRef[4] = new Employee3(5, "Stephen", "DMilla", d5, 25000.0f);
            this.empRef[4].setDepartment(this.deptRef[1]);
            for (Serializable serializable : this.empRef) {
                if (serializable == null) continue;
                this.getEntityManager().persist((Object)serializable);
                logger.log(System.Logger.Level.TRACE, "persisted employee3:" + (Employee3)serializable);
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception fe) {
                logger.log(System.Logger.Level.ERROR, "Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
    }

    private void removeTestData() {
        logger.log(System.Logger.Level.TRACE, "removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

