/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BasicSessionControl;
import com.sun.javatest.exec.ChecklistBrowser;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.ET_FilterControl;
import com.sun.javatest.exec.ET_ViewControl;
import com.sun.javatest.exec.EnvironmentBrowser;
import com.sun.javatest.exec.ExcludeListBrowser;
import com.sun.javatest.exec.ExecModel;
import com.sun.javatest.exec.JavaTestMenuManager;
import com.sun.javatest.exec.LogViewer;
import com.sun.javatest.exec.PropertiesBrowser;
import com.sun.javatest.exec.QuestionLogBrowser;
import com.sun.javatest.exec.ServiceViewer;
import com.sun.javatest.exec.Session;
import com.sun.javatest.exec.SessionExt;
import com.sun.javatest.exec.TestSuiteErrorsDialog;
import com.sun.javatest.services.ServiceManager;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class ET_DefaultViewControl
implements ET_ViewControl {
    private static int debug = Debug.getInt(BasicSessionControl.class);
    SessionExt config = null;
    UIFactory uif = null;
    JComponent parent = null;
    TestSuite testSuite;
    List<Action> actions = null;
    ExecModel execModel = null;
    EnvironmentBrowser environmentBrowser = null;
    ExcludeListBrowser excludeListBrowser = null;
    QuestionLogBrowser questionLogBrowser = null;
    ChecklistBrowser checkListBrowser = null;
    ET_FilterControl filterControl = null;
    TestSuiteErrorsDialog testSuiteErrorsDialog = null;
    Action showEnvironmentAction;
    Action showExcludeListAction;
    Action showChecklistAction;
    Action showQuestionLogAction;
    private Action propertiesAction;
    private Action testSuiteErrorsAction;
    private Action logViewerAction;
    private ServiceViewer serviceViewer;
    private Action serviceViewerAction;

    public ET_DefaultViewControl(JComponent parent, TestSuite ts, ExecModel execModel, UIFactory uif, ET_FilterControl filterControl) {
        this.parent = parent;
        this.uif = uif;
        this.testSuite = ts;
        this.execModel = execModel;
        this.actions = this.createActions();
        this.filterControl = filterControl;
    }

    @Override
    public Session getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(Session cfg) {
        if (!(cfg instanceof SessionExt)) {
            throw new Error(this.uif.getI18NString("bcc.notSessionExtInstance.err", (Object)cfg.getClass()));
        }
        this.config = (SessionExt)cfg;
    }

    @Override
    public void updateGUI() {
        boolean isWD = this.config != null && this.config.getWorkDirectory() != null;
        this.propertiesAction.setEnabled(true);
        this.logViewerAction.setEnabled(isWD);
        if (this.serviceViewerAction != null) {
            this.serviceViewerAction.setEnabled(isWD);
        }
        if (this.showChecklistAction != null) {
            this.showChecklistAction.setEnabled(this.config.getInterviewParameters() != null && !this.config.getInterviewParameters().isChecklistEmpty());
        }
    }

    @Override
    public void save(Map<String, String> m) {
    }

    @Override
    public void restore(Map<String, String> m) {
    }

    @Override
    public JMenu getMenu() {
        JMenuItem[] items;
        Object filters;
        JMenu viewMenu = this.uif.createMenu("exec.view");
        List<Action> cfgActs = this.createConfigActions();
        Action[] viewConfigActions = new Action[cfgActs.size()];
        cfgActs.toArray(viewConfigActions);
        JMenu viewConfigMenu = this.uif.createMenu("exec.view.cfg", viewConfigActions);
        viewMenu.add(viewConfigMenu);
        if (this.filterControl != null && (filters = this.filterControl.getFilterMenu()) != null) {
            viewMenu.add((JMenuItem)filters);
        }
        viewMenu.addSeparator();
        for (Action action : this.createActions()) {
            viewMenu.add(action);
        }
        ContextManager cm = this.execModel.getContextManager();
        JavaTestMenuManager mm = null;
        if (cm != null && (mm = cm.getMenuManager()) != null && (items = mm.getMenuItems(5)) != null) {
            for (JMenuItem item : items) {
                viewConfigMenu.add(item);
            }
        }
        return viewMenu;
    }

    @Override
    public List<Action> getToolBarActionList() {
        return null;
    }

    protected List<Action> createActions() {
        if (this.actions != null) {
            return this.actions;
        }
        this.actions = new LinkedList<Action>();
        this.propertiesAction = this.createPropertyAction();
        this.actions.add(this.propertiesAction);
        this.logViewerAction = this.createLogViewerAction();
        this.actions.add(this.logViewerAction);
        if (this.testSuite != null && this.testSuite.needServices()) {
            this.serviceViewerAction = this.createServiceViewerAction();
            this.actions.add(this.serviceViewerAction);
        }
        this.testSuiteErrorsAction = this.createTestSuiteErrorsAction();
        this.actions.add(this.testSuiteErrorsAction);
        return this.actions;
    }

    @Override
    public void dispose() {
    }

    private Action createPropertyAction() {
        return new ToolAction(this.uif, "exec.view.props"){
            private PropertiesBrowser propertiesBrowser;

            @Override
            public void actionPerformed(ActionEvent e) {
                if (this.propertiesBrowser == null) {
                    this.propertiesBrowser = new PropertiesBrowser(ET_DefaultViewControl.this.parent, ET_DefaultViewControl.this.uif);
                }
                this.propertiesBrowser.showDialog(ET_DefaultViewControl.this.testSuite, ET_DefaultViewControl.this.config.getWorkDirectory(), ET_DefaultViewControl.this.config.getInterviewParameters());
            }
        };
    }

    private Action createTestSuiteErrorsAction() {
        return new ToolAction(this.uif, "exec.view.testSuiteErrors"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ET_DefaultViewControl.this.testSuiteErrorsDialog == null) {
                    ET_DefaultViewControl.this.testSuiteErrorsDialog = new TestSuiteErrorsDialog(ET_DefaultViewControl.this.parent, ET_DefaultViewControl.this.uif);
                }
                ET_DefaultViewControl.this.testSuiteErrorsDialog.show(ET_DefaultViewControl.this.testSuite);
            }
        };
    }

    private Action createLogViewerAction() {
        return new ToolAction(this.uif, "exec.view.logviewer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ET_DefaultViewControl.this.config != null && ET_DefaultViewControl.this.config.getWorkDirectory() != null) {
                    ET_DefaultViewControl.this.openLogViewer();
                } else {
                    ET_DefaultViewControl.this.testSuite.getNotificationLog(null).info(ET_DefaultViewControl.this.uif.getI18NString("exec.view.logviewer.noworkdir"));
                }
            }
        };
    }

    private void openLogViewer() {
        new LogViewer(this.config.getWorkDirectory(), this.uif, this.parent);
    }

    private Action createServiceViewerAction() {
        return new ToolAction(this.uif, "exec.view.serviceviewer"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ET_DefaultViewControl.this.config != null && ET_DefaultViewControl.this.config.getWorkDirectory() != null) {
                    ET_DefaultViewControl.this.openServiceViewer();
                } else {
                    ET_DefaultViewControl.this.testSuite.getNotificationLog(null).info(ET_DefaultViewControl.this.uif.getI18NString("exec.view.serviceviewer.noworkdir"));
                }
            }
        };
    }

    private void openServiceViewer() {
        if (this.serviceViewer == null) {
            ServiceManager mgr = this.testSuite.getServiceManager();
            this.serviceViewer = new ServiceViewer(mgr, this.uif, this.parent);
            this.updateServiceViewer();
        }
        this.serviceViewer.setVisible(true);
    }

    private void updateServiceViewer() {
        if (this.serviceViewer != null) {
            ServiceManager mgr = this.serviceViewer.getServiceManager();
            if (this.config != null && this.config.getInterviewParameters() != null) {
                mgr.setParameters(this.config.getInterviewParameters());
                if (!this.config.getInterviewParameters().containsObserver(this.serviceViewer)) {
                    this.config.getInterviewParameters().addObserver(this.serviceViewer);
                }
            }
        }
    }

    List<Action> createConfigActions() {
        LinkedList<Action> acts = new LinkedList<Action>();
        this.showEnvironmentAction = new ToolAction(this.uif, "ch.env"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ET_DefaultViewControl.this.showEnvironment();
            }
        };
        this.showExcludeListAction = new ToolAction(this.uif, "ch.excl"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ET_DefaultViewControl.this.showExcludeList();
            }
        };
        this.showChecklistAction = new ToolAction(this.uif, "ch.checkList"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ET_DefaultViewControl.this.showChecklist();
            }
        };
        this.showQuestionLogAction = new ToolAction(this.uif, "ch.quLog"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ET_DefaultViewControl.this.showQuestionLog();
            }
        };
        acts.add(this.showEnvironmentAction);
        acts.add(this.showExcludeListAction);
        acts.add(this.showChecklistAction);
        acts.add(this.showQuestionLogAction);
        return acts;
    }

    void ensureInterviewUpToDate() {
        try {
            this.config.reloadInterview();
        }
        catch (Exception ex) {
            if (debug > 0) {
                ex.printStackTrace(Debug.getWriter());
            }
            this.uif.showError("exec.loadInterview", (Object)ex.toString());
        }
    }

    boolean isConfigEdited() {
        return false;
    }

    boolean isOKToContinue() {
        return true;
    }

    void showEnvironment() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.environmentBrowser == null) {
            this.environmentBrowser = new EnvironmentBrowser(this.parent, this.uif);
        }
        this.environmentBrowser.show(this.config.getInterviewParameters());
    }

    void showExcludeList() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.excludeListBrowser == null) {
            this.excludeListBrowser = new ExcludeListBrowser(this.parent, this.uif);
        }
        this.excludeListBrowser.show(this.config.getInterviewParameters());
    }

    void showChecklist() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.checkListBrowser == null) {
            this.checkListBrowser = new ChecklistBrowser(this.parent, this.execModel, this.uif);
        }
        this.checkListBrowser.setVisible(true);
    }

    void showQuestionLog() {
        this.ensureInterviewUpToDate();
        if (this.isConfigEdited() && !this.isOKToContinue()) {
            return;
        }
        if (this.questionLogBrowser == null) {
            this.questionLogBrowser = new QuestionLogBrowser(this.parent, this.execModel, this.uif);
        }
        this.questionLogBrowser.setVisible(true);
    }
}

