/*
 * Copyright (c) 2009, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.core.relationship.unionexone;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;

@Entity
public class Uni1X1Project implements java.io.Serializable {

  private long projId;

  private String name;

  private float budget;

  public Uni1X1Project() {
  }

  public Uni1X1Project(long projId, String name, float budget) {
    this.projId = projId;
    this.name = name;
    this.budget = budget;
  }

  @Id
  public long getProjId() {
    return projId;

  }

  public void setProjId(long projId) {
    this.projId = projId;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public float getBudget() {
    return budget;
  }

  public void setBudget(float budget) {
    this.budget = budget;
  }

}
