/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.spec.jspdocument.elements;

import ee.jakarta.tck.pages.common.client.AbstractUrlClient;
import java.io.IOException;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.UrlAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class URLClientIT
extends AbstractUrlClient {
    private static final String CONTEXT_ROOT = "/jsp_jspdocument_elements_web";

    public URLClientIT() throws Exception {
        this.setContextRoot(CONTEXT_ROOT);
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        String packagePath = URLClientIT.class.getPackageName().replace(".", "/");
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jsp_jspdocument_elements_web.war");
        archive.setWebXML(URLClientIT.class.getClassLoader().getResource(packagePath + "/jsp_jspdocument_elements_web.xml"));
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/scriptingInJspPage.jsp")), "scriptingInJspPage.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/scripting.jspx")), "scripting.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/notJspDocument.jspx")), "notJspDocument.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/negativeJspRoot.jspx")), "negativeJspRoot.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/jspRootPrefix.jspx")), "jspRootPrefix.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/included.jspx")), "included.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/included.jsp")), "included.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/directivePageInJspPage.jsp")), "directivePageInJspPage.jsp");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/directiveIncludeLocation.jspx")), "directiveIncludeLocation.jspx");
        archive.add((Asset)new UrlAsset(URLClientIT.class.getClassLoader().getResource(packagePath + "/directiveIncludeInJspPage.jsp")), "directiveIncludeInJspPage.jsp");
        return archive;
    }

    @Test
    public void negativeJspRootTest() throws Exception {
        String testName = "negativeJspRoot";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/notJspDocument.jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "500");
        this.invoke();
    }

    @Test
    public void jspRootPrefixTest() throws Exception {
        String testName = "jspRootPrefix";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        this.invoke();
    }

    @Test
    public void directiveIncludeLocationTest() throws Exception {
        String testName = "directiveIncludeLocation";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "HELLO|ONE|HELLO|TWO");
        this.invoke();
    }

    @Test
    public void directiveIncludeInJspPageTest() throws Exception {
        String testName = "directiveIncludeInJspPage";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "HELLO|ONE");
        this.invoke();
    }

    @Test
    public void directivePageInJspPageTest() throws Exception {
        String testName = "directivePageInJspPage";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "listSize2");
        this.invoke();
    }

    @Test
    public void scriptingTest() throws Exception {
        String testName = "scripting";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jspx HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "JSP637|JSP637|99");
        this.invoke();
    }

    @Test
    public void scriptingInJspPageTest() throws Exception {
        String testName = "scriptingInJspPage";
        TEST_PROPS.setProperty("request", "GET /jsp_jspdocument_elements_web/" + testName + ".jsp HTTP/1.1");
        TEST_PROPS.setProperty("status-code", "200");
        TEST_PROPS.setProperty("search_string", "JSP637|99");
        this.invoke();
    }
}

