/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.nosql.select;

import ee.jakarta.tck.nosql.AbstractTemplateTest;
import ee.jakarta.tck.nosql.entities.Person;
import ee.jakarta.tck.nosql.factories.PersonListSupplier;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ArgumentsSource;

@DisplayName(value="The query execution exploring the classic POJO")
public class SelectTemplateTest
extends AbstractTemplateTest {
    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with no conditions")
    void shouldInsertIterablePersonNoCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).hasSize(entities.size());
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with simple conditions")
    void shouldInsertIterablePerson(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").eq((Object)entities.get(0).getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getName().equals(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with greater-than condition")
    void shouldInsertIterableAndSelectWithGreaterThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").gt((Object)secondElder).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() > secondElder);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with less-than condition")
    void shouldInsertIterableAndSelectWithLessThanCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").lt((Object)secondElder).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() < secondElder);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with LIKE condition")
    void shouldInsertIterableAndSelectWithLikeCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").like(entities.get(0).getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getName().contains(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'in' condition")
    void shouldInsertIterableAndSelectWithInCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            List result = this.template.select(Person.class).where("name").in(List.of(entities.get(0).getName())).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getName().equals(((Person)entities.get(0)).getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'between' condition")
    void shouldInsertIterableAndSelectWithBetweenCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").between((Object)secondElder, (Object)(secondElder + 5)).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() >= secondElder && person.getAge() <= secondElder + 5);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'skip' and 'limit' conditions")
    void shouldInsertIterableAndSelectWithSkipAndLimitCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").gt((Object)secondElder).skip(0L).limit(10L).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() > secondElder);
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'orderBy' condition")
    void shouldInsertIterableAndSelectWithOrderByCondition(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            int secondElder = entities.stream().mapToInt(Person::getAge).sorted().skip(1L).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").gt((Object)secondElder).orderBy("name").asc().result();
            List names = result.stream().map(Person::getName).collect(Collectors.toList());
            Assertions.assertThat(names).isSorted();
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'complex' query using 'and'")
    void shouldInsertIterableAndSelectWithComplexQueryAnd(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Person secondElder = entities.stream().sorted(Comparator.comparing(Person::getAge)).skip(entities.size() - 1).findFirst().orElseThrow();
            int age = secondElder.getAge() - 1;
            String name = secondElder.getName();
            List result = this.template.select(Person.class).where("age").gt((Object)age).and("name").eq((Object)name).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() > age && person.getName().equals(name));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }

    @ParameterizedTest
    @ArgumentsSource(value=PersonListSupplier.class)
    @DisplayName(value="Should insert Iterable and select with 'complex' query using 'or'")
    void shouldInsertIterableAndSelectWithComplexQueryOr(List<Person> entities) {
        entities.forEach(entity -> this.template.insert(entity));
        try {
            Person secondElder = entities.stream().sorted(Comparator.comparing(Person::getAge)).skip(entities.size() - 1).findFirst().orElseThrow();
            List result = this.template.select(Person.class).where("age").gt((Object)secondElder.getAge()).or("name").eq((Object)secondElder.getName()).result();
            ((ListAssert)Assertions.assertThat((List)result).isNotEmpty()).allMatch(person -> person.getAge() > secondElder.getAge() || person.getName().equals(secondElder.getName()));
        }
        catch (UnsupportedOperationException exp) {
            Assertions.assertThat((Throwable)exp).isInstanceOf(UnsupportedOperationException.class);
        }
    }
}

