/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.impl.orm20;

import java.util.ArrayList;
import java.util.List;
import org.jboss.shrinkwrap.descriptor.api.Child;
import org.jboss.shrinkwrap.descriptor.api.orm20.CollectionTable;
import org.jboss.shrinkwrap.descriptor.api.orm20.JoinColumn;
import org.jboss.shrinkwrap.descriptor.api.orm20.UniqueConstraint;
import org.jboss.shrinkwrap.descriptor.impl.orm20.JoinColumnImpl;
import org.jboss.shrinkwrap.descriptor.impl.orm20.UniqueConstraintImpl;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTableImpl<T>
implements Child<T>,
CollectionTable<T> {
    private T t;
    private Node childNode;

    public CollectionTableImpl(T t, String nodeName, Node node) {
        this.t = t;
        this.childNode = node.createChild(nodeName);
    }

    public CollectionTableImpl(T t, String nodeName, Node node, Node childNode) {
        this.t = t;
        this.childNode = childNode;
    }

    public T up() {
        return this.t;
    }

    public JoinColumn<CollectionTable<T>> getOrCreateJoinColumn() {
        List nodeList = this.childNode.get("join-column");
        if (nodeList != null && nodeList.size() > 0) {
            return new JoinColumnImpl<CollectionTable<T>>(this, "join-column", this.childNode, (Node)nodeList.get(0));
        }
        return this.createJoinColumn();
    }

    public JoinColumn<CollectionTable<T>> createJoinColumn() {
        return new JoinColumnImpl<CollectionTable<T>>(this, "join-column", this.childNode);
    }

    public List<JoinColumn<CollectionTable<T>>> getAllJoinColumn() {
        ArrayList<JoinColumn<CollectionTable<T>>> list = new ArrayList<JoinColumn<CollectionTable<T>>>();
        List nodeList = this.childNode.get("join-column");
        for (Node node : nodeList) {
            JoinColumnImpl<CollectionTableImpl> type = new JoinColumnImpl<CollectionTableImpl>(this, "join-column", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public CollectionTable<T> removeAllJoinColumn() {
        this.childNode.removeChildren("join-column");
        return this;
    }

    public UniqueConstraint<CollectionTable<T>> getOrCreateUniqueConstraint() {
        List nodeList = this.childNode.get("unique-constraint");
        if (nodeList != null && nodeList.size() > 0) {
            return new UniqueConstraintImpl<CollectionTable<T>>(this, "unique-constraint", this.childNode, (Node)nodeList.get(0));
        }
        return this.createUniqueConstraint();
    }

    public UniqueConstraint<CollectionTable<T>> createUniqueConstraint() {
        return new UniqueConstraintImpl<CollectionTable<T>>(this, "unique-constraint", this.childNode);
    }

    public List<UniqueConstraint<CollectionTable<T>>> getAllUniqueConstraint() {
        ArrayList<UniqueConstraint<CollectionTable<T>>> list = new ArrayList<UniqueConstraint<CollectionTable<T>>>();
        List nodeList = this.childNode.get("unique-constraint");
        for (Node node : nodeList) {
            UniqueConstraintImpl<CollectionTableImpl> type = new UniqueConstraintImpl<CollectionTableImpl>(this, "unique-constraint", this.childNode, node);
            list.add(type);
        }
        return list;
    }

    public CollectionTable<T> removeAllUniqueConstraint() {
        this.childNode.removeChildren("unique-constraint");
        return this;
    }

    public CollectionTable<T> name(String name) {
        this.childNode.attribute("name", name);
        return this;
    }

    public String getName() {
        return this.childNode.getAttribute("name");
    }

    public CollectionTable<T> removeName() {
        this.childNode.removeAttribute("name");
        return this;
    }

    public CollectionTable<T> catalog(String catalog) {
        this.childNode.attribute("catalog", catalog);
        return this;
    }

    public String getCatalog() {
        return this.childNode.getAttribute("catalog");
    }

    public CollectionTable<T> removeCatalog() {
        this.childNode.removeAttribute("catalog");
        return this;
    }

    public CollectionTable<T> schema(String schema) {
        this.childNode.attribute("schema", schema);
        return this;
    }

    public String getSchema() {
        return this.childNode.getAttribute("schema");
    }

    public CollectionTable<T> removeSchema() {
        this.childNode.removeAttribute("schema");
        return this;
    }
}

