/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.StringWebResponse;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.WebWindowImpl;
import com.gargoylesoftware.htmlunit.html.BaseFrameElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;

public class FrameWindow
extends WebWindowImpl {
    private final BaseFrameElement frame_;

    FrameWindow(BaseFrameElement frame) {
        super(frame.getPage().getWebClient());
        this.frame_ = frame;
        this.performRegistration();
        WebWindowImpl parent = (WebWindowImpl)this.frame_.getPage().getEnclosingWindow();
        parent.addChildWindow(this);
    }

    @Override
    public String getName() {
        return this.frame_.getNameAttribute();
    }

    @Override
    public void setName(String name) {
        this.frame_.setNameAttribute(name);
    }

    @Override
    public WebWindow getParentWindow() {
        return this.frame_.getPage().getEnclosingWindow();
    }

    @Override
    public WebWindow getTopWindow() {
        return this.getParentWindow().getTopWindow();
    }

    @Override
    protected boolean isJavaScriptInitializationNeeded() {
        return this.getScriptableObject() == null || !(this.getEnclosedPage().getWebResponse() instanceof StringWebResponse);
    }

    public HtmlPage getEnclosingPage() {
        return (HtmlPage)this.frame_.getPage();
    }

    @Override
    public void setEnclosedPage(Page page) {
        StringWebResponse response;
        super.setEnclosedPage(page);
        WebResponse webResponse = page.getWebResponse();
        if (webResponse instanceof StringWebResponse && (response = (StringWebResponse)webResponse).isFromJavascript()) {
            BaseFrameElement frame = this.getFrameElement();
            frame.setContentLoaded();
        }
    }

    public BaseFrameElement getFrameElement() {
        return this.frame_;
    }

    public String toString() {
        return "FrameWindow[name=\"" + this.getName() + "\"]";
    }

    public void close() {
        WebWindowImpl parent = (WebWindowImpl)this.getParentWindow();
        parent.removeChildWindow(this);
        this.getWebClient().deregisterWebWindow(this);
    }
}

