/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.css.parser.selector;

import com.gargoylesoftware.css.parser.Locator;
import com.gargoylesoftware.css.parser.condition.Condition;
import com.gargoylesoftware.css.parser.selector.AbstractSelector;
import com.gargoylesoftware.css.parser.selector.Selector;
import com.gargoylesoftware.css.parser.selector.SimpleSelector;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ElementSelector
extends AbstractSelector
implements SimpleSelector {
    private final String localName_;
    private final String localNameLC_;
    private List<Condition> conditions_;

    public ElementSelector(String localName, Locator locator) {
        this.localName_ = localName;
        this.localNameLC_ = localName != null ? localName.toLowerCase(Locale.ROOT) : null;
        this.setLocator(locator);
    }

    @Override
    public Selector.SelectorType getSelectorType() {
        return Selector.SelectorType.ELEMENT_NODE_SELECTOR;
    }

    @Override
    public SimpleSelector getSimpleSelector() {
        return this;
    }

    public String getLocalName() {
        return this.localName_;
    }

    public String getLocalNameLowerCase() {
        return this.localNameLC_;
    }

    public String getElementName() {
        String localeName = this.getLocalName();
        if (localeName == null) {
            return "*";
        }
        return localeName;
    }

    public List<Condition> getConditions() {
        return this.conditions_;
    }

    public void addCondition(Condition condition) {
        if (this.conditions_ == null) {
            this.conditions_ = new ArrayList<Condition>();
        }
        this.conditions_.add(condition);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getElementName());
        if (this.conditions_ != null) {
            for (Condition condition : this.conditions_) {
                result.append(condition);
            }
        }
        return result.toString();
    }
}

