/*
 * Decompiled with CFR 0.152.
 */
package org.mvcspec.tck.tests.mvc.response;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mvcspec.tck.tests.mvc.response.ResponseFeaturesController;
import org.mvcspec.tck.util.Archives;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class ResponseFeaturesTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ResponseFeaturesController.class).addView("Rendered view", "view.jsp").build();
    }

    @Test
    @SpecAssertion(section="response", id="response-header")
    public void responseAllowsSettingHeaders() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/response/header").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view"));
        Assert.assertThat((Object)response.getResponseHeaderValue("X-Controller-Header"), (Matcher)CoreMatchers.equalTo((Object)"Foobar"));
    }

    @Test
    @SpecAssertion(section="response", id="response-header")
    public void responseAllowsSettingCacheControl() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/response/cache").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Rendered view"));
        Assert.assertThat((Object)response.getResponseHeaderValue("Cache-Control"), (Matcher)CoreMatchers.containsString((String)"private"));
    }
}

