/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.nullhandling;

import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NillablePropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NillablePropertyNonNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NonNillableAndNillablePropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NonNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NonNillablePropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.NonNillablePropertyNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.SimpleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nillable.NillablePackageNillablePropertyNonNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nillable.NillablePackageNonNillablePropertyContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nillable.NillablePackageSimpleContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageNonNillablePropertyNillableContainer;
import ee.jakarta.tck.json.bind.customizedmapping.nullhandling.model.nonnillable.NonNillablePackageSimpleContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import java.util.regex.Pattern;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

public class NullHandlingCustomizationTest {
    private static final Pattern PATTERN_NULL = Pattern.compile("\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}");
    private final Jsonb jsonb = JsonbBuilder.create();

    @Test
    public void testNillableType() {
        String jsonString = this.jsonb.toJson((Object)new NillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null property of type annotated as JsonbNillable.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN_NULL));
    }

    @Test
    public void testNillablePackage() {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageSimpleContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null property of type under package annotated as JsonbNillable.", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN_NULL));
    }

    @Test
    public void testNillableProperty() {
        String jsonString = this.jsonb.toJson((Object)new NillablePropertyContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null property annotated as JsonbProperty with nillable = true.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}"));
    }

    @Test
    public void testNullValuesConfig() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new SimpleContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null properties when using JsonbConfig().withNullValues(true).", (Object)jsonString, (Matcher)Matchers.matchesPattern((Pattern)PATTERN_NULL));
    }

    @Test
    public void testNillableTypeNonNillableProperty() {
        String jsonString = this.jsonb.toJson((Object)new NonNillablePropertyNillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null property annotated as JsonbProperty with nillable = false of type annotated as JsonbNillable.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNillablePackageNonNillableProperty() {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageNonNillablePropertyContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null property annotated as JsonbProperty(nillable = false) of type under package annotated as JsonbNillable.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNillablePackageNonNillableTypeNillableProperty() {
        String jsonString = this.jsonb.toJson((Object)new NillablePackageNillablePropertyNonNillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null property annotated as JsonbProperty(nillable = true) of type annotated as JsonbNillable(false) under package annotated as JsonbNillable.", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillablePackage() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageSimpleContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null properties when using JsonbConfig().withNullValues(true) and type under package annotated as JsonbNillable(false).", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillablePackageNillableType() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageNillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly marshal null properties when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable under package annotated as JsonbNillable(false).", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"stringInstance\"\\s*\\:\\s*null\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillablePackageNillableTypeNonNillableProperty() {
        String validationMessage = "Failed to correctly ignore null property annotated as JsonbProperty with nillable = false when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable under package annotated as JsonbNillable(false).";
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePackageNonNillablePropertyNillableContainer());
        MatcherAssert.assertThat((String)validationMessage, (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillableType() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null property when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable(false).", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillableTypeNillableProperty() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NillablePropertyNonNillableContainer());
        MatcherAssert.assertThat((String)"Failed to correctly include null property annotated as JsonbProperty with nillable = true when using JsonbConfig().withNullValues(true) and type annotated as JsonbNillable(false).", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\"nillableStringInstance\"\\s*\\:\\s*null\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonNillableProperty() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillablePropertyContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null property annotated as JsonbProperty with nillable = false when using JsonbConfig().withNullValues(true).", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }

    @Test
    public void testNullValuesConfigNonAndNillableProperty() {
        Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withNullValues(Boolean.valueOf(true)));
        String jsonString = jsonb.toJson((Object)new NonNillableAndNillablePropertyContainer());
        MatcherAssert.assertThat((String)"Failed to correctly ignore null property annotated both JsonbProperty with nillable = true and JsonbNillable(false) when using JsonbConfig().withNullValues(true).JsonbNillable annotation should take precedence over the JsonbProperty", (Object)jsonString, (Matcher)Matchers.matchesPattern((String)"\\{\\s*\\}"));
    }
}

