/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.json.bind.customizedmapping.instantiation;

import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.OptionalTypeContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.PrimitiveTypeContainer;
import ee.jakarta.tck.json.bind.customizedmapping.instantiation.model.SimpleCreatorParamContainer;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbConfig;
import jakarta.json.bind.JsonbException;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionalCreatorParametersTest {
    private final Jsonb jsonb = JsonbBuilder.create();
    private final Jsonb jsonbRequired = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withCreatorParametersRequired(true));

    @Test
    public void testCreatorMethodWithOptionalParameter() {
        SimpleCreatorParamContainer unmarshalledObject = (SimpleCreatorParamContainer)this.jsonb.fromJson("{ \"paramTwo\" : 1 }", SimpleCreatorParamContainer.class);
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamOne(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamTwo(), (Matcher)Matchers.is((Object)1));
        unmarshalledObject = (SimpleCreatorParamContainer)this.jsonb.fromJson("{ \"paramOne\" : \"some value\", \"paramTwo\" : 2 }", SimpleCreatorParamContainer.class);
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamOne(), (Matcher)Matchers.is((Object)"some value"));
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamTwo(), (Matcher)Matchers.is((Object)2));
        unmarshalledObject = (SimpleCreatorParamContainer)this.jsonb.fromJson("{ }", SimpleCreatorParamContainer.class);
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamOne(), (Matcher)Matchers.nullValue());
        MatcherAssert.assertThat((String)"Failed to instantiate type using JsonbCreator annotated factory method with optional parameter", (Object)unmarshalledObject.getParamTwo(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testAllParametersRequiredSetByMethodAnnotation() {
        Assertions.assertThrows(JsonbException.class, () -> this.jsonbRequired.fromJson("{ }", SimpleCreatorParamContainer.class), (String)"Instantiation of the type should have failed, because required creator parameters were missing");
        Assertions.assertThrows(JsonbException.class, () -> this.jsonbRequired.fromJson("{ \"paramOne\" : \"some value\" }", SimpleCreatorParamContainer.class), (String)"Instantiation of the type should have failed, because required creator parameter was missing");
    }

    @Test
    public void testPrimitiveTypesDefaultValues() {
        PrimitiveTypeContainer unmarshalledObject = (PrimitiveTypeContainer)this.jsonb.fromJson("{ }", PrimitiveTypeContainer.class);
        MatcherAssert.assertThat((String)"Failed to set proper default byte value to the optional creator parameter", (Object)unmarshalledObject.getByteType(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Failed to set proper default short value to the optional creator parameter", (Object)unmarshalledObject.getShortType(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Failed to set proper default int value to the optional creator parameter.", (Object)unmarshalledObject.getIntType(), (Matcher)Matchers.is((Object)0));
        MatcherAssert.assertThat((String)"Failed to set proper default long value to the optional creator parameter.", (Object)unmarshalledObject.getLongType(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"Failed to set proper default float value to the optional creator parameter.", (Object)Float.valueOf(unmarshalledObject.getFloatType()), (Matcher)Matchers.is((Object)Float.valueOf(0.0f)));
        MatcherAssert.assertThat((String)"Failed to set proper default double value to the optional creator parameter.", (Object)unmarshalledObject.getDoubleType(), (Matcher)Matchers.is((Object)0.0));
        MatcherAssert.assertThat((String)"Failed to set proper default boolean value to the optional creator parameter.", (Object)unmarshalledObject.getBooleanType(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((String)"Failed to set proper default char value to the optional creator parameter.", (Object)Character.valueOf(unmarshalledObject.getCharType()), (Matcher)Matchers.is((Object)Character.valueOf('\u0000')));
    }

    @Test
    public void testOptionalTypesDefaultValues() {
        OptionalTypeContainer unmarshalledObject = (OptionalTypeContainer)this.jsonb.fromJson("{ }", OptionalTypeContainer.class);
        MatcherAssert.assertThat((String)"Failed to set empty OptionalInt instance the the optional creator parameter", (Object)unmarshalledObject.getIntOptional(), (Matcher)Matchers.is((Object)-1));
        MatcherAssert.assertThat((String)"Failed to set empty OptionalLong instance the the optional creator parameter", (Object)unmarshalledObject.getLongOptional(), (Matcher)Matchers.is((Object)-1L));
        MatcherAssert.assertThat((String)"Failed to set empty OptionalDouble instance the the optional creator parameter", (Object)unmarshalledObject.getDoubleOptional(), (Matcher)Matchers.is((Object)-1.0));
        MatcherAssert.assertThat((String)"Failed to set empty Optional instance the the optional creator parameter", (Object)unmarshalledObject.getStringOptional(), (Matcher)Matchers.nullValue());
    }

    @Test
    public void testOptionalTypesInCreator() {
        String json = "{ \"stringOptional\":\"stringValue\",\"intOptional\":1,\"longOptional\":2,\"doubleOptional\":3.0 }";
        OptionalTypeContainer unmarshalledObject = (OptionalTypeContainer)this.jsonb.fromJson(json, OptionalTypeContainer.class);
        MatcherAssert.assertThat((String)"Failed to set OptionalInt instance with provided value from the JSON document", (Object)unmarshalledObject.getIntOptional(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((String)"Failed to set OptionalLong instance with provided value from the JSON document", (Object)unmarshalledObject.getLongOptional(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((String)"Failed to set OptionalDouble instance with provided value from the JSON document", (Object)unmarshalledObject.getDoubleOptional(), (Matcher)Matchers.is((Object)3.0));
        MatcherAssert.assertThat((String)"Failed to set Optional instance with provided value from the JSON document", (Object)unmarshalledObject.getStringOptional(), (Matcher)Matchers.is((Object)"stringValue"));
    }
}

