/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.el.spec.coercion;

import com.sun.ts.tests.el.common.util.ELTestUtil;
import com.sun.ts.tests.el.common.util.ExprEval;
import com.sun.ts.tests.el.common.util.NameValuePair;
import jakarta.el.ELException;
import jakarta.el.ELProcessor;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.function.Predicate;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class ELClientIT {
    private static final System.Logger logger = System.getLogger(ELClientIT.class.getName());
    private static final String NLINE = System.getProperty("line.separator", "\n");
    private static final String BYTE = "30";
    private static final String SHORT = "32";
    private static final String INTEGER = "33";
    private static final String LONG = "34";
    private static final String FLOAT = "35.5f";
    private static final String DOUBLE = "36.5d";
    private static final String BIGINT = "125";
    private static final String BIGDEC = "100.5";
    private Hashtable numberTable;

    public ELClientIT() {
        this.initializeNumberTable();
    }

    @AfterEach
    public void cleanup() throws Exception {
        logger.log(System.Logger.Level.INFO, "Cleanup method called");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        logger.log(System.Logger.Level.INFO, "FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void positivePrimitiveToBoxedTest() throws Exception {
        boolean fail = false;
        boolean[] pass = new boolean[]{false, false, false, false, false, false, false, false};
        Object result = null;
        try {
            result = ExprEval.evaluateValueExpression("${true}", null, Boolean.class);
            pass[0] = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)Boolean.TRUE);
            result = ExprEval.evaluateValueExpression("#{'x'}", null, Character.class);
            pass[1] = ExprEval.compareClass(result, Character.class) && ExprEval.compareValue(result, Character.valueOf('x'));
            result = ExprEval.evaluateValueExpression("${2}", null, Byte.class);
            pass[2] = ExprEval.compareClass(result, Byte.class) && ExprEval.compareValue(result, Byte.valueOf("2"));
            result = ExprEval.evaluateValueExpression("#{20}", null, Short.class);
            pass[3] = ExprEval.compareClass(result, Short.class) && ExprEval.compareValue(result, Short.valueOf("20"));
            result = ExprEval.evaluateValueExpression("${2000}", null, Integer.class);
            pass[4] = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, 2000);
            result = ExprEval.evaluateValueExpression("#{2000}", null, Long.class);
            pass[5] = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue(result, 2000L);
            result = ExprEval.evaluateValueExpression("${2e+3}", null, Float.class);
            pass[6] = ExprEval.compareClass(result, Float.class) && ExprEval.compareValue(result, Float.valueOf(2000.0f));
            result = ExprEval.evaluateValueExpression("#{2000.00}", null, Double.class);
            pass[7] = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue(result, 2000.0);
        }
        catch (RuntimeException re) {
            throw new Exception(re);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i]) continue;
            fail = true;
            logger.log(System.Logger.Level.ERROR, "Unexpected result for test case " + i);
        }
        if (fail) {
            throw new Exception("TEST FAILED");
        }
    }

    @Test
    public void positiveBoxedToPrimitiveTest() throws Exception {
        boolean fail = false;
        boolean[] pass = new boolean[]{false, false, false, false, false, false, false, false};
        Object result = null;
        String immExpr = "${A}";
        String defExpr = "#{A}";
        Boolean boolVal = Boolean.FALSE;
        NameValuePair[] boolNV = NameValuePair.buildUnaryNameValue(boolVal);
        Character charVal = Character.valueOf('x');
        NameValuePair[] charNV = NameValuePair.buildUnaryNameValue(charVal);
        Byte byteVal = Byte.valueOf("2");
        NameValuePair[] byteNV = NameValuePair.buildUnaryNameValue(byteVal);
        Short shortVal = Short.valueOf("20");
        NameValuePair[] shortNV = NameValuePair.buildUnaryNameValue(shortVal);
        Integer intVal = 2000;
        NameValuePair[] intNV = NameValuePair.buildUnaryNameValue(intVal);
        Long longVal = 2000L;
        NameValuePair[] longNV = NameValuePair.buildUnaryNameValue(longVal);
        Float floatVal = Float.valueOf("2e+3");
        NameValuePair[] floatNV = NameValuePair.buildUnaryNameValue(floatVal);
        Double doubleVal = 2000.0;
        NameValuePair[] doubleNV = NameValuePair.buildUnaryNameValue(doubleVal);
        try {
            result = ExprEval.evaluateValueExpression(defExpr, boolNV, Boolean.TYPE);
            pass[0] = ExprEval.compareClass(result, Boolean.class) && ExprEval.compareValue(result, (Object)boolVal);
            result = ExprEval.evaluateValueExpression(immExpr, charNV, Character.TYPE);
            pass[1] = ExprEval.compareClass(result, Character.class) && ExprEval.compareValue(result, charVal);
            result = ExprEval.evaluateValueExpression(defExpr, byteNV, Byte.TYPE);
            pass[2] = ExprEval.compareClass(result, Byte.class) && ExprEval.compareValue(result, byteVal);
            result = ExprEval.evaluateValueExpression(immExpr, shortNV, Short.TYPE);
            pass[3] = ExprEval.compareClass(result, Short.class) && ExprEval.compareValue(result, shortVal);
            result = ExprEval.evaluateValueExpression(defExpr, intNV, Integer.TYPE);
            pass[4] = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, intVal);
            result = ExprEval.evaluateValueExpression(immExpr, longNV, Long.TYPE);
            pass[5] = ExprEval.compareClass(result, Long.class) && ExprEval.compareValue(result, longVal);
            result = ExprEval.evaluateValueExpression(defExpr, floatNV, Float.TYPE);
            pass[6] = ExprEval.compareClass(result, Float.class) && ExprEval.compareValue(result, floatVal);
            result = ExprEval.evaluateValueExpression(immExpr, doubleNV, Double.TYPE);
            pass[7] = ExprEval.compareClass(result, Double.class) && ExprEval.compareValue(result, doubleVal);
        }
        catch (RuntimeException re) {
            throw new Exception(re);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i]) continue;
            fail = true;
            logger.log(System.Logger.Level.ERROR, "Unexpected result for test case " + i);
        }
        if (fail) {
            throw new Exception("TEST FAILED");
        }
    }

    @Test
    public void positiveElBooleanCoercionTest() throws Exception {
        Class<Boolean> expectedClass = Boolean.class;
        boolean pass = false;
        try {
            Object result2 = ExprEval.evaluateValueExpression("#{''}", null, expectedClass);
            Object result3 = ExprEval.evaluateValueExpression("${" + Boolean.TRUE + "}", null, expectedClass);
            Object result4 = ExprEval.evaluateValueExpression("#{'true'}", null, expectedClass);
            logger.log(System.Logger.Level.TRACE, "result2 is " + result2.toString());
            logger.log(System.Logger.Level.TRACE, "result3 is " + result3.toString());
            logger.log(System.Logger.Level.TRACE, "result4 is " + result4.toString());
            pass = ExprEval.compareClass(result2, expectedClass) && ExprEval.compareValue(result2, (Object)Boolean.FALSE) && ExprEval.compareClass(result3, expectedClass) && ExprEval.compareValue(result3, (Object)Boolean.TRUE) && ExprEval.compareClass(result4, expectedClass) && ExprEval.compareValue(result4, (Object)Boolean.TRUE);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void negativeElBooleanCoercionTest() throws Exception {
        boolean pass = false;
        try {
            ExprEval.evaluateValueExpression("${1}", null, Boolean.class);
            logger.log(System.Logger.Level.ERROR, "No exception thrown when coercing invalid class to Boolean");
        }
        catch (ELException ee) {
            pass = true;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elPrimitiveToStringCoercionTest() throws Exception {
        boolean pass10;
        boolean pass9;
        boolean pass8;
        boolean pass7;
        boolean pass6;
        boolean pass5;
        boolean pass4;
        boolean pass2;
        boolean pass1;
        boolean pass11 = false;
        Class<String> expectedClass = String.class;
        String primString = "\"STRING\"";
        boolean primBoolean = false;
        byte primByte = 0;
        char primChar = '1';
        short primShort = 2;
        int primInt = 3;
        long primLong = 4L;
        float primFloat = 5.5f;
        double primDouble = 6.5;
        greeting morning = greeting.hello;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${" + primString + "}", null, expectedClass);
            pass1 = ExprEval.compareClass(result1, expectedClass) && ExprEval.compareValue(result1, "STRING");
            Object result2 = ExprEval.evaluateValueExpression("#{" + primBoolean + "}", null, expectedClass);
            pass2 = ExprEval.compareClass(result2, expectedClass) && ExprEval.compareValue(result2, "false");
            Object result4 = ExprEval.evaluateValueExpression("#{" + primByte + "}", null, expectedClass);
            pass4 = ExprEval.compareClass(result4, expectedClass) && ExprEval.compareValue(result4, "0");
            Object result5 = ExprEval.evaluateValueExpression("#{" + primChar + "}", null, expectedClass);
            pass5 = ExprEval.compareClass(result5, expectedClass) && ExprEval.compareValue(result5, "1");
            Object result6 = ExprEval.evaluateValueExpression("#{" + primShort + "}", null, expectedClass);
            pass6 = ExprEval.compareClass(result6, expectedClass) && ExprEval.compareValue(result6, "2");
            Object result7 = ExprEval.evaluateValueExpression("#{" + primInt + "}", null, expectedClass);
            pass7 = ExprEval.compareClass(result7, expectedClass) && ExprEval.compareValue(result7, "3");
            Object result8 = ExprEval.evaluateValueExpression("#{" + primLong + "}", null, expectedClass);
            pass8 = ExprEval.compareClass(result8, expectedClass) && ExprEval.compareValue(result8, "4");
            Object result9 = ExprEval.evaluateValueExpression("#{" + primFloat + "}", null, expectedClass);
            pass9 = ExprEval.compareClass(result9, expectedClass) && ExprEval.compareValue(result9, "5.5");
            Object result10 = ExprEval.evaluateValueExpression("#{" + primDouble + "}", null, expectedClass);
            pass10 = ExprEval.compareClass(result10, expectedClass) && ExprEval.compareValue(result10, "6.5");
            Object result11 = ExprEval.evaluateValueExpression("#{'" + morning + "'}", null, expectedClass);
            pass11 = ExprEval.compareClass(result11, expectedClass) && ExprEval.compareValue(result11, morning.name());
        }
        catch (RuntimeException re) {
            throw new Exception(re);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "String Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "boolean Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass4) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "byte Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass5) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "char Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass6) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "short Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass7) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "int Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass8) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "long Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass9) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "float Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass10) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "double Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass11) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "enum Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
    }

    @Test
    public void elWrapperToStringCoercionTest() throws Exception {
        boolean pass7;
        boolean pass6;
        boolean pass5;
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        boolean pass8 = false;
        Class<String> expectedClass = String.class;
        Boolean boo = false;
        Byte bite = 0;
        Character funny = Character.valueOf('1');
        Short tee = 2;
        Integer i = 3;
        Long rope = 4L;
        Float ter = Float.valueOf(5.5f);
        Double down = 6.5;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${" + boo + "}", null, expectedClass);
            pass1 = ExprEval.compareClass(result1, expectedClass) && ExprEval.compareValue(result1, "false");
            Object result2 = ExprEval.evaluateValueExpression("#{" + bite + "}", null, expectedClass);
            pass2 = ExprEval.compareClass(result2, expectedClass) && ExprEval.compareValue(result2, "0");
            Object result3 = ExprEval.evaluateValueExpression("#{" + funny + "}", null, expectedClass);
            pass3 = ExprEval.compareClass(result3, expectedClass) && ExprEval.compareValue(result3, "1");
            Object result4 = ExprEval.evaluateValueExpression("#{" + tee + "}", null, expectedClass);
            pass4 = ExprEval.compareClass(result4, expectedClass) && ExprEval.compareValue(result4, "2");
            Object result5 = ExprEval.evaluateValueExpression("#{" + i + "}", null, expectedClass);
            pass5 = ExprEval.compareClass(result5, expectedClass) && ExprEval.compareValue(result5, "3");
            Object result6 = ExprEval.evaluateValueExpression("#{" + rope + "}", null, expectedClass);
            pass6 = ExprEval.compareClass(result6, expectedClass) && ExprEval.compareValue(result6, "4");
            Object result7 = ExprEval.evaluateValueExpression("#{" + ter + "}", null, expectedClass);
            pass7 = ExprEval.compareClass(result7, expectedClass) && ExprEval.compareValue(result7, "5.5");
            Object result8 = ExprEval.evaluateValueExpression("#{" + down + "}", null, expectedClass);
            pass8 = ExprEval.compareClass(result8, expectedClass) && ExprEval.compareValue(result8, "6.5");
        }
        catch (RuntimeException re) {
            throw new Exception(re);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "String Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "boolean Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass3) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "null Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass4) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "byte Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass5) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "char Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass6) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "short Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass7) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "int Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass8) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "long Coerced to String Failed!" + NLINE + "See above for expected value." + NLINE);
        }
    }

    @Test
    public void positiveElCharacterCoercionTest() throws Exception {
        boolean pass8;
        boolean pass7;
        boolean pass6;
        boolean pass5;
        boolean pass4;
        boolean pass3;
        boolean pass2;
        boolean pass1;
        boolean pass10 = false;
        Class<Character> expectedClass = Character.class;
        Byte bite = 7;
        Character funny = Character.valueOf('1');
        Short tee = 2;
        Integer i = 3;
        Long rope = 4L;
        Float ter = Float.valueOf(5.0f);
        Double down = 6.5;
        try {
            Object result1 = ExprEval.evaluateValueExpression("${'STRING'}", null, expectedClass);
            pass1 = ExprEval.compareClass(result1, expectedClass) && ExprEval.compareValue(result1, Character.valueOf('S'));
            Object result2 = ExprEval.evaluateValueExpression("${" + bite + "}", null, expectedClass);
            pass2 = ExprEval.compareClass(result2, expectedClass) && ExprEval.compareValue(result2, Character.valueOf('\u0007'));
            Object result3 = ExprEval.evaluateValueExpression("${" + funny + "}", null, expectedClass);
            pass3 = ExprEval.compareClass(result3, expectedClass) && ExprEval.compareValue(result3, Character.valueOf('\u0001'));
            Object result4 = ExprEval.evaluateValueExpression("${" + tee + "}", null, expectedClass);
            pass4 = ExprEval.compareClass(result4, expectedClass) && ExprEval.compareValue(result4, Character.valueOf('\u0002'));
            Object result5 = ExprEval.evaluateValueExpression("${" + i + "}", null, expectedClass);
            pass5 = ExprEval.compareClass(result5, expectedClass) && ExprEval.compareValue(result5, Character.valueOf('\u0003'));
            Object result6 = ExprEval.evaluateValueExpression("${" + rope + "}", null, expectedClass);
            pass6 = ExprEval.compareClass(result6, expectedClass) && ExprEval.compareValue(result6, Character.valueOf('\u0004'));
            Object result7 = ExprEval.evaluateValueExpression("${" + ter + "}", null, expectedClass);
            pass7 = ExprEval.compareClass(result7, expectedClass) && ExprEval.compareValue(result7, Character.valueOf('\u0005'));
            Object result8 = ExprEval.evaluateValueExpression("${" + down + "}", null, expectedClass);
            pass8 = ExprEval.compareClass(result8, expectedClass) && ExprEval.compareValue(result8, Character.valueOf('\u0006'));
            Object result10 = ExprEval.evaluateValueExpression("${''}", null, expectedClass);
            pass10 = ExprEval.compareClass(result10, expectedClass) && ExprEval.compareValue(result10, Character.valueOf('\u0000'));
        }
        catch (RuntimeException re) {
            throw new Exception(re);
        }
        catch (Exception e) {
            ELTestUtil.printStackTrace(e);
            throw new Exception(e);
        }
        if (!pass1) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "String Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass2) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Byte Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass3) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Character Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass4) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Short Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass5) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Integer Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass6) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Long Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass7) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Float Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass8) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Double Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
        if (!pass10) {
            throw new Exception("TEST FAILED: pass = false" + NLINE + "Empty String Coerced to Character Failed!" + NLINE + "See above for expected value." + NLINE);
        }
    }

    @Test
    public void negativeElCharacterCoercionTest() throws Exception {
        boolean pass = false;
        try {
            ExprEval.evaluateValueExpression("${" + pass + "}", null, Character.class);
            logger.log(System.Logger.Level.ERROR, "No exception thrown when coercing Boolean to Character!");
        }
        catch (ELException ee) {
            pass = true;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception thrown, but it was not an ELException");
            ELTestUtil.printStackTrace(e);
        }
        if (!pass) {
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void negativeElNumberCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        while (keys.hasMoreElements()) {
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            try {
                ExprEval.evaluateValueExpression("${" + pass + "}", null, testClass);
                logger.log(System.Logger.Level.ERROR, "No exception thrown when coercing Boolean to " + name + "!" + NLINE);
            }
            catch (ELException ee) {
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception thrown, but it was not an ELException");
                ELTestUtil.printStackTrace(e);
            }
            if (!pass) {
                throw new Exception("TEST FAILED: pass = false");
            }
            try {
                ExprEval.evaluateValueExpression("${'A'}", null, testClass);
                logger.log(System.Logger.Level.ERROR, "No exception thrown when coercing String to " + name + "!" + NLINE);
            }
            catch (ELException ee) {
                pass = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Exception thrown, but it was not an ELException");
                ELTestUtil.printStackTrace(e);
            }
            if (pass) continue;
            throw new Exception("TEST FAILED: pass = false");
        }
    }

    @Test
    public void elNullToNumberCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        while (keys.hasMoreElements()) {
            boolean pass1 = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            Object expectedValue = "Byte".equals(name) ? Byte.valueOf((byte)0) : ("Short".equals(name) ? Short.valueOf((short)0) : ("Integer".equals(name) ? Integer.valueOf(0) : ("Long".equals(name) ? Long.valueOf(0L) : ("Float".equals(name) ? Float.valueOf(0.0f) : ("Double".equals(name) ? Double.valueOf(0.0) : ("BigInteger".equals(name) ? BigInteger.valueOf(0L) : ("BigDecimal".equals(name) ? BigDecimal.valueOf(0L) : "0")))))));
            try {
                Object result1 = ExprEval.evaluateValueExpression("${''}", null, testClass);
                pass1 = ExprEval.compareClass(result1, testClass) && ExprEval.compareValue(result1, expectedValue);
                if (pass1) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + "Empty String Coerced to " + name + " Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToByteCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Byte> expectedClass = Byte.class;
        while (keys.hasMoreElements()) {
            Byte expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Byte.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Byte.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Byte.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Byte.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(FLOAT).byteValue();
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(DOUBLE).byteValue();
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Byte.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGDEC).byteValue();
            } else {
                testValue = "0";
                expectedValue = Byte.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Byte Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToShortCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Short> expectedClass = Short.class;
        while (keys.hasMoreElements()) {
            Short expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Short.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Short.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Short.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Short.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(FLOAT).shortValue();
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(DOUBLE).shortValue();
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Short.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGDEC).shortValue();
            } else {
                testValue = "0";
                expectedValue = Short.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Short Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToIntegerCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Integer> expectedClass = Integer.class;
        while (keys.hasMoreElements()) {
            Integer expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Integer.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Integer.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Integer.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Integer.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(FLOAT).intValue();
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(DOUBLE).intValue();
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Integer.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGDEC).intValue();
            } else {
                testValue = "0";
                expectedValue = Integer.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Integer Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToLongCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Long> expectedClass = Long.class;
        while (keys.hasMoreElements()) {
            Long expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Long.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Long.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Long.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Long.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(FLOAT).longValue();
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(DOUBLE).longValue();
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Long.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGDEC).longValue();
            } else {
                testValue = "0";
                expectedValue = Long.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Long Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToFloatCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Float> expectedClass = Float.class;
        while (keys.hasMoreElements()) {
            Float expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(FLOAT);
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(DOUBLE);
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Float.valueOf(BIGDEC);
            } else {
                testValue = "0";
                expectedValue = Float.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue((Float)result, expectedValue, 2);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Float Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToDoubleCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<Double> expectedClass = Double.class;
        while (keys.hasMoreElements()) {
            Double expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(FLOAT);
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(DOUBLE);
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGINT);
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = Double.valueOf(BIGDEC);
            } else {
                testValue = "0";
                expectedValue = Double.valueOf("1");
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to Double Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elStringToNumberCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        while (keys.hasMoreElements()) {
            Object expectedValue;
            String testValue;
            boolean pass = false;
            Class expectedClass = (Class)keys.nextElement();
            String name = expectedClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = BYTE;
                expectedValue = Byte.valueOf(BYTE);
            } else if ("Short".equals(name)) {
                testValue = SHORT;
                expectedValue = Short.valueOf(SHORT);
            } else if ("Integer".equals(name)) {
                testValue = INTEGER;
                expectedValue = Integer.valueOf(INTEGER);
            } else if ("Long".equals(name)) {
                testValue = LONG;
                expectedValue = Long.valueOf(LONG);
            } else if ("Float".equals(name)) {
                testValue = FLOAT.substring(0, FLOAT.length() - 1);
                expectedValue = Float.valueOf(FLOAT);
            } else if ("Double".equals(name)) {
                testValue = DOUBLE.substring(0, DOUBLE.length() - 1);
                expectedValue = Double.valueOf(DOUBLE);
            } else if ("BigInteger".equals(name)) {
                testValue = BIGINT;
                expectedValue = BigInteger.valueOf(Long.valueOf(BIGINT));
            } else if ("BigDecimal".equals(name)) {
                testValue = BIGDEC;
                expectedValue = BigDecimal.valueOf(Double.valueOf(BIGDEC));
            } else {
                testValue = "0";
                expectedValue = "1";
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${'" + testValue + "'}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + "Coerced to " + name + " Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elCharacterToNumberCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        while (keys.hasMoreElements()) {
            Comparable<Byte> expectedValue;
            Character testValue;
            boolean pass = false;
            Class expectedClass = (Class)keys.nextElement();
            String name = expectedClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = Character.valueOf('1');
                expectedValue = Byte.valueOf("1");
            } else if ("Short".equals(name)) {
                testValue = Character.valueOf('2');
                expectedValue = Short.valueOf("2");
            } else if ("Integer".equals(name)) {
                testValue = Character.valueOf('3');
                expectedValue = 3;
            } else if ("Long".equals(name)) {
                testValue = Character.valueOf('4');
                expectedValue = 4L;
            } else if ("Float".equals(name)) {
                testValue = Character.valueOf('5');
                expectedValue = Float.valueOf(5.0f);
            } else if ("Double".equals(name)) {
                testValue = Character.valueOf('6');
                expectedValue = 6.0;
            } else if ("BigInteger".equals(name)) {
                testValue = Character.valueOf('7');
                expectedValue = BigInteger.valueOf(7L);
            } else if ("BigDecimal".equals(name)) {
                testValue = Character.valueOf('8');
                expectedValue = BigDecimal.valueOf(8L);
            } else {
                testValue = Character.valueOf('0');
                expectedValue = Character.valueOf('1');
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${'" + testValue + "'}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue(result, expectedValue);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + "Coerced to " + name + " Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToBigIntegerCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<BigInteger> expectedClass = BigInteger.class;
        while (keys.hasMoreElements()) {
            BigInteger expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Long.valueOf(BYTE));
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Long.valueOf(SHORT));
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Long.valueOf(INTEGER));
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Long.valueOf(LONG));
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Float.valueOf(FLOAT).longValue());
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Double.valueOf(DOUBLE).longValue());
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = BigInteger.valueOf(Long.valueOf(BIGINT));
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(BIGDEC)).toBigInteger();
            } else {
                testValue = "0";
                expectedValue = BigInteger.valueOf(Long.valueOf("1"));
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue((BigInteger)result, expectedValue, 1);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to BigInteger Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elNumberToBigDecimalCoercionTest() throws Exception {
        Enumeration keys = this.numberTable.keys();
        Class<BigDecimal> expectedClass = BigDecimal.class;
        while (keys.hasMoreElements()) {
            BigDecimal expectedValue;
            Object testValue;
            boolean pass = false;
            Class testClass = (Class)keys.nextElement();
            String name = testClass.getSimpleName();
            if ("Byte".equals(name)) {
                testValue = (Byte)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(BYTE));
            } else if ("Short".equals(name)) {
                testValue = (Short)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(SHORT));
            } else if ("Integer".equals(name)) {
                testValue = (Integer)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(INTEGER));
            } else if ("Long".equals(name)) {
                testValue = (Long)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(LONG));
            } else if ("Float".equals(name)) {
                testValue = (Float)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Float.valueOf(FLOAT).doubleValue());
            } else if ("Double".equals(name)) {
                testValue = (Double)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(DOUBLE));
            } else if ("BigInteger".equals(name)) {
                testValue = (BigInteger)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(BIGINT));
            } else if ("BigDecimal".equals(name)) {
                testValue = (BigDecimal)this.numberTable.get(testClass);
                expectedValue = BigDecimal.valueOf(Double.valueOf(BIGDEC));
            } else {
                testValue = "0";
                expectedValue = BigDecimal.valueOf(Double.valueOf("1"));
            }
            try {
                Object result = ExprEval.evaluateValueExpression("${" + testValue + "}", null, expectedClass);
                pass = ExprEval.compareClass(result, expectedClass) && ExprEval.compareValue((BigDecimal)result, expectedValue, 1);
                if (pass) continue;
                throw new Exception("TEST FAILED: pass = false" + NLINE + name + " Coerced to BigDecimal Failed!" + NLINE + "See above for expected value." + NLINE);
            }
            catch (Exception e) {
                throw new Exception(e);
            }
        }
    }

    @Test
    public void elCoerceToEnumTypeTest() throws Exception {
        boolean fail = false;
        boolean[] pass = new boolean[]{false, false, false, false, false};
        Object result = null;
        try {
            NameValuePair[] earthNV = NameValuePair.buildUnaryNameValue((Object)planets.EARTH);
            result = ExprEval.evaluateValueExpression("${A}", earthNV, planets.class);
            pass[0] = ExprEval.compareClass(result, planets.class) && ExprEval.compareValue(result, (Object)planets.EARTH);
            result = ExprEval.evaluateValueExpression("${null}", null, planets.class);
            pass[1] = result == null;
            NameValuePair[] emptyNV = NameValuePair.buildUnaryNameValue("");
            result = ExprEval.evaluateValueExpression("#{A}", emptyNV, planets.class);
            pass[2] = result == null;
            NameValuePair[] marsNV = NameValuePair.buildUnaryNameValue("MARS");
            result = ExprEval.evaluateValueExpression("${A}", marsNV, planets.class);
            pass[3] = ExprEval.compareClass(result, planets.class) && ExprEval.compareValue(result, (Object)planets.MARS);
            NameValuePair[] plutoNV = NameValuePair.buildUnaryNameValue("PLUTO");
            try {
                result = ExprEval.evaluateValueExpression("${A}", plutoNV, planets.class);
            }
            catch (ELException e) {
                pass[4] = true;
            }
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i]) continue;
            fail = true;
            logger.log(System.Logger.Level.ERROR, "Unexpected result for test case " + i);
        }
        if (fail) {
            throw new Exception("TEST FAILED");
        }
    }

    @Test
    public void elCoerceToArrayTest() throws Exception {
        boolean fail = false;
        boolean[] pass = new boolean[]{false, false, false, false, false};
        Object result = null;
        try {
            ELProcessor elp0 = new ELProcessor();
            elp0.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPrimitiveBooleanArray");
            result = elp0.eval("testPrimitiveBooleanArray(null)");
            pass[0] = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, -1);
            ELProcessor elp1 = new ELProcessor();
            elp1.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPrimitiveBooleanArray");
            result = elp1.eval("testPrimitiveBooleanArray([true, false].toArray())");
            pass[1] = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, 2);
            ELProcessor elp2 = new ELProcessor();
            elp2.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPrimitiveBooleanArray");
            result = elp2.eval("testPrimitiveBooleanArray([\"true\", false, true, 'false', null, \"\"].toArray())");
            pass[2] = ExprEval.compareClass(result, Integer.class) && ExprEval.compareValue(result, 6);
            ELProcessor elp3 = new ELProcessor();
            elp3.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPrimitiveBooleanArray");
            try {
                result = elp3.eval("testPrimitiveBooleanArray(['true', 'false', 1234].toArray())");
            }
            catch (ELException e) {
                pass[3] = true;
            }
            ELProcessor elp4 = new ELProcessor();
            elp4.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPrimitiveBooleanArray");
            try {
                result = elp4.eval("testPrimitiveBooleanArray([true, false, true, false, true])");
            }
            catch (ELException e) {
                pass[4] = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Testing coercion to arrays threw an Exception!" + ELTestUtil.NL + "Received: " + e.toString() + ELTestUtil.NL);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i]) continue;
            fail = true;
            logger.log(System.Logger.Level.ERROR, "Unexpected result for test case " + i);
        }
        if (fail) {
            throw new Exception("TEST FAILED");
        }
    }

    public static int testPrimitiveBooleanArray(boolean[] input) {
        if (input == null) {
            return -1;
        }
        return input.length;
    }

    @Test
    public void elCoerceLambdaExpressionToFunctionalInterfaceTest() throws Exception {
        boolean fail = false;
        boolean[] pass = new boolean[]{false, false, false, false, false, false};
        Object result = null;
        try {
            ELProcessor elp0 = new ELProcessor();
            elp0.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateString");
            result = elp0.eval("testPredicateString(x -> x.equals('data'))");
            pass[0] = ExprEval.compareClass(result, String.class) && ExprEval.compareValue(result, "PASS");
            ELProcessor elp1 = new ELProcessor();
            elp1.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateString");
            result = elp1.eval("testPredicateString(x -> x.equals('other'))");
            pass[1] = ExprEval.compareClass(result, String.class) && ExprEval.compareValue(result, "BLOCK");
            ELProcessor elp2 = new ELProcessor();
            elp2.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateString");
            try {
                result = elp2.eval("testPredicateString('notLambdaExpression')");
            }
            catch (ELException e) {
                pass[2] = true;
            }
            ELProcessor elp3 = new ELProcessor();
            elp3.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateLong");
            try {
                result = elp3.eval("testPredicateLong(x -> x.compareTo('data') == 0)");
            }
            catch (ELException e) {
                pass[3] = true;
            }
            ELProcessor elp4 = new ELProcessor();
            elp4.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateString");
            try {
                result = elp4.eval("testPredicateString(x -> x.compareTo(1234) == 0)");
            }
            catch (ELException e) {
                pass[4] = true;
            }
            ELProcessor elp5 = new ELProcessor();
            elp5.defineFunction("", "", "com.sun.ts.tests.el.spec.coercion.ELClientIT", "testPredicateLong");
            try {
                result = elp5.eval("testPredicateLong(x -> x.compareTo('1234') == 0)");
            }
            catch (ELException e) {
                pass[5] = true;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Testing coercion of lambda expressions to functional interfaces threw an Exception!" + ELTestUtil.NL + "Received: " + e.toString() + ELTestUtil.NL);
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        for (int i = 0; i < pass.length; ++i) {
            if (pass[i]) continue;
            fail = true;
            logger.log(System.Logger.Level.ERROR, "Unexpected result for test case " + i);
        }
        if (fail) {
            throw new Exception("TEST FAILED");
        }
    }

    public static String testPredicateString(Predicate<String> filter) {
        String s = "data";
        if (filter.test(s)) {
            return "PASS";
        }
        return "BLOCK";
    }

    public static String testPredicateLong(Predicate<Long> filter) {
        Long l = Long.valueOf("1234");
        if (filter.test(l)) {
            return "PASS";
        }
        return "BLOCK";
    }

    @Test
    public void elCoerceToOtherTypeTest() throws Exception {
        boolean pass1;
        Time time = new Time(1000000000000L);
        boolean pass2 = false;
        try {
            NameValuePair[] timeNV = NameValuePair.buildUnaryNameValue(time);
            Object result = ExprEval.evaluateValueExpression("${A}", timeNV, Date.class);
            pass1 = ExprEval.compareClass(result, Date.class) && ExprEval.compareValue(result, time);
            result = ExprEval.evaluateValueExpression("#{null}", null, Date.class);
            pass2 = result == null;
        }
        catch (Exception e) {
            throw new Exception(e);
        }
        finally {
            ExprEval.cleanup();
        }
        if (!pass1 || !pass2) {
            throw new Exception("TEST FAILED");
        }
    }

    private void initializeNumberTable() {
        this.numberTable = new Hashtable();
        this.numberTable.put(Byte.class, Byte.valueOf(BYTE));
        this.numberTable.put(Short.class, Short.valueOf(SHORT));
        this.numberTable.put(Integer.class, Integer.valueOf(INTEGER));
        this.numberTable.put(Long.class, Long.valueOf(LONG));
        this.numberTable.put(Float.class, Float.valueOf(FLOAT));
        this.numberTable.put(Double.class, Double.valueOf(DOUBLE));
        this.numberTable.put(BigInteger.class, BigInteger.valueOf(Long.valueOf(BIGINT)));
        this.numberTable.put(BigDecimal.class, BigDecimal.valueOf(Double.valueOf(BIGDEC)));
    }

    private static enum greeting {
        hello,
        goodbye;

    }

    private static enum planets {
        MERCURY,
        VENUS,
        EARTH,
        MARS,
        JUPITER,
        SATURN,
        URANUS,
        NEPTUNE;

    }
}

