/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.core.rest.jsonb.cdi;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;

@ApplicationScoped
public class KeysProducer {
    private PublicKey publicKey;

    @PostConstruct
    private void loadKeys() {
        try {
            byte[] pubKeyData;
            try (InputStream keyIS = this.getClass().getResourceAsStream("/key.pub");){
                if (keyIS == null) {
                    throw new IllegalStateException("Failed to find /key.pub");
                }
                pubKeyData = keyIS.readAllBytes();
            }
            String pubKeyString = new String(pubKeyData, StandardCharsets.UTF_8);
            System.out.println(pubKeyString);
            byte[] keyData = Base64.getDecoder().decode(pubKeyString);
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(keyData);
            System.out.println(publicKeySpec);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            this.publicKey = keyFactory.generatePublic(publicKeySpec);
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException exception) {
            System.out.println(exception.getStackTrace());
        }
    }

    @Produces
    public PublicKey getPublicKey() {
        return this.publicKey;
    }
}

