/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.api.ContextService;

import ee.jakarta.tck.concurrent.common.fixed.counter.CounterRunnableTask;
import ee.jakarta.tck.concurrent.common.fixed.counter.WorkInterface;
import ee.jakarta.tck.concurrent.framework.junit.anno.Assertion;
import ee.jakarta.tck.concurrent.framework.junit.anno.Common;
import ee.jakarta.tck.concurrent.framework.junit.anno.Web;
import jakarta.annotation.Resource;
import jakarta.enterprise.concurrent.ContextService;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.util.HashMap;
import java.util.Map;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

@Web
@Common(value={Common.PACKAGE.FIXED_COUNTER})
public class ContextServiceTests {
    @Resource(lookup="java:comp/DefaultContextService")
    private ContextService context;

    @Deployment(name="ContextServiceTests")
    public static WebArchive createDeployment() {
        return (WebArchive)ShrinkWrap.create(WebArchive.class);
    }

    @Assertion(id="JAVADOC:5", strategy="Lookup default ContextService object and create proxy object using instance and interface.")
    public void contextServiceWithIntf() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            Runnable proxy = (Runnable)this.context.createContextualProxy((Object)new CounterRunnableTask(), Runnable.class);
            Assertions.assertNotNull((Object)proxy);
        }});
    }

    @Assertion(id="JAVADOC:6", strategy="Lookup default ContextService object and create proxy object using instance and interface. If the instance does not implement the specified interface, IllegalArgumentException will be thrown")
    public void contextServiceWithIntfAndIntfNoImplemented() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.createContextualProxy(new Object(), new Class[]{Runnable.class}));
    }

    @Assertion(id="JAVADOC:6", strategy="Lookup default ContextService object and create proxy object using instance and interface. If the instance is null, IllegalArgumentException will be thrown")
    public void contextServiceWithIntfAndInstanceIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.createContextualProxy(null, Runnable.class));
    }

    @Assertion(id="JAVADOC:7", strategy="Lookup default ContextService object and create proxy object using instance and multiple interfaces.")
    public void contextServiceWithMultiIntfs() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            Object proxy = this.context.createContextualProxy((Object)new CounterRunnableTask(), new Class[]{Runnable.class, WorkInterface.class});
            Assertions.assertNotNull((Object)proxy);
            Assertions.assertTrue((boolean)(proxy instanceof Runnable));
            Assertions.assertTrue((boolean)(proxy instanceof WorkInterface));
        }});
    }

    @Assertion(id="JAVADOC:8", strategy="Lookup default ContextService object and create proxy object using instance and multi interfaces.If the instance does not implement the specified interface, IllegalArgumentException will be thrown")
    public void contextServiceWithMultiIntfsAndIntfNoImplemented() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.createContextualProxy((Object)new CounterRunnableTask(), new Class[]{Runnable.class, WorkInterface.class, ManagedTaskListener.class}));
    }

    @Assertion(id="JAVADOC:8", strategy="Lookup default ContextService object and create proxy object using object and multi interfaces. If the instance is null, IllegalArgumentException will be thrown")
    public void contextServiceWithMultiIntfsAndInstanceIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.context.createContextualProxy(null, new Class[]{Runnable.class, WorkInterface.class}));
    }

    @Assertion(id="JAVADOC:9", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and interface.")
    public void contextServiceWithIntfAndProperties() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Runnable proxy = (Runnable)this.context.createContextualProxy((Object)new CounterRunnableTask(), execProps, Runnable.class);
            Assertions.assertNotNull((Object)proxy);
        }});
    }

    @Assertion(id="JAVADOC:11", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and multiple interfaces.")
    public void contextServiceWithMultiIntfsAndProperties() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = this.context.createContextualProxy((Object)new CounterRunnableTask(), execProps, new Class[]{Runnable.class, WorkInterface.class});
            Assertions.assertNotNull((Object)proxy);
            Assertions.assertTrue((boolean)(proxy instanceof Runnable));
            Assertions.assertTrue((boolean)(proxy instanceof WorkInterface));
        }});
    }

    @Assertion(id="JAVADOC:10", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and interface. If the instance does not implement the specified interface, IllegalArgumentException will be thrown")
    public void contextServiceWithIntfAndPropertiesAndIntfNoImplemented() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            this.context.createContextualProxy((Object)new CounterRunnableTask(), execProps, new Class[]{Runnable.class, ManagedTaskListener.class});
        });
    }

    @Assertion(id="JAVADOC:10", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and interfaces.If the instance is null, IllegalArgumentException will be thrown")
    public void contextServiceWithIntfsAndPropertiesAndInstanceIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            this.context.createContextualProxy(null, execProps, Runnable.class);
        });
    }

    @Assertion(id="JAVADOC:12", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and multiple interfaces.If the instance does not implement the specified interface, IllegalArgumentException will be thrown")
    public void contextServiceWithMultiIntfsAndPropertiesAndIntfNoImplemented() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            this.context.createContextualProxy((Object)new CounterRunnableTask(), execProps, new Class[]{Runnable.class, WorkInterface.class, ManagedTaskListener.class});
        });
    }

    @Assertion(id="JAVADOC:12", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and multiple interfaces. If the instance is null, IllegalArgumentException will be thrown")
    public void contextServiceWithMultiIntfsAndPropertiesAndInstanceIsNull() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("vendor_a.security.tokenexpiration", "15000");
            execProps.put("USE_PARENT_TRANSACTION", "true");
            this.context.createContextualProxy(null, execProps, new Class[]{Runnable.class, CounterRunnableTask.class});
        });
    }

    @Assertion(id="JAVADOC:13", strategy="Lookup default ContextService object and create proxy object using ExecutionProperties and multiple interfaces. Retrieve ExecutionProperties from proxy object and verify property value.")
    public void getExecutionProperties() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            HashMap<String, String> execProps = new HashMap<String, String>();
            execProps.put("USE_PARENT_TRANSACTION", "true");
            Object proxy = this.context.createContextualProxy((Object)new CounterRunnableTask(), execProps, new Class[]{Runnable.class, WorkInterface.class});
            Assertions.assertNotNull((Object)proxy);
            Map returnedExecProps = this.context.getExecutionProperties(proxy);
            Assertions.assertEquals((Object)"true", returnedExecProps.get("USE_PARENT_TRANSACTION"));
        }});
    }

    @Assertion(id="JAVADOC:14", strategy="Lookup default ContextService object. Retrieve ExecutionProperties from plain object.")
    public void getExecutionPropertiesNoProxy() {
        Assertions.assertAll((Executable[])new Executable[]{() -> {
            try {
                this.context.getExecutionProperties(new Object());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }});
    }
}

