/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.concurrent.framework;

import ee.jakarta.tck.concurrent.framework.ArquillianTests;
import ee.jakarta.tck.concurrent.framework.TestLogger;
import ee.jakarta.tck.concurrent.framework.TestUtil;
import ee.jakarta.tck.concurrent.framework.URLBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.Duration;
import java.util.Properties;

public abstract class TestClient
extends ArquillianTests {
    private static final TestLogger log = TestLogger.get(TestClient.class);
    public static final String SUCCESS = "SUCCESS";
    public static final String FAILURE = "FAILURE";
    public static final String TEST_METHOD = "testMethod";
    public static final String nl = System.lineSeparator();

    public void runTest(URL baseURL) {
        this.runTest(baseURL, this.testName);
    }

    public void runTest(URL baseURL, String testName) {
        try {
            this.assertSuccessfulURLResponse(URLBuilder.get().withBaseURL(baseURL).withPaths(this.getServletPath()).withTestName(testName).build(), null);
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("Tried to call runTest method without overwritting getServletPath() method.", e);
        }
    }

    public void runTest(URLBuilder builder) {
        this.assertSuccessfulURLResponse(builder.build(), null);
    }

    public String runTestWithResponse(URL baseURL, Properties props) {
        return this.runTestWithResponse(baseURL, this.testName, props);
    }

    public String runTestWithResponse(URL baseURL, String testName, Properties props) {
        try {
            return this.assertSuccessfulURLResponse(URLBuilder.get().withBaseURL(baseURL).withPaths(this.getServletPath()).withTestName(testName).build(), props);
        }
        catch (UnsupportedOperationException e) {
            throw new RuntimeException("Tried to call runTest method without overwritting getServletPath() method.", e);
        }
    }

    public String runTestWithResponse(URLBuilder builder, Properties props) {
        return this.assertSuccessfulURLResponse(builder.build(), props);
    }

    private String assertSuccessfulURLResponse(URL url, Properties props) {
        log.enter("assertSuccessfulURLResponse", "Calling application with URL=" + url.toString());
        boolean withProps = props != null;
        boolean pass = false;
        HttpURLConnection con = null;
        try {
            String line;
            con = (HttpURLConnection)url.openConnection();
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setConnectTimeout((int)Duration.ofSeconds(30L).toMillis());
            if (withProps) {
                con.setRequestMethod("POST");
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(TestUtil.toEncodedString(props));
                }
            } else {
                con.setRequestMethod("GET");
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder outputBuilder = new StringBuilder();
            while ((line = br.readLine()) != null) {
                outputBuilder.append(line).append(nl);
                if (!line.contains(SUCCESS)) continue;
                pass = true;
            }
            log.exit("assertSuccessfulURLResponse", "Response code: " + con.getResponseCode(), "Response body: " + outputBuilder.toString());
            this.assertTrue("Connection returned a response code that was greater than 400", con.getResponseCode() < 400);
            this.assertTrue("Output did not contain successful message: SUCCESS", pass);
            String string = outputBuilder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException("Exception: " + e.getClass().getName() + " requesting URL=" + url.toString(), e);
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    protected String getServletPath() {
        throw new UnsupportedOperationException("Subclass did not override the getServletPath method");
    }

    protected void assertStringInResponse(String message, String expected, String resp) {
        this.assertTrue(message, resp.toLowerCase().contains(expected.toLowerCase()));
    }
}

